/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument;

import java.util.concurrent.Callable;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;

public class TraceCallable<V>
implements Callable<V> {
    private final Callable<V> impl;
    private final Span parent;

    TraceCallable(Callable<V> impl) {
        this(Trace.currentTrace(), impl);
    }

    TraceCallable(Span parent, Callable<V> impl) {
        this.impl = impl;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        if (this.parent != null) {
            Span chunk = Trace.startThread(this.parent, Thread.currentThread().getName());
            try {
                V v = this.impl.call();
                return v;
            }
            finally {
                Trace.endThread(chunk);
            }
        }
        return this.impl.call();
    }
}

