/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import sdsu.io.ChunkReader;
import sdsu.io.CommentParser;
import sdsu.io.LabeledObject;
import sdsu.util.LabeledData;

public class StringizableReader
implements Enumeration {
    public static final String META_SEPARATOR_KEY = "DataSeparator";
    public static final String META_COMMENT_CHAR_KEY = "CommentCharacter";
    public static final String META_DATA_CHAR_KEY = "MetaDataCharacter";
    public static final char DEFAULT_COMMENT_CHAR = '#';
    public static final char DEFAULT_METADATA_CHAR = '$';
    public static final String DEFAULT_DATA_BLOCK_SEPARATOR = "@DataBlockSeparator@";
    protected ChunkReader rawData;
    protected LabeledObject theData;
    private char commentChar = (char)35;
    private char metaDataChar = (char)36;
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final int EOF = -1;

    public StringizableReader(Reader reader) throws IOException {
        String string = DEFAULT_DATA_BLOCK_SEPARATOR;
        PushbackReader pushbackReader = new PushbackReader(reader, 2);
        CommentParser commentParser = new CommentParser(pushbackReader, this.commentChar, this.metaDataChar);
        commentParser.readComment();
        LabeledData labeledData = commentParser.readDataComment();
        string = labeledData.getData(META_SEPARATOR_KEY, DEFAULT_DATA_BLOCK_SEPARATOR);
        if (((Hashtable)labeledData).containsKey(META_COMMENT_CHAR_KEY)) {
            this.commentChar = labeledData.getData(META_COMMENT_CHAR_KEY).charAt(0);
        }
        if (((Hashtable)labeledData).containsKey(META_DATA_CHAR_KEY)) {
            this.metaDataChar = labeledData.getData(META_DATA_CHAR_KEY).charAt(0);
        }
        BufferedReader bufferedReader = new BufferedReader(pushbackReader);
        this.rawData = new ChunkReader(bufferedReader, string);
    }

    public StringizableReader(String string) throws IOException {
        this(new StringReader(string));
    }

    public static StringizableReader fromFile(String string) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader, 8000);
        return new StringizableReader(bufferedReader);
    }

    public String getDataComment() {
        return this.theData.getComment();
    }

    public String getDataLabel() {
        return this.theData.getLabel();
    }

    public boolean hasMoreElements() {
        return this.rawData.hasMoreElements();
    }

    public Object nextElement() {
        try {
            String string = (String)this.rawData.nextElement();
            this.theData = LabeledObject.fromString(string);
            return this.theData.getObject();
        }
        catch (Exception exception) {
            throw new NoSuchElementException("Error in reading input: " + exception.getMessage());
        }
    }

    public void setSeparator(String string) {
        this.rawData.setSeparator(string);
    }
}

