/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkEngineConf;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.running.PigInputFormatSpark;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.tools.pigstats.spark.SparkCounters;
import org.apache.pig.tools.pigstats.spark.SparkPigStatusReporter;
import org.apache.pig.tools.pigstats.spark.SparkStatsUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Tuple2;
import scala.runtime.AbstractFunction1;

public class LoadConverter
implements RDDConverter<Tuple, Tuple, POLoad> {
    private static Log LOG = LogFactory.getLog(LoadConverter.class);
    private PigContext pigContext;
    private PhysicalPlan physicalPlan;
    private SparkContext sparkContext;
    private JobConf jobConf;
    private SparkEngineConf sparkEngineConf;

    public LoadConverter(PigContext pigContext, PhysicalPlan physicalPlan, SparkContext sparkContext, JobConf jobConf, SparkEngineConf sparkEngineConf) {
        this.pigContext = pigContext;
        this.physicalPlan = physicalPlan;
        this.sparkContext = sparkContext;
        this.jobConf = jobConf;
        this.sparkEngineConf = sparkEngineConf;
    }

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessorRdds, POLoad op) throws IOException {
        LoadConverter.configureLoader(this.physicalPlan, op, this.jobConf);
        this.jobConf.set("mapreduce.input.fileinputformat.inputdir", op.getLFile().getFileName());
        if (LoadConverter.hasMergeJoinSuccessor(op)) {
            this.jobConf.set("pig.noSplitCombination", "true");
        }
        UDFContext.getUDFContext().serialize((Configuration)this.jobConf);
        RDD hadoopRDD = this.sparkContext.newAPIHadoopRDD((Configuration)this.jobConf, PigInputFormatSpark.class, Text.class, Tuple.class);
        this.registerUdfFiles();
        ToTupleFunction ttf = new ToTupleFunction(this.sparkEngineConf);
        boolean disableCounter = this.jobConf.getBoolean("pig.disable.counter", false);
        if (!op.isTmpLoad() && !disableCounter) {
            String counterName = SparkStatsUtil.getCounterName(op);
            SparkPigStatusReporter counterReporter = SparkPigStatusReporter.getInstance();
            if (counterReporter.getCounters() != null) {
                counterReporter.getCounters().createCounter("MultiInputCounters", counterName);
            }
            ttf.setDisableCounter(disableCounter);
            ttf.setCounterGroupName("MultiInputCounters");
            ttf.setCounterName(counterName);
            ttf.setSparkCounters(SparkPigStatusReporter.getInstance().getCounters());
        }
        return hadoopRDD.map((Function1)ttf, SparkUtil.getManifest(Tuple.class));
    }

    private void registerUdfFiles() throws MalformedURLException {
        Map<String, File> scriptFiles = this.pigContext.getScriptFiles();
        for (Map.Entry<String, File> scriptFile : scriptFiles.entrySet()) {
            File script = scriptFile.getValue();
            if (!script.exists()) continue;
            this.sparkContext.addFile(script.toURI().toURL().toExternalForm());
        }
    }

    private static JobConf configureLoader(PhysicalPlan physicalPlan, POLoad poLoad, JobConf jobConf) throws IOException {
        Job job = new Job((Configuration)jobConf);
        LoadFunc loadFunc = poLoad.getLoadFunc();
        loadFunc.setLocation(poLoad.getLFile().getFileName(), job);
        ArrayList inpTargets = Lists.newArrayList();
        ArrayList inpSignatures = Lists.newArrayList();
        ArrayList inpLimits = Lists.newArrayList();
        List<POLoad> loadSuccessors = physicalPlan.getSuccessors(poLoad);
        ArrayList loadSuccessorsKeys = Lists.newArrayList();
        if (loadSuccessors != null) {
            for (PhysicalOperator physicalOperator : loadSuccessors) {
                loadSuccessorsKeys.add(physicalOperator.getOperatorKey());
            }
        }
        inpTargets.add(loadSuccessorsKeys);
        inpSignatures.add(poLoad.getSignature());
        inpLimits.add(poLoad.getLimit());
        PhysicalPlan pp = poLoad.getParentPlan();
        ArrayList<POLoad> arrayList = new ArrayList<POLoad>();
        poLoad.setParentPlan(null);
        arrayList.add(poLoad);
        jobConf.set("pig.loads", ObjectSerializer.serialize(arrayList));
        poLoad.setParentPlan(pp);
        jobConf.set("pig.inpTargets", ObjectSerializer.serialize(inpTargets));
        jobConf.set("pig.inpSignatures", ObjectSerializer.serialize(inpSignatures));
        jobConf.set("pig.inpLimits", ObjectSerializer.serialize(inpLimits));
        return jobConf;
    }

    private static boolean hasMergeJoinSuccessor(PhysicalOperator op) {
        if (op == null || op.getParentPlan() == null) {
            return false;
        }
        List<PhysicalOperator> successors = op.getParentPlan().getSuccessors(op);
        if (successors == null) {
            return false;
        }
        for (PhysicalOperator successor : successors) {
            if (successor instanceof POMergeJoin) {
                return true;
            }
            if (!LoadConverter.hasMergeJoinSuccessor(successor)) continue;
            return true;
        }
        return false;
    }

    private static class ToTupleFunction
    extends AbstractFunction1<Tuple2<Text, Tuple>, Tuple>
    implements Function1<Tuple2<Text, Tuple>, Tuple>,
    Serializable {
        private String counterGroupName;
        private String counterName;
        private SparkCounters sparkCounters;
        private boolean disableCounter;
        private SparkEngineConf sparkEngineConf;
        private boolean initialized;

        public ToTupleFunction(SparkEngineConf sparkEngineConf) {
            this.sparkEngineConf = sparkEngineConf;
        }

        public Tuple apply(Tuple2<Text, Tuple> v1) {
            if (!this.initialized) {
                long partitionId = TaskContext.get().partitionId();
                Configuration jobConf = (Configuration)PigMapReduce.sJobConfInternal.get();
                jobConf.set("mapreduce.task.index", Long.toString(partitionId));
                jobConf.set("mapred.task.id", Long.toString(partitionId));
                this.initialized = true;
            }
            if (this.sparkCounters != null && !this.disableCounter) {
                this.sparkCounters.increment(this.counterGroupName, this.counterName, 1L);
            }
            return (Tuple)v1._2();
        }

        public void setCounterGroupName(String counterGroupName) {
            this.counterGroupName = counterGroupName;
        }

        public void setCounterName(String counterName) {
            this.counterName = counterName;
        }

        public void setSparkCounters(SparkCounters sparkCounters) {
            this.sparkCounters = sparkCounters;
        }

        public void setDisableCounter(boolean disableCounter) {
            this.disableCounter = disableCounter;
        }
    }
}

