/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.zookeeper;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.accumulo.fate.zookeeper.DistributedReadWriteLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;

public class ZooQueueLock
extends org.apache.accumulo.fate.zookeeper.ZooQueueLock {
    public ZooQueueLock(String path, boolean ephemeral) throws KeeperException, InterruptedException {
        super(ZooReaderWriter.getRetryingInstance(), path, ephemeral);
    }

    public static void main(String[] args) throws InterruptedException, KeeperException {
        ZooQueueLock lock = new ZooQueueLock("/lock", true);
        DistributedReadWriteLock rlocker = new DistributedReadWriteLock((DistributedReadWriteLock.QueueLock)lock, "reader".getBytes());
        DistributedReadWriteLock wlocker = new DistributedReadWriteLock((DistributedReadWriteLock.QueueLock)lock, "wlocker".getBytes());
        Lock readLock = rlocker.readLock();
        readLock.lock();
        Lock readLock2 = rlocker.readLock();
        readLock2.lock();
        Lock writeLock = wlocker.writeLock();
        if (writeLock.tryLock(100L, TimeUnit.MILLISECONDS)) {
            throw new RuntimeException("Write lock achieved during read lock!");
        }
        readLock.unlock();
        readLock2.unlock();
        writeLock.lock();
        if (readLock.tryLock(100L, TimeUnit.MILLISECONDS)) {
            throw new RuntimeException("Read lock achieved during write lock!");
        }
        Lock writeLock2 = DistributedReadWriteLock.recoverLock((DistributedReadWriteLock.QueueLock)lock, (byte[])"wlocker".getBytes());
        writeLock2.unlock();
        readLock.lock();
        System.out.println("success");
    }
}

