/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class TaskAttemptStartedEvent
implements HistoryEvent {
    private TezTaskAttemptID taskAttemptId;
    private String inProgressLogsUrl;
    private String completedLogsUrl;
    private String vertexName;
    private long launchTime;
    private ContainerId containerId;
    private NodeId nodeId;
    private String nodeHttpAddress;

    public TaskAttemptStartedEvent(TezTaskAttemptID taId, String vertexName, long launchTime, ContainerId containerId, NodeId nodeId, String inProgressLogsUrl, String completedLogsUrl, String nodeHttpAddress) {
        this.taskAttemptId = taId;
        this.vertexName = vertexName;
        this.launchTime = launchTime;
        this.containerId = containerId;
        this.nodeId = nodeId;
        this.inProgressLogsUrl = inProgressLogsUrl;
        this.completedLogsUrl = completedLogsUrl;
        this.nodeHttpAddress = nodeHttpAddress;
    }

    public TaskAttemptStartedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_STARTED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskAttemptStartedProto toProto() {
        RecoveryProtos.TaskAttemptStartedProto.Builder builder = RecoveryProtos.TaskAttemptStartedProto.newBuilder();
        builder.setTaskAttemptId(this.taskAttemptId.toString()).setStartTime(this.launchTime).setContainerId(this.containerId.toString()).setNodeId(this.nodeId.toString());
        return builder.build();
    }

    public void fromProto(RecoveryProtos.TaskAttemptStartedProto proto) {
        this.taskAttemptId = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        this.launchTime = proto.getStartTime();
        this.containerId = ConverterUtils.toContainerId((String)proto.getContainerId());
        this.nodeId = ConverterUtils.toNodeId((String)proto.getNodeId());
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.TaskAttemptStartedProto proto = (RecoveryProtos.TaskAttemptStartedProto)inputStream.readMessage(RecoveryProtos.TaskAttemptStartedProto.PARSER, null);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskAttemptId=" + this.taskAttemptId + ", startTime=" + this.launchTime + ", containerId=" + this.containerId + ", nodeId=" + this.nodeId;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public long getStartTime() {
        return this.launchTime;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getInProgressLogsUrl() {
        return this.inProgressLogsUrl;
    }

    public String getCompletedLogsUrl() {
        return this.completedLogsUrl;
    }

    public String getNodeHttpAddress() {
        return this.nodeHttpAddress;
    }
}

