/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.WeightedRandomRouterPolicy;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalityRouterPolicy
extends WeightedRandomRouterPolicy {
    public static final Logger LOG = LoggerFactory.getLogger(LocalityRouterPolicy.class);
    private SubClusterResolver resolver;
    private List<SubClusterId> enabledSCs;

    @Override
    public void reinitialize(FederationPolicyInitializationContext policyContext) throws FederationPolicyInitializationException {
        super.reinitialize(policyContext);
        this.resolver = policyContext.getFederationSubclusterResolver();
        Map<SubClusterIdInfo, Float> weights = this.getPolicyInfo().getRouterPolicyWeights();
        this.enabledSCs = new ArrayList<SubClusterId>();
        for (Map.Entry<SubClusterIdInfo, Float> entry : weights.entrySet()) {
            if (entry == null || !(entry.getValue().floatValue() > 0.0f)) continue;
            this.enabledSCs.add(entry.getKey().toId());
        }
    }

    @Override
    public SubClusterId getHomeSubcluster(ApplicationSubmissionContext appSubmissionContext, List<SubClusterId> blackListSubClusters) throws YarnException {
        this.validate(appSubmissionContext);
        List rrList = appSubmissionContext.getAMContainerResourceRequests();
        if (rrList == null || rrList.isEmpty() || rrList.size() == 1 && ResourceRequest.isAnyLocation((String)((ResourceRequest)rrList.get(0)).getResourceName())) {
            return super.getHomeSubcluster(appSubmissionContext, blackListSubClusters);
        }
        if (rrList.size() != 3) {
            throw new FederationPolicyException("Invalid number of resource requests: " + rrList.size());
        }
        Map<SubClusterId, SubClusterInfo> activeSubClusters = this.getActiveSubclusters();
        ArrayList<SubClusterId> validSubClusters = new ArrayList<SubClusterId>(activeSubClusters.keySet());
        FederationPolicyUtils.validateSubClusterAvailability(validSubClusters, blackListSubClusters);
        if (blackListSubClusters != null) {
            validSubClusters.removeAll(blackListSubClusters);
        }
        try {
            SubClusterId targetId = null;
            ResourceRequest nodeRequest = null;
            ResourceRequest rackRequest = null;
            ResourceRequest anyRequest = null;
            for (ResourceRequest rr : rrList) {
                try {
                    targetId = this.resolver.getSubClusterForNode(rr.getResourceName());
                    nodeRequest = rr;
                }
                catch (YarnException e) {
                    LOG.error("Cannot resolve node : {}", (Object)e.getLocalizedMessage());
                }
                try {
                    this.resolver.getSubClustersForRack(rr.getResourceName());
                    rackRequest = rr;
                }
                catch (YarnException e) {
                    LOG.error("Cannot resolve rack : {}", (Object)e.getLocalizedMessage());
                }
                if (!ResourceRequest.isAnyLocation((String)rr.getResourceName())) continue;
                anyRequest = rr;
            }
            if (nodeRequest == null) {
                throw new YarnException("Missing node request");
            }
            if (rackRequest == null) {
                throw new YarnException("Missing rack request");
            }
            if (anyRequest == null) {
                throw new YarnException("Missing any request");
            }
            LOG.info("Node request: " + nodeRequest.getResourceName() + ", Rack request: " + rackRequest.getResourceName() + ", Any request: " + anyRequest.getResourceName());
            if (validSubClusters.contains(targetId) && this.enabledSCs.contains(targetId)) {
                LOG.info("Node {} is in SubCluster: {}", (Object)nodeRequest.getResourceName(), (Object)targetId);
                return targetId;
            }
            throw new YarnException("The node " + nodeRequest.getResourceName() + " is in a blacklist SubCluster or not active. ");
        }
        catch (YarnException e) {
            LOG.error("Validating resource requests failed, Falling back to WeightedRandomRouterPolicy placement: " + e.getMessage());
            ResourceRequest amReq = (ResourceRequest)Records.newRecord(ResourceRequest.class);
            amReq.setPriority(appSubmissionContext.getPriority());
            amReq.setResourceName("*");
            amReq.setCapability(appSubmissionContext.getResource());
            amReq.setNumContainers(1);
            amReq.setRelaxLocality(true);
            amReq.setNodeLabelExpression(appSubmissionContext.getNodeLabelExpression());
            amReq.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED));
            appSubmissionContext.setAMContainerResourceRequests(Collections.singletonList(amReq));
            return super.getHomeSubcluster(appSubmissionContext, blackListSubClusters);
        }
    }
}

