/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.MetaCellComparator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFile.class);
    @Rule
    public TestName testName = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestHFile.class);
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static String ROOT_DIR = TEST_UTIL.getDataTestDir("TestHFile").toString();
    private final int minBlockSize = 512;
    private static String localFormatter = "%010d";
    private static CacheConfig cacheConf;
    private static Configuration conf;
    private static FileSystem fs;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        cacheConf = new CacheConfig(conf);
        fs = TEST_UTIL.getTestFileSystem();
    }

    public static HFile.Reader createReaderFromStream(ReaderContext context, CacheConfig cacheConf, Configuration conf) throws IOException {
        HFileInfo fileInfo = new HFileInfo(context, conf);
        HFile.Reader preadReader = HFile.createReader((ReaderContext)context, (HFileInfo)fileInfo, (CacheConfig)cacheConf, (Configuration)conf);
        fileInfo.initMetaAndIndex(preadReader);
        preadReader.close();
        context = new ReaderContextBuilder().withFileSystemAndPath((FileSystem)context.getFileSystem(), context.getFilePath()).withReaderType(ReaderContext.ReaderType.STREAM).build();
        HFile.Reader streamReader = HFile.createReader((ReaderContext)context, (HFileInfo)fileInfo, (CacheConfig)cacheConf, (Configuration)conf);
        return streamReader;
    }

    private ByteBuffAllocator initAllocator(boolean reservoirEnabled, int bufSize, int bufCount, int minAllocSize) {
        Configuration that = HBaseConfiguration.create((Configuration)conf);
        that.setInt("hbase.server.allocator.buffer.size", bufSize);
        that.setInt("hbase.server.allocator.max.buffer.count", bufCount);
        that.setInt("hbase.server.allocator.minimal.allocate.size", minAllocSize);
        return ByteBuffAllocator.create((Configuration)that, (boolean)reservoirEnabled);
    }

    private void fillByteBuffAllocator(ByteBuffAllocator alloc, int bufCount) {
        ArrayList<SingleByteBuff> buffs = new ArrayList<SingleByteBuff>();
        for (int i = 0; i < bufCount; ++i) {
            buffs.add(alloc.allocateOneBuffer());
            Assert.assertEquals((long)alloc.getFreeBufferCount(), (long)0L);
        }
        buffs.forEach(ByteBuff::release);
        Assert.assertEquals((long)alloc.getFreeBufferCount(), (long)bufCount);
    }

    @Test
    public void testReaderWithoutBlockCache() throws Exception {
        int bufCount = 32;
        ByteBuffAllocator alloc = this.initAllocator(true, 65536, bufCount, 0);
        this.fillByteBuffAllocator(alloc, bufCount);
        Path path = this.writeStoreFile();
        try {
            this.readStoreFile(path, conf, alloc);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertEquals((long)bufCount, (long)alloc.getFreeBufferCount());
        alloc.clean();
    }

    @Test
    public void testReaderWithLRUBlockCache() throws Exception {
        HFileBlock block;
        int bufCount = 1024;
        int blockSize = 65536;
        ByteBuffAllocator alloc = this.initAllocator(true, bufCount, blockSize, 0);
        this.fillByteBuffAllocator(alloc, bufCount);
        Path storeFilePath = this.writeStoreFile();
        LruBlockCache lru = new LruBlockCache(0x2000000L, (long)blockSize, true, conf);
        CacheConfig cacheConfig = new CacheConfig(conf, null, (BlockCache)lru, alloc);
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)storeFilePath, (CacheConfig)cacheConfig, (boolean)true, (Configuration)conf);
        for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
            BlockCacheKey key = new BlockCacheKey(storeFilePath.getName(), offset);
            block = reader.readBlock(offset, -1L, true, true, false, true, null, null);
            Cacheable cachedBlock = lru.getBlock(key, false, false, true);
            Assert.assertNotNull((Object)cachedBlock);
            Assert.assertTrue((boolean)(cachedBlock instanceof HFileBlock));
            Assert.assertFalse((boolean)((HFileBlock)cachedBlock).isSharedMem());
            Assert.assertEquals((long)bufCount, (long)alloc.getFreeBufferCount());
            block.release();
        }
        reader.close();
        Assert.assertEquals((long)bufCount, (long)alloc.getFreeBufferCount());
        alloc.clean();
        lru.shutdown();
    }

    private BlockCache initCombinedBlockCache(String l1CachePolicy) {
        Configuration that = HBaseConfiguration.create((Configuration)conf);
        that.setFloat("hbase.bucketcache.size", 32.0f);
        that.set("hbase.bucketcache.ioengine", "offheap");
        that.set("hfile.block.cache.policy", l1CachePolicy);
        BlockCache bc = BlockCacheFactory.createBlockCache((Configuration)that);
        Assert.assertNotNull((Object)bc);
        Assert.assertTrue((boolean)(bc instanceof CombinedBlockCache));
        return bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderWithCombinedBlockCache() throws Exception {
        int bufCount = 1024;
        int blockSize = 65536;
        ByteBuffAllocator alloc = this.initAllocator(true, bufCount, blockSize, 0);
        this.fillByteBuffAllocator(alloc, bufCount);
        Path storeFilePath = this.writeStoreFile();
        BlockCache combined = this.initCombinedBlockCache("LRU");
        conf.setBoolean("hbase.rs.evictblocksonclose", true);
        CacheConfig cacheConfig = new CacheConfig(conf, null, combined, alloc);
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)storeFilePath, (CacheConfig)cacheConfig, (boolean)true, (Configuration)conf);
        long offset = 0L;
        while (offset < reader.getTrailer().getLoadOnOpenDataOffset()) {
            BlockCacheKey key = new BlockCacheKey(storeFilePath.getName(), offset);
            HFileBlock block = reader.readBlock(offset, -1L, true, true, false, true, null, null);
            offset += (long)block.getOnDiskSizeWithHeader();
            Cacheable cachedBlock = combined.getBlock(key, false, false, true);
            try {
                Assert.assertNotNull((Object)cachedBlock);
                Assert.assertTrue((boolean)(cachedBlock instanceof HFileBlock));
                HFileBlock hfb = (HFileBlock)cachedBlock;
                if (hfb.getBlockType().isData()) {
                    Assert.assertTrue((boolean)hfb.isSharedMem());
                } else {
                    Assert.assertFalse((boolean)hfb.isSharedMem());
                }
            }
            finally {
                cachedBlock.release();
            }
            block.release();
        }
        reader.close();
        combined.shutdown();
        Assert.assertEquals((long)bufCount, (long)alloc.getFreeBufferCount());
        alloc.clean();
    }

    private void readStoreFile(Path storeFilePath, Configuration conf, ByteBuffAllocator alloc) throws Exception {
        HFileBlock block;
        CacheConfig cache = new CacheConfig(conf, null, null, alloc);
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)storeFilePath, (CacheConfig)cache, (boolean)true, (Configuration)conf);
        for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
            block = reader.readBlock(offset, -1L, false, true, false, true, null, null);
            block.release();
        }
        reader.close();
    }

    private Path writeStoreFile() throws IOException {
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), "TestHFile");
        HFileContext meta = new HFileContextBuilder().withBlockSize(65536).build();
        StoreFileWriter sfw = new StoreFileWriter.Builder(conf, fs).withOutputDir(storeFileParentDir).withFileContext(meta).build();
        int rowLen = 32;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            byte[] k = RandomKeyValueUtil.randomOrderedKey(rand, i);
            byte[] v = RandomKeyValueUtil.randomValue(rand);
            int cfLen = ((Random)rand).nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, ((Random)rand).nextLong(), TestHFile.generateKeyType(rand), v, 0, v.length);
            sfw.append((Cell)kv);
        }
        sfw.close();
        return sfw.getPath();
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }

    @Test
    public void testEmptyHFile() throws IOException {
        Path f = new Path(ROOT_DIR, this.testName.getMethodName());
        HFileContext context = new HFileContextBuilder().withIncludesTags(false).build();
        HFile.Writer w = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withPath(fs, f).withFileContext(context).create();
        w.close();
        HFile.Reader r = HFile.createReader((FileSystem)fs, (Path)f, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
        Assert.assertFalse((boolean)r.getFirstKey().isPresent());
        Assert.assertFalse((boolean)r.getLastKey().isPresent());
    }

    @Test
    public void testCorrupt0LengthHFile() throws IOException {
        Path f = new Path(ROOT_DIR, this.testName.getMethodName());
        FSDataOutputStream fsos = fs.create(f);
        fsos.close();
        try {
            HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)f, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
        }
        catch (IllegalArgumentException | CorruptHFileException che) {
            return;
        }
        Assert.fail((String)"Should have thrown exception");
    }

    @Test
    public void testCorruptOutOfOrderHFileWrite() throws IOException {
        Path path = new Path(ROOT_DIR, this.testName.getMethodName());
        FSDataOutputStream mockedOutputStream = (FSDataOutputStream)Mockito.mock(FSDataOutputStream.class);
        String columnFamily = "MyColumnFamily";
        String tableName = "MyTableName";
        HFileContext fileContext = new HFileContextBuilder().withHFileName(this.testName.getMethodName() + "HFile").withBlockSize(512).withColumnFamily(Bytes.toBytes((String)columnFamily)).withTableName(Bytes.toBytes((String)tableName)).withHBaseCheckSum(false).withCompression(Compression.Algorithm.NONE).withCompressTags(false).build();
        HFileWriterImpl writer = new HFileWriterImpl(conf, cacheConf, path, mockedOutputStream, fileContext);
        CellBuilder cellBuilder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
        byte[] row = Bytes.toBytes((String)"foo");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] cf = Bytes.toBytes((String)columnFamily);
        byte[] val = Bytes.toBytes((String)"fooVal");
        long firstTS = 100L;
        long secondTS = 101L;
        Cell firstCell = cellBuilder.setRow(row).setValue(val).setTimestamp(firstTS).setQualifier(qualifier).setFamily(cf).setType(Cell.Type.Put).build();
        Cell secondCell = cellBuilder.setRow(row).setValue(val).setTimestamp(secondTS).setQualifier(qualifier).setFamily(cf).setType(Cell.Type.Put).build();
        writer.append(firstCell);
        try {
            writer.append(secondCell);
        }
        catch (IOException ie) {
            String message = ie.getMessage();
            Assert.assertTrue((boolean)message.contains("not lexically larger"));
            Assert.assertTrue((boolean)message.contains(tableName));
            Assert.assertTrue((boolean)message.contains(columnFamily));
            return;
        }
        Assert.fail((String)"Exception wasn't thrown even though Cells were appended in the wrong order!");
    }

    public static void truncateFile(FileSystem fs, Path src, Path dst) throws IOException {
        FileStatus fst = fs.getFileStatus(src);
        long len = fst.getLen();
        FSDataOutputStream fdos = fs.create(dst);
        byte[] buf = new byte[(int)(len /= 2L)];
        FSDataInputStream fdis = fs.open(src);
        fdis.read(buf);
        fdos.write(buf);
        fdis.close();
        fdos.close();
    }

    @Test
    public void testCorruptTruncatedHFile() throws IOException {
        Path f = new Path(ROOT_DIR, this.testName.getMethodName());
        HFileContext context = new HFileContextBuilder().build();
        HFile.Writer w = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withPath(fs, f).withFileContext(context).create();
        this.writeSomeRecords(w, 0, 100, false);
        w.close();
        Path trunc = new Path(f.getParent(), "trucated");
        TestHFile.truncateFile(fs, w.getPath(), trunc);
        try {
            HFile.createReader((FileSystem)fs, (Path)trunc, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
        }
        catch (IllegalArgumentException | CorruptHFileException che) {
            return;
        }
        Assert.fail((String)"Should have thrown exception");
    }

    private int writeSomeRecords(HFile.Writer writer, int start, int n, boolean useTags) throws IOException {
        String value = "value";
        for (int i = start; i < start + n; ++i) {
            KeyValue kv;
            String key = String.format(localFormatter, i);
            if (useTags) {
                ArrayBackedTag t = new ArrayBackedTag(1, "myTag1");
                Tag[] tags = new Tag[]{t};
                kv = new KeyValue(Bytes.toBytes((String)key), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Long.MAX_VALUE, Bytes.toBytes((String)(value + key)), tags);
                writer.append((Cell)kv);
                continue;
            }
            kv = new KeyValue(Bytes.toBytes((String)key), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)(value + key)));
            writer.append((Cell)kv);
        }
        return start + n;
    }

    private void readAllRecords(HFileScanner scanner) throws IOException {
        this.readAndCheckbytes(scanner, 0, 100);
    }

    private int readAndCheckbytes(HFileScanner scanner, int start, int n) throws IOException {
        int i;
        String value = "value";
        for (i = start; i < start + n; ++i) {
            ByteBuffer key = ByteBuffer.wrap(((KeyValue)scanner.getKey()).getKey());
            ByteBuffer val = scanner.getValue();
            String keyStr = String.format(localFormatter, i);
            String valStr = value + keyStr;
            KeyValue kv = new KeyValue(Bytes.toBytes((String)keyStr), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)valStr));
            byte[] keyBytes = new KeyValue.KeyOnlyKeyValue(Bytes.toBytes((ByteBuffer)key), 0, Bytes.toBytes((ByteBuffer)key).length).getKey();
            Assert.assertTrue((String)("bytes for keys do not match " + keyStr + " " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key))), (boolean)Arrays.equals(kv.getKey(), keyBytes));
            byte[] valBytes = Bytes.toBytes((ByteBuffer)val);
            Assert.assertTrue((String)("bytes for vals do not match " + valStr + " " + Bytes.toString((byte[])valBytes)), (boolean)Arrays.equals(Bytes.toBytes((String)valStr), valBytes));
            if (!scanner.next()) break;
        }
        Assert.assertEquals((long)i, (long)(start + n - 1));
        return start + n;
    }

    private byte[] getSomeKey(int rowId) {
        KeyValue kv = new KeyValue(String.format(localFormatter, rowId).getBytes(), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Long.MAX_VALUE, KeyValue.Type.Put);
        return kv.getKey();
    }

    private void writeRecords(HFile.Writer writer, boolean useTags) throws IOException {
        this.writeSomeRecords(writer, 0, 100, useTags);
        writer.close();
    }

    private FSDataOutputStream createFSOutput(Path name) throws IOException {
        FSDataOutputStream fout = fs.create(name);
        return fout;
    }

    void basicWithSomeCodec(String codec, boolean useTags) throws IOException {
        if (useTags) {
            conf.setInt("hfile.format.version", 3);
        }
        Path ncHFile = new Path(ROOT_DIR, "basic.hfile." + codec.toString() + useTags);
        FSDataOutputStream fout = this.createFSOutput(ncHFile);
        HFileContext meta = new HFileContextBuilder().withBlockSize(512).withCompression(HFileWriterImpl.compressionByName((String)codec)).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withOutputStream(fout).withFileContext(meta).create();
        LOG.info(Objects.toString(writer));
        this.writeRecords(writer, useTags);
        fout.close();
        FSDataInputStream fin = fs.open(ncHFile);
        ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(fs, ncHFile).build();
        HFile.Reader reader = TestHFile.createReaderFromStream(context, cacheConf, conf);
        System.out.println(cacheConf.toString());
        HFileScanner scanner = reader.getScanner(true, false);
        scanner.seekTo();
        this.readAllRecords(scanner);
        int seekTo = scanner.seekTo((Cell)KeyValueUtil.createKeyValueFromKey((byte[])this.getSomeKey(50)));
        System.out.println(seekTo);
        Assert.assertTrue((String)"location lookup failed", (scanner.seekTo((Cell)KeyValueUtil.createKeyValueFromKey((byte[])this.getSomeKey(50))) == 0 ? 1 : 0) != 0);
        ByteBuffer readKey = ByteBuffer.wrap(((KeyValue)scanner.getKey()).getKey());
        Assert.assertTrue((String)"seeked key does not match", (boolean)Arrays.equals(this.getSomeKey(50), Bytes.toBytes((ByteBuffer)readKey)));
        scanner.seekTo((Cell)KeyValueUtil.createKeyValueFromKey((byte[])this.getSomeKey(0)));
        ByteBuffer val1 = scanner.getValue();
        scanner.seekTo((Cell)KeyValueUtil.createKeyValueFromKey((byte[])this.getSomeKey(0)));
        ByteBuffer val2 = scanner.getValue();
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((ByteBuffer)val1), Bytes.toBytes((ByteBuffer)val2)));
        reader.close();
        fin.close();
        fs.delete(ncHFile, true);
    }

    @Test
    public void testTFileFeatures() throws IOException {
        this.testHFilefeaturesInternals(false);
        this.testHFilefeaturesInternals(true);
    }

    protected void testHFilefeaturesInternals(boolean useTags) throws IOException {
        this.basicWithSomeCodec("none", useTags);
        this.basicWithSomeCodec("gz", useTags);
    }

    private void writeNumMetablocks(HFile.Writer writer, int n) {
        for (int i = 0; i < n; ++i) {
            writer.appendMetaBlock("HFileMeta" + i, new Writable(){
                private int val;

                public Writable setVal(int val) {
                    this.val = val;
                    return this;
                }

                public void write(DataOutput out) throws IOException {
                    out.write(("something to test" + this.val).getBytes());
                }

                public void readFields(DataInput in) throws IOException {
                }
            }.setVal(i));
        }
    }

    private void someTestingWithMetaBlock(HFile.Writer writer) {
        this.writeNumMetablocks(writer, 10);
    }

    private void readNumMetablocks(HFile.Reader reader, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            ByteBuff actual = reader.getMetaBlock("HFileMeta" + i, false).getBufferWithoutHeader();
            ByteBuffer expected = ByteBuffer.wrap(("something to test" + i).getBytes());
            Assert.assertEquals((String)"failed to match metadata", (Object)Bytes.toStringBinary((ByteBuffer)expected), (Object)Bytes.toStringBinary((byte[])actual.array(), (int)(actual.arrayOffset() + actual.position()), (int)actual.capacity()));
        }
    }

    private void someReadingWithMetaBlock(HFile.Reader reader) throws IOException {
        this.readNumMetablocks(reader, 10);
    }

    private void metablocks(String compress) throws Exception {
        Path mFile = new Path(ROOT_DIR, "meta.hfile");
        FSDataOutputStream fout = this.createFSOutput(mFile);
        HFileContext meta = new HFileContextBuilder().withCompression(HFileWriterImpl.compressionByName((String)compress)).withBlockSize(512).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withOutputStream(fout).withFileContext(meta).create();
        this.someTestingWithMetaBlock(writer);
        writer.close();
        fout.close();
        ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(fs, mFile).build();
        HFile.Reader reader = TestHFile.createReaderFromStream(context, cacheConf, conf);
        Assert.assertFalse((boolean)reader.getScanner(false, false).seekTo());
        this.someReadingWithMetaBlock(reader);
        fs.delete(mFile, true);
        reader.close();
    }

    @Test
    public void testMetaBlocks() throws Exception {
        this.metablocks("none");
        this.metablocks("gz");
    }

    @Test
    public void testNullMetaBlocks() throws Exception {
        for (Compression.Algorithm compressAlgo : HBaseCommonTestingUtility.COMPRESSION_ALGORITHMS) {
            Path mFile = new Path(ROOT_DIR, "nometa_" + compressAlgo + ".hfile");
            FSDataOutputStream fout = this.createFSOutput(mFile);
            HFileContext meta = new HFileContextBuilder().withCompression(compressAlgo).withBlockSize(512).build();
            HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withOutputStream(fout).withFileContext(meta).create();
            KeyValue kv = new KeyValue("foo".getBytes(), "f1".getBytes(), null, "value".getBytes());
            writer.append((Cell)kv);
            writer.close();
            fout.close();
            HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)mFile, (CacheConfig)cacheConf, (boolean)true, (Configuration)conf);
            Assert.assertNull((Object)reader.getMetaBlock("non-existant", false));
        }
    }

    @Test
    public void testCompressionOrdinance() {
        Assert.assertTrue((Compression.Algorithm.LZO.ordinal() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((Compression.Algorithm.GZ.ordinal() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((Compression.Algorithm.NONE.ordinal() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((Compression.Algorithm.SNAPPY.ordinal() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((Compression.Algorithm.LZ4.ordinal() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testShortMidpointSameQual() {
        Cell right;
        Cell mid;
        Cell left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (long)11L, (byte)KeyValue.Type.Maximum.getCode(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)(mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)(right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (long)9L, (byte)KeyValue.Type.Maximum.getCode(), (byte[])HConstants.EMPTY_BYTE_ARRAY))))) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetShortMidpoint() {
        Cell right;
        Cell mid;
        Cell left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)(mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)(right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a")))))) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"b"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)right);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)mid) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"g"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"i"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)right);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)mid) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"bbbbbbb"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)right);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)mid) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)mid.getRowLength());
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"b"), (byte[])Bytes.toBytes((String)"a"));
        mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)right);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)mid) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) <= 0 ? 1 : 0) != 0);
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"aaaaaaaa"), (byte[])Bytes.toBytes((String)"b"));
        mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)right);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)mid) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)mid.getFamilyLength());
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"aaaaaaaaa"));
        mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)right);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)mid) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)mid.getQualifierLength());
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"b"));
        mid = HFileWriterImpl.getMidpoint((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)right);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)mid) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) <= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)mid.getQualifierLength());
        left = CellUtil.createCell((byte[])Bytes.toBytes((String)"g"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        right = CellUtil.createCell((byte[])Bytes.toBytes((String)"i"), (byte[])Bytes.toBytes((String)"a"), (byte[])Bytes.toBytes((String)"a"));
        mid = HFileWriterImpl.getMidpoint((CellComparator)MetaCellComparator.META_COMPARATOR, (Cell)left, (Cell)right);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)left, (Cell)mid) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)mid, (Cell)right) == 0 ? 1 : 0) != 0);
        byte[] rowA = Bytes.toBytes((String)"rowA");
        byte[] rowB = Bytes.toBytes((String)"rowB");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qualA = Bytes.toBytes((String)"qfA");
        byte[] qualB = Bytes.toBytes((String)"qfB");
        CellComparatorImpl keyComparator = CellComparatorImpl.COMPARATOR;
        long ts = 5L;
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"the quick brown fox"), family, qualA, ts, KeyValue.Type.Put);
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"the who test text"), family, qualA, ts, KeyValue.Type.Put);
        Cell newKey = HFileWriterImpl.getMidpoint((CellComparator)keyComparator, (Cell)kv1, (Cell)kv2);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, newKey) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((keyComparator.compare((Cell)kv2, newKey) > 0 ? 1 : 0) != 0);
        byte[] expectedArray = Bytes.toBytes((String)"the r");
        Bytes.equals((byte[])newKey.getRowArray(), (int)newKey.getRowOffset(), (int)newKey.getRowLength(), (byte[])expectedArray, (int)0, (int)expectedArray.length);
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), family, qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), family, qualA, 0L, KeyValue.Type.Put);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, (Cell)kv2) < 0 ? 1 : 0) != 0);
        newKey = HFileWriterImpl.getMidpoint((CellComparator)keyComparator, (Cell)kv1, (Cell)kv2);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, newKey) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((keyComparator.compare((Cell)kv2, newKey) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), family, qualA, -5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), family, qualA, -10L, KeyValue.Type.Put);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, (Cell)kv2) < 0 ? 1 : 0) != 0);
        newKey = HFileWriterImpl.getMidpoint((CellComparator)keyComparator, (Cell)kv1, (Cell)kv2);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, newKey) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((keyComparator.compare((Cell)kv2, newKey) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), family, qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), family, qualB, 5L, KeyValue.Type.Put);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, (Cell)kv2) < 0 ? 1 : 0) != 0);
        newKey = HFileWriterImpl.getMidpoint((CellComparator)keyComparator, (Cell)kv1, (Cell)kv2);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, newKey) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((keyComparator.compare((Cell)kv2, newKey) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(CellUtil.cloneFamily((Cell)newKey), family));
        Assert.assertTrue((boolean)Arrays.equals(CellUtil.cloneQualifier((Cell)newKey), qualB));
        Assert.assertTrue((newKey.getTimestamp() == Long.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((newKey.getTypeByte() == KeyValue.Type.Maximum.getCode() ? 1 : 0) != 0);
        MetaCellComparator metaKeyComparator = MetaCellComparator.META_COMPARATOR;
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase123"), family, qualA, 5L, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbase234"), family, qualA, 0L, KeyValue.Type.Put);
        newKey = HFileWriterImpl.getMidpoint((CellComparator)metaKeyComparator, (Cell)kv1, (Cell)kv2);
        Assert.assertTrue((metaKeyComparator.compare((Cell)kv1, newKey) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((metaKeyComparator.compare((Cell)kv2, newKey) == 0 ? 1 : 0) != 0);
        kv1 = new KeyValue(Bytes.toBytes((String)"ilovehbase"), family, qualA, ts, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"ilovehbaseandhdfs"), family, qualA, ts, KeyValue.Type.Put);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, (Cell)kv2) < 0 ? 1 : 0) != 0);
        newKey = HFileWriterImpl.getMidpoint((CellComparator)keyComparator, (Cell)kv1, (Cell)kv2);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, newKey) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((keyComparator.compare((Cell)kv2, newKey) > 0 ? 1 : 0) != 0);
        expectedArray = Bytes.toBytes((String)"ilovehbasea");
        Bytes.equals((byte[])newKey.getRowArray(), (int)newKey.getRowOffset(), (int)newKey.getRowLength(), (byte[])expectedArray, (int)0, (int)expectedArray.length);
        kv1 = new KeyValue(Bytes.toBytes((String)"100abcdefg"), family, qualA, ts, KeyValue.Type.Put);
        kv2 = new KeyValue(Bytes.toBytes((String)"101abcdefg"), family, qualA, ts, KeyValue.Type.Put);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, (Cell)kv2) < 0 ? 1 : 0) != 0);
        newKey = HFileWriterImpl.getMidpoint((CellComparator)keyComparator, (Cell)kv1, (Cell)kv2);
        Assert.assertTrue((keyComparator.compare((Cell)kv1, newKey) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((keyComparator.compare((Cell)kv2, newKey) > 0 ? 1 : 0) != 0);
        expectedArray = Bytes.toBytes((String)"101");
        Bytes.equals((byte[])newKey.getRowArray(), (int)newKey.getRowOffset(), (int)newKey.getRowLength(), (byte[])expectedArray, (int)0, (int)expectedArray.length);
    }

    @Test
    public void testDBEShipped() throws IOException {
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            DataBlockEncoder encoder = encoding.getEncoder();
            if (encoder == null) continue;
            Path f = new Path(ROOT_DIR, this.testName.getMethodName() + "_" + encoding);
            HFileContext context = new HFileContextBuilder().withIncludesTags(false).withDataBlockEncoding(encoding).build();
            HFileWriterImpl writer = (HFileWriterImpl)HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withPath(fs, f).withFileContext(context).create();
            KeyValue kv = new KeyValue(Bytes.toBytes((String)"testkey1"), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"testvalue"));
            KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"testkey2"), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"testvalue"));
            KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"testkey3"), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"testvalue"));
            ByteBuffer buffer = ByteBuffer.wrap(kv.getBuffer());
            ByteBuffer buffer2 = ByteBuffer.wrap(kv2.getBuffer());
            ByteBuffer buffer3 = ByteBuffer.wrap(kv3.getBuffer());
            writer.append((Cell)new ByteBufferKeyValue(buffer, 0, buffer.remaining()));
            writer.beforeShipped();
            ByteBufferUtils.copyFromBufferToBuffer((ByteBuffer)buffer3, (ByteBuffer)buffer);
            writer.append((Cell)new ByteBufferKeyValue(buffer2, 0, buffer2.remaining()));
            writer.close();
        }
    }

    @Test
    public void testReaderWithTinyLfuCombinedBlockCache() throws Exception {
        this.testReaderCombinedCache("TinyLfu");
    }

    @Test
    public void testReaderWithAdaptiveLruCombinedBlockCache() throws Exception {
        this.testReaderCombinedCache("AdaptiveLRU");
    }

    @Test
    public void testReaderWithLruCombinedBlockCache() throws Exception {
        this.testReaderCombinedCache("LRU");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReaderCombinedCache(String l1CachePolicy) throws Exception {
        int bufCount = 1024;
        int blockSize = 65536;
        ByteBuffAllocator alloc = this.initAllocator(true, bufCount, blockSize, 0);
        this.fillByteBuffAllocator(alloc, bufCount);
        Path storeFilePath = this.writeStoreFile();
        BlockCache combined = this.initCombinedBlockCache(l1CachePolicy);
        conf.setBoolean("hbase.rs.evictblocksonclose", true);
        CacheConfig cacheConfig = new CacheConfig(conf, null, combined, alloc);
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)storeFilePath, (CacheConfig)cacheConfig, (boolean)true, (Configuration)conf);
        long offset = 0L;
        Cacheable cachedBlock = null;
        while (offset < reader.getTrailer().getLoadOnOpenDataOffset()) {
            BlockCacheKey key = new BlockCacheKey(storeFilePath.getName(), offset);
            HFileBlock block = reader.readBlock(offset, -1L, true, true, false, true, null, null);
            offset += (long)block.getOnDiskSizeWithHeader();
            cachedBlock = combined.getBlock(key, false, false, true);
            try {
                Assert.assertNotNull((Object)cachedBlock);
                Assert.assertTrue((boolean)(cachedBlock instanceof HFileBlock));
                HFileBlock hfb = (HFileBlock)cachedBlock;
                if (hfb.getBlockType().isData()) {
                    Assert.assertTrue((boolean)hfb.isSharedMem());
                } else if (!l1CachePolicy.equals("TinyLfu")) {
                    Assert.assertFalse((boolean)hfb.isSharedMem());
                }
            }
            finally {
                cachedBlock.release();
            }
            block.release();
        }
        reader.close();
        combined.shutdown();
        if (cachedBlock != null) {
            Assert.assertEquals((long)0L, (long)cachedBlock.refCnt());
        }
        Assert.assertEquals((long)bufCount, (long)alloc.getFreeBufferCount());
        alloc.clean();
    }
}

