/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestSplitLogWorker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitLogWorker.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitLogWorker.class);
    private static final int WAIT_TIME = 15000;
    private final ServerName MANAGER = ServerName.valueOf((String)"manager,1,1");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private DummyServer ds;
    private ZKWatcher zkw;
    private SplitLogWorker slw;
    private ExecutorService executorService;
    SplitLogWorker.TaskExecutor neverEndingTask = new SplitLogWorker.TaskExecutor(){

        public SplitLogWorker.TaskExecutor.Status exec(String name, CancelableProgressable p) {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return SplitLogWorker.TaskExecutor.Status.PREEMPTED;
                }
            } while (p.progress());
            return SplitLogWorker.TaskExecutor.Status.PREEMPTED;
        }
    };

    private void waitForCounter(LongAdder ctr, long oldval, long newval, long timems) throws Exception {
        Assert.assertTrue((String)("ctr=" + ctr.sum() + ", oldval=" + oldval + ", newval=" + newval), (boolean)this.waitForCounterBoolean(ctr, oldval, newval, timems));
    }

    private boolean waitForCounterBoolean(LongAdder ctr, long oldval, long newval, long timems) throws Exception {
        return this.waitForCounterBoolean(ctr, oldval, newval, timems, true);
    }

    private boolean waitForCounterBoolean(final LongAdder ctr, long oldval, final long newval, long timems, boolean failIfTimeout) throws Exception {
        long timeWaited = TEST_UTIL.waitFor(timems, 10L, failIfTimeout, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return ctr.sum() >= newval;
            }
        });
        if (timeWaited > 0L) {
            Assert.assertEquals((long)newval, (long)ctr.sum());
        }
        return true;
    }

    @Before
    public void setup() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        this.zkw = new ZKWatcher(TEST_UTIL.getConfiguration(), "split-log-worker-tests", null);
        this.ds = new DummyServer(this.zkw, conf);
        ZKUtil.deleteChildrenRecursively((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().baseZNode);
        ZKUtil.createAndFailSilent((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().baseZNode);
        MatcherAssert.assertThat((Object)ZKUtil.checkExists((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().baseZNode), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)-1)));
        LOG.debug(this.zkw.getZNodePaths().baseZNode + " created");
        ZKUtil.createAndFailSilent((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().splitLogZNode);
        MatcherAssert.assertThat((Object)ZKUtil.checkExists((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().splitLogZNode), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)-1)));
        LOG.debug(this.zkw.getZNodePaths().splitLogZNode + " created");
        ZKUtil.createAndFailSilent((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().rsZNode);
        MatcherAssert.assertThat((Object)ZKUtil.checkExists((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().rsZNode), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)-1)));
        SplitLogCounters.resetCounters();
        this.executorService = new ExecutorService("TestSplitLogWorker");
        this.executorService.startExecutorService(ExecutorType.RS_LOG_REPLAY_OPS, 10);
    }

    @After
    public void teardown() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        TEST_UTIL.shutdownMiniZKCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcquireTaskAtStartup() throws Exception {
        LOG.info("testAcquireTaskAtStartup");
        SplitLogCounters.resetCounters();
        String TATAS = "tatas";
        ServerName RS = ServerName.valueOf((String)"rs,1,1");
        RegionServerServices mockedRS = this.getRegionServer(RS);
        this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"tatas"), new SplitLogTask.Unassigned(ServerName.valueOf((String)"mgr,1,1")).toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        SplitLogWorker slw = new SplitLogWorker((Server)this.ds, TEST_UTIL.getConfiguration(), mockedRS, this.neverEndingTask);
        slw.start();
        try {
            this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 0L, 1L, 15000L);
            byte[] bytes = ZKUtil.getData((ZKWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"tatas"));
            SplitLogTask slt = SplitLogTask.parseFrom((byte[])bytes);
            Assert.assertTrue((boolean)slt.isOwned(RS));
        }
        finally {
            this.stopSplitLogWorker(slw);
        }
    }

    private void stopSplitLogWorker(SplitLogWorker slw) throws InterruptedException {
        if (slw != null) {
            slw.stop();
            slw.worker.join(15000L);
            if (slw.worker.isAlive()) {
                Assert.assertTrue(("Could not stop the worker thread slw=" + slw == null ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRaceForTask() throws Exception {
        LOG.info("testRaceForTask");
        SplitLogCounters.resetCounters();
        String TRFT = "trft";
        ServerName SVR1 = ServerName.valueOf((String)"svr1,1,1");
        ServerName SVR2 = ServerName.valueOf((String)"svr2,1,1");
        this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"trft"), new SplitLogTask.Unassigned(this.MANAGER).toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        RegionServerServices mockedRS1 = this.getRegionServer(SVR1);
        RegionServerServices mockedRS2 = this.getRegionServer(SVR2);
        SplitLogWorker slw1 = new SplitLogWorker((Server)this.ds, TEST_UTIL.getConfiguration(), mockedRS1, this.neverEndingTask);
        SplitLogWorker slw2 = new SplitLogWorker((Server)this.ds, TEST_UTIL.getConfiguration(), mockedRS2, this.neverEndingTask);
        slw1.start();
        slw2.start();
        try {
            this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 0L, 1L, 15000L);
            Assert.assertTrue((this.waitForCounterBoolean(SplitLogCounters.tot_wkr_failed_to_grab_task_owned, 0L, 1L, 15000L, false) || SplitLogCounters.tot_wkr_failed_to_grab_task_lost_race.sum() == 1L ? 1 : 0) != 0);
            byte[] bytes = ZKUtil.getData((ZKWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"trft"));
            SplitLogTask slt = SplitLogTask.parseFrom((byte[])bytes);
            Assert.assertTrue((slt.isOwned(SVR1) || slt.isOwned(SVR2) ? 1 : 0) != 0);
        }
        finally {
            this.stopSplitLogWorker(slw1);
            this.stopSplitLogWorker(slw2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreemptTask() throws Exception {
        LOG.info("testPreemptTask");
        SplitLogCounters.resetCounters();
        ServerName SRV = ServerName.valueOf((String)"tpt_svr,1,1");
        String PATH = ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"tpt_task");
        RegionServerServices mockedRS = this.getRegionServer(SRV);
        SplitLogWorker slw = new SplitLogWorker((Server)this.ds, TEST_UTIL.getConfiguration(), mockedRS, this.neverEndingTask);
        slw.start();
        try {
            Thread.yield();
            Thread.sleep(1000L);
            this.waitForCounter(SplitLogCounters.tot_wkr_task_grabing, 0L, 1L, 15000L);
            this.zkw.getRecoverableZooKeeper().create(PATH, new SplitLogTask.Unassigned(this.MANAGER).toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 0L, 1L, 15000L);
            Assert.assertEquals((long)1L, (long)slw.getTaskReadySeq());
            byte[] bytes = ZKUtil.getData((ZKWatcher)this.zkw, (String)PATH);
            SplitLogTask slt = SplitLogTask.parseFrom((byte[])bytes);
            Assert.assertTrue((boolean)slt.isOwned(SRV));
            slt = new SplitLogTask.Owned(this.MANAGER);
            ZKUtil.setData((ZKWatcher)this.zkw, (String)PATH, (byte[])slt.toByteArray());
            this.waitForCounter(SplitLogCounters.tot_wkr_preempt_task, 0L, 1L, 15000L);
        }
        finally {
            this.stopSplitLogWorker(slw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleTasks() throws Exception {
        LOG.info("testMultipleTasks");
        SplitLogCounters.resetCounters();
        ServerName SRV = ServerName.valueOf((String)"tmt_svr,1,1");
        String PATH1 = ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"tmt_task");
        RegionServerServices mockedRS = this.getRegionServer(SRV);
        SplitLogWorker slw = new SplitLogWorker((Server)this.ds, TEST_UTIL.getConfiguration(), mockedRS, this.neverEndingTask);
        slw.start();
        try {
            Thread.yield();
            Thread.sleep(100L);
            this.waitForCounter(SplitLogCounters.tot_wkr_task_grabing, 0L, 1L, 15000L);
            SplitLogTask.Unassigned unassignedManager = new SplitLogTask.Unassigned(this.MANAGER);
            this.zkw.getRecoverableZooKeeper().create(PATH1, unassignedManager.toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 0L, 1L, 15000L);
            String PATH2 = ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"tmt_task_2");
            this.zkw.getRecoverableZooKeeper().create(PATH2, unassignedManager.toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ServerName anotherWorker = ServerName.valueOf((String)"another-worker,1,1");
            SplitLogTask.Owned slt = new SplitLogTask.Owned(anotherWorker);
            ZKUtil.setData((ZKWatcher)this.zkw, (String)PATH1, (byte[])slt.toByteArray());
            this.waitForCounter(SplitLogCounters.tot_wkr_preempt_task, 0L, 1L, 15000L);
            this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 1L, 2L, 15000L);
            Assert.assertEquals((long)2L, (long)slw.getTaskReadySeq());
            byte[] bytes = ZKUtil.getData((ZKWatcher)this.zkw, (String)PATH2);
            slt = SplitLogTask.parseFrom((byte[])bytes);
            Assert.assertTrue((boolean)slt.isOwned(SRV));
        }
        finally {
            this.stopSplitLogWorker(slw);
        }
    }

    @Test
    public void testRescan() throws Exception {
        LOG.info("testRescan");
        SplitLogCounters.resetCounters();
        ServerName SRV = ServerName.valueOf((String)"svr,1,1");
        RegionServerServices mockedRS = this.getRegionServer(SRV);
        this.slw = new SplitLogWorker((Server)this.ds, TEST_UTIL.getConfiguration(), mockedRS, this.neverEndingTask);
        this.slw.start();
        Thread.yield();
        Thread.sleep(100L);
        String task = ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"task");
        SplitLogTask.Unassigned slt = new SplitLogTask.Unassigned(this.MANAGER);
        this.zkw.getRecoverableZooKeeper().create(task, slt.toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 0L, 1L, 15000L);
        ZKUtil.setData((ZKWatcher)this.zkw, (String)task, (byte[])slt.toByteArray());
        this.waitForCounter(SplitLogCounters.tot_wkr_preempt_task, 0L, 1L, 15000L);
        String rescan = ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)"RESCAN");
        rescan = this.zkw.getRecoverableZooKeeper().create(rescan, slt.toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 1L, 2L, 15000L);
        ZKUtil.setData((ZKWatcher)this.zkw, (String)task, (byte[])slt.toByteArray());
        this.waitForCounter(SplitLogCounters.tot_wkr_preempt_task, 1L, 2L, 15000L);
        this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired_rescan, 0L, 1L, 15000L);
        List nodes = ZKUtil.listChildrenNoWatch((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().splitLogZNode);
        LOG.debug(Objects.toString(nodes));
        int num = 0;
        for (String node : nodes) {
            ++num;
            if (!node.startsWith("RESCAN")) continue;
            String name = ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)node);
            String fn = ZKSplitLog.getFileName((String)name);
            byte[] data = ZKUtil.getData((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().splitLogZNode, (String)fn));
            slt = SplitLogTask.parseFrom((byte[])data);
            Assert.assertTrue((String)slt.toString(), (boolean)slt.isDone(SRV));
        }
        Assert.assertEquals((long)2L, (long)num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcquireMultiTasks() throws Exception {
        LOG.info("testAcquireMultiTasks");
        SplitLogCounters.resetCounters();
        String TATAS = "tatas";
        ServerName RS = ServerName.valueOf((String)"rs,1,1");
        int maxTasks = 3;
        Configuration testConf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        testConf.setInt("hbase.regionserver.wal.max.splitters", 3);
        RegionServerServices mockedRS = this.getRegionServer(RS);
        for (int i = 0; i < 3; ++i) {
            this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)("tatas" + i)), new SplitLogTask.Unassigned(ServerName.valueOf((String)"mgr,1,1")).toByteArray(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        SplitLogWorker slw = new SplitLogWorker((Server)this.ds, testConf, mockedRS, this.neverEndingTask);
        slw.start();
        try {
            this.waitForCounter(SplitLogCounters.tot_wkr_task_acquired, 0L, 3L, 15000L);
            for (int i = 0; i < 3; ++i) {
                byte[] bytes = ZKUtil.getData((ZKWatcher)this.zkw, (String)ZKSplitLog.getEncodedNodeName((ZKWatcher)this.zkw, (String)("tatas" + i)));
                SplitLogTask slt = SplitLogTask.parseFrom((byte[])bytes);
                Assert.assertTrue((boolean)slt.isOwned(RS));
            }
        }
        finally {
            this.stopSplitLogWorker(slw);
        }
    }

    private RegionServerServices getRegionServer(ServerName name) {
        RegionServerServices mockedServer = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)mockedServer.getConfiguration()).thenReturn((Object)TEST_UTIL.getConfiguration());
        Mockito.when((Object)mockedServer.getServerName()).thenReturn((Object)name);
        Mockito.when((Object)mockedServer.getZooKeeper()).thenReturn((Object)this.zkw);
        Mockito.when((Object)mockedServer.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)mockedServer.getExecutorService()).thenReturn((Object)this.executorService);
        return mockedServer;
    }

    static class DummyServer
    implements Server {
        private ZKWatcher zkw;
        private Configuration conf;
        private CoordinatedStateManager cm;

        public DummyServer(ZKWatcher zkw, Configuration conf) {
            this.zkw = zkw;
            this.conf = conf;
            this.cm = new ZkCoordinatedStateManager((Server)this);
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public ZKWatcher getZooKeeper() {
            return this.zkw;
        }

        public ServerName getServerName() {
            return null;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return this.cm;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }
}

