/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.DoNothingConnectionRegistry;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestConnectionRegistryLeak {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConnectionRegistryLeak.class);
    private static final List<ConnectionRegistryForTest> CREATED = new ArrayList<ConnectionRegistryForTest>();
    private static Configuration CONF = HBaseConfiguration.create();

    @BeforeClass
    public static void setUp() {
        CONF.setClass("hbase.client.registry.impl", ConnectionRegistryForTest.class, ConnectionRegistry.class);
    }

    @Test
    public void test() throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            try {
                ConnectionFactory.createAsyncConnection((Configuration)CONF).get();
                Assert.fail();
                continue;
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)10L, (long)CREATED.size());
        CREATED.forEach(r -> Assert.assertTrue((boolean)((ConnectionRegistryForTest)r).closed));
    }

    public static final class ConnectionRegistryForTest
    extends DoNothingConnectionRegistry {
        private boolean closed = false;

        public ConnectionRegistryForTest(Configuration conf) {
            super(conf);
            CREATED.add(this);
        }

        @Override
        public CompletableFuture<String> getClusterId() {
            return FutureUtils.failedFuture((Throwable)new IOException("inject error"));
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

