/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.ImmutableScan;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, SmallTests.class})
public class TestImmutableScan {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestImmutableScan.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestImmutableScan.class);

    @Test
    public void testScanCopyConstructor() throws Exception {
        Scan scan = new Scan();
        scan.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"q")).setACL("test_user2", new Permission(new Permission.Action[]{Permission.Action.READ})).setAllowPartialResults(true).setAsyncPrefetch(false).setAttribute("test_key", Bytes.toBytes((String)"test_value")).setAuthorizations(new Authorizations(new String[]{"test_label"})).setBatch(10).setCacheBlocks(false).setCaching(10).setConsistency(Consistency.TIMELINE).setFilter((Filter)new FilterList(new Filter[0])).setId("scan_copy_constructor").setIsolationLevel(IsolationLevel.READ_COMMITTED).setLimit(100).setLoadColumnFamiliesOnDemand(false).setMaxResultSize(100L).setMaxResultsPerColumnFamily(1000).readVersions(9999).setMvccReadPoint(5L).setNeedCursorResult(true).setPriority(1).setRaw(true).setReplicaId(3).setReversed(true).setRowOffsetPerColumnFamily(5).setRowPrefixFilter(Bytes.toBytes((String)"row_")).setScanMetricsEnabled(true).setSmall(true).setReadType(Scan.ReadType.STREAM).withStartRow(Bytes.toBytes((String)"row_1")).withStopRow(Bytes.toBytes((String)"row_2")).setTimeRange(0L, 13L);
        ImmutableScan scanCopy = new ImmutableScan(scan);
        Assert.assertArrayEquals((byte[])scan.getACL(), (byte[])scanCopy.getACL());
        Assert.assertEquals((Object)scan.getAllowPartialResults(), (Object)scanCopy.getAllowPartialResults());
        Assert.assertArrayEquals((byte[])scan.getAttribute("test_key"), (byte[])scanCopy.getAttribute("test_key"));
        Assert.assertEquals((long)scan.getAttributeSize(), (long)scanCopy.getAttributeSize());
        Assert.assertEquals((Object)scan.getAttributesMap(), (Object)scanCopy.getAttributesMap());
        Assert.assertEquals((Object)scan.getAuthorizations().getLabels(), (Object)scanCopy.getAuthorizations().getLabels());
        Assert.assertEquals((long)scan.getBatch(), (long)scanCopy.getBatch());
        Assert.assertEquals((Object)scan.getCacheBlocks(), (Object)scanCopy.getCacheBlocks());
        Assert.assertEquals((long)scan.getCaching(), (long)scanCopy.getCaching());
        Assert.assertEquals((Object)scan.getConsistency(), (Object)scanCopy.getConsistency());
        Assert.assertEquals((long)scan.getFamilies().length, (long)scanCopy.getFamilies().length);
        Assert.assertArrayEquals((byte[])scan.getFamilies()[0], (byte[])scanCopy.getFamilies()[0]);
        Assert.assertEquals((Object)scan.getFamilyMap(), (Object)scanCopy.getFamilyMap());
        Assert.assertEquals((Object)scan.getFilter(), (Object)scanCopy.getFilter());
        Assert.assertEquals((Object)scan.getId(), (Object)scanCopy.getId());
        Assert.assertEquals((Object)scan.getIsolationLevel(), (Object)scanCopy.getIsolationLevel());
        Assert.assertEquals((long)scan.getLimit(), (long)scanCopy.getLimit());
        Assert.assertEquals((Object)scan.getLoadColumnFamiliesOnDemandValue(), (Object)scanCopy.getLoadColumnFamiliesOnDemandValue());
        Assert.assertEquals((long)scan.getMaxResultSize(), (long)scanCopy.getMaxResultSize());
        Assert.assertEquals((long)scan.getMaxResultsPerColumnFamily(), (long)scanCopy.getMaxResultsPerColumnFamily());
        Assert.assertEquals((long)scan.getMaxVersions(), (long)scanCopy.getMaxVersions());
        Assert.assertEquals((long)scan.getMvccReadPoint(), (long)scanCopy.getMvccReadPoint());
        Assert.assertEquals((long)scan.getPriority(), (long)scanCopy.getPriority());
        Assert.assertEquals((Object)scan.getReadType(), (Object)scanCopy.getReadType());
        Assert.assertEquals((long)scan.getReplicaId(), (long)scanCopy.getReplicaId());
        Assert.assertEquals((long)scan.getRowOffsetPerColumnFamily(), (long)scanCopy.getRowOffsetPerColumnFamily());
        Assert.assertArrayEquals((byte[])scan.getStartRow(), (byte[])scanCopy.getStartRow());
        Assert.assertArrayEquals((byte[])scan.getStopRow(), (byte[])scanCopy.getStopRow());
        Assert.assertEquals((Object)scan.getTimeRange(), (Object)scanCopy.getTimeRange());
        Assert.assertEquals((Object)scan.getFingerprint(), (Object)scanCopy.getFingerprint());
        Assert.assertEquals((Object)scan.toMap(1), (Object)scanCopy.toMap(1));
        Assert.assertEquals((Object)scan.toString(2), (Object)scanCopy.toString(2));
        Assert.assertEquals((Object)scan.toJSON(2), (Object)scanCopy.toJSON(2));
        LOG.debug("Compare all getters of scan and scanCopy.");
        this.compareGetters(scan, (Scan)scanCopy);
        this.testUnmodifiableSetters((Scan)scanCopy);
    }

    private void testUnmodifiableSetters(Scan scanCopy) throws IOException {
        try {
            scanCopy.setFilter((Filter)Mockito.mock(Filter.class));
            throw new RuntimeException("Should not reach here");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"ImmutableScan does not allow access to setFilter", (Object)e.getMessage());
            try {
                scanCopy.addFamily(new byte[]{0, 1});
                throw new RuntimeException("Should not reach here");
            }
            catch (UnsupportedOperationException e2) {
                Assert.assertEquals((Object)"ImmutableScan does not allow access to addFamily", (Object)e2.getMessage());
                try {
                    scanCopy.addColumn(new byte[]{0, 1}, new byte[]{2, 3});
                    throw new RuntimeException("Should not reach here");
                }
                catch (UnsupportedOperationException e3) {
                    Assert.assertEquals((Object)"ImmutableScan does not allow access to addColumn", (Object)e3.getMessage());
                    try {
                        scanCopy.setTimeRange(1L, 2L);
                        throw new RuntimeException("Should not reach here");
                    }
                    catch (UnsupportedOperationException e4) {
                        Assert.assertEquals((Object)"ImmutableScan does not allow access to setTimeRange", (Object)e4.getMessage());
                        try {
                            scanCopy.setTimestamp(1L);
                            throw new RuntimeException("Should not reach here");
                        }
                        catch (UnsupportedOperationException e5) {
                            Assert.assertEquals((Object)"ImmutableScan does not allow access to setTimestamp", (Object)e5.getMessage());
                            try {
                                scanCopy.setColumnFamilyTimeRange(new byte[]{0}, 1L, 2L);
                                throw new RuntimeException("Should not reach here");
                            }
                            catch (UnsupportedOperationException e6) {
                                Assert.assertEquals((Object)"ImmutableScan does not allow access to setColumnFamilyTimeRange", (Object)e6.getMessage());
                                try {
                                    scanCopy.withStopRow(new byte[]{1, 2});
                                    throw new RuntimeException("Should not reach here");
                                }
                                catch (UnsupportedOperationException e7) {
                                    Assert.assertEquals((Object)"ImmutableScan does not allow access to withStopRow", (Object)e7.getMessage());
                                    try {
                                        scanCopy.setRowPrefixFilter(new byte[]{1, 2});
                                        throw new RuntimeException("Should not reach here");
                                    }
                                    catch (UnsupportedOperationException e8) {
                                        Assert.assertEquals((Object)"ImmutableScan does not allow access to setRowPrefixFilter", (Object)e8.getMessage());
                                        try {
                                            scanCopy.readAllVersions();
                                            throw new RuntimeException("Should not reach here");
                                        }
                                        catch (UnsupportedOperationException e9) {
                                            Assert.assertEquals((Object)"ImmutableScan does not allow access to readAllVersions", (Object)e9.getMessage());
                                            try {
                                                scanCopy.setBatch(1);
                                                throw new RuntimeException("Should not reach here");
                                            }
                                            catch (UnsupportedOperationException e10) {
                                                Assert.assertEquals((Object)"ImmutableScan does not allow access to setBatch", (Object)e10.getMessage());
                                                try {
                                                    scanCopy.setRowOffsetPerColumnFamily(1);
                                                    throw new RuntimeException("Should not reach here");
                                                }
                                                catch (UnsupportedOperationException e11) {
                                                    Assert.assertEquals((Object)"ImmutableScan does not allow access to setRowOffsetPerColumnFamily", (Object)e11.getMessage());
                                                    try {
                                                        scanCopy.setCaching(1);
                                                        throw new RuntimeException("Should not reach here");
                                                    }
                                                    catch (UnsupportedOperationException e12) {
                                                        Assert.assertEquals((Object)"ImmutableScan does not allow access to setCaching", (Object)e12.getMessage());
                                                        try {
                                                            scanCopy.setLoadColumnFamiliesOnDemand(true);
                                                            throw new RuntimeException("Should not reach here");
                                                        }
                                                        catch (UnsupportedOperationException e13) {
                                                            Assert.assertEquals((Object)"ImmutableScan does not allow access to setLoadColumnFamiliesOnDemand", (Object)e13.getMessage());
                                                            try {
                                                                scanCopy.setRaw(true);
                                                                throw new RuntimeException("Should not reach here");
                                                            }
                                                            catch (UnsupportedOperationException e14) {
                                                                Assert.assertEquals((Object)"ImmutableScan does not allow access to setRaw", (Object)e14.getMessage());
                                                                try {
                                                                    scanCopy.setAuthorizations(new Authorizations(new String[]{"test"}));
                                                                    throw new RuntimeException("Should not reach here");
                                                                }
                                                                catch (UnsupportedOperationException e15) {
                                                                    Assert.assertEquals((Object)"ImmutableScan does not allow access to setAuthorizations", (Object)e15.getMessage());
                                                                    try {
                                                                        scanCopy.setACL("user1", new Permission(new Permission.Action[]{Permission.Action.READ}));
                                                                        throw new RuntimeException("Should not reach here");
                                                                    }
                                                                    catch (UnsupportedOperationException e16) {
                                                                        Assert.assertEquals((Object)"ImmutableScan does not allow access to setACL", (Object)e16.getMessage());
                                                                        try {
                                                                            scanCopy.setReplicaId(12);
                                                                            throw new RuntimeException("Should not reach here");
                                                                        }
                                                                        catch (UnsupportedOperationException e17) {
                                                                            Assert.assertEquals((Object)"ImmutableScan does not allow access to setReplicaId", (Object)e17.getMessage());
                                                                            try {
                                                                                scanCopy.setReadType(Scan.ReadType.STREAM);
                                                                                throw new RuntimeException("Should not reach here");
                                                                            }
                                                                            catch (UnsupportedOperationException e18) {
                                                                                Assert.assertEquals((Object)"ImmutableScan does not allow access to setReadType", (Object)e18.getMessage());
                                                                                try {
                                                                                    scanCopy.setOneRowLimit();
                                                                                    throw new RuntimeException("Should not reach here");
                                                                                }
                                                                                catch (UnsupportedOperationException e19) {
                                                                                    Assert.assertEquals((Object)"ImmutableScan does not allow access to setOneRowLimit", (Object)e19.getMessage());
                                                                                    try {
                                                                                        scanCopy.setNeedCursorResult(false);
                                                                                        throw new RuntimeException("Should not reach here");
                                                                                    }
                                                                                    catch (UnsupportedOperationException e20) {
                                                                                        Assert.assertEquals((Object)"ImmutableScan does not allow access to setNeedCursorResult", (Object)e20.getMessage());
                                                                                        try {
                                                                                            scanCopy.resetMvccReadPoint();
                                                                                            throw new RuntimeException("Should not reach here");
                                                                                        }
                                                                                        catch (UnsupportedOperationException e21) {
                                                                                            Assert.assertEquals((Object)"ImmutableScan does not allow access to resetMvccReadPoint", (Object)e21.getMessage());
                                                                                            try {
                                                                                                scanCopy.setMvccReadPoint(1L);
                                                                                                throw new RuntimeException("Should not reach here");
                                                                                            }
                                                                                            catch (UnsupportedOperationException e22) {
                                                                                                Assert.assertEquals((Object)"ImmutableScan does not allow access to setMvccReadPoint", (Object)e22.getMessage());
                                                                                                try {
                                                                                                    scanCopy.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
                                                                                                    throw new RuntimeException("Should not reach here");
                                                                                                }
                                                                                                catch (UnsupportedOperationException e23) {
                                                                                                    Assert.assertEquals((Object)"ImmutableScan does not allow access to setIsolationLevel", (Object)e23.getMessage());
                                                                                                    try {
                                                                                                        scanCopy.setPriority(10);
                                                                                                        throw new RuntimeException("Should not reach here");
                                                                                                    }
                                                                                                    catch (UnsupportedOperationException e24) {
                                                                                                        Assert.assertEquals((Object)"ImmutableScan does not allow access to setPriority", (Object)e24.getMessage());
                                                                                                        try {
                                                                                                            scanCopy.setConsistency(Consistency.TIMELINE);
                                                                                                            throw new RuntimeException("Should not reach here");
                                                                                                        }
                                                                                                        catch (UnsupportedOperationException e25) {
                                                                                                            Assert.assertEquals((Object)"ImmutableScan does not allow access to setConsistency", (Object)e25.getMessage());
                                                                                                            try {
                                                                                                                scanCopy.setCacheBlocks(true);
                                                                                                                throw new RuntimeException("Should not reach here");
                                                                                                            }
                                                                                                            catch (UnsupportedOperationException e26) {
                                                                                                                Assert.assertEquals((Object)"ImmutableScan does not allow access to setCacheBlocks", (Object)e26.getMessage());
                                                                                                                try {
                                                                                                                    scanCopy.setAllowPartialResults(true);
                                                                                                                    throw new RuntimeException("Should not reach here");
                                                                                                                }
                                                                                                                catch (UnsupportedOperationException e27) {
                                                                                                                    Assert.assertEquals((Object)"ImmutableScan does not allow access to setAllowPartialResults", (Object)e27.getMessage());
                                                                                                                    try {
                                                                                                                        scanCopy.setId("id");
                                                                                                                        throw new RuntimeException("Should not reach here");
                                                                                                                    }
                                                                                                                    catch (UnsupportedOperationException e28) {
                                                                                                                        Assert.assertEquals((Object)"ImmutableScan does not allow access to setId", (Object)e28.getMessage());
                                                                                                                        try {
                                                                                                                            scanCopy.setMaxResultSize(100L);
                                                                                                                            throw new RuntimeException("Should not reach here");
                                                                                                                        }
                                                                                                                        catch (UnsupportedOperationException e29) {
                                                                                                                            Assert.assertEquals((Object)"ImmutableScan does not allow access to setMaxResultSize", (Object)e29.getMessage());
                                                                                                                            try {
                                                                                                                                scanCopy.setMaxResultsPerColumnFamily(100);
                                                                                                                                throw new RuntimeException("Should not reach here");
                                                                                                                            }
                                                                                                                            catch (UnsupportedOperationException e30) {
                                                                                                                                Assert.assertEquals((Object)"ImmutableScan does not allow access to setMaxResultsPerColumnFamily", (Object)e30.getMessage());
                                                                                                                                return;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void compareGetters(Scan scan, Scan scanCopy) {
        Method[] methods;
        for (Method method : methods = Scan.class.getMethods()) {
            if (!TestImmutableScan.isGetter(method)) continue;
            LOG.debug("Comparing return values of method: {}", (Object)method);
            try {
                Object obj2;
                Map obj1;
                switch (method.getName()) {
                    case "toMap": {
                        if (method.getParameterCount() == 1) {
                            obj1 = method.invoke((Object)scan, 2);
                            obj2 = method.invoke((Object)scanCopy, 2);
                            break;
                        }
                    }
                    case "getAttribute": {
                        if (method.getParameterCount() == 1) {
                            obj1 = method.invoke((Object)scan, "acl");
                            obj2 = method.invoke((Object)scanCopy, "acl");
                            break;
                        }
                    }
                    case "toString": {
                        if (method.getParameterCount() == 1) {
                            obj1 = method.invoke((Object)scan, 25);
                            obj2 = method.invoke((Object)scanCopy, 25);
                            break;
                        }
                    }
                    case "toJSON": {
                        if (method.getParameterCount() == 1) {
                            obj1 = method.invoke((Object)scan, 25);
                            obj2 = method.invoke((Object)scanCopy, 25);
                            break;
                        }
                    }
                    default: {
                        obj1 = method.invoke((Object)scan, new Object[0]);
                        obj2 = method.invoke((Object)scanCopy, new Object[0]);
                    }
                }
                if (obj1 instanceof Map && obj2 instanceof Map) {
                    obj1 = Collections.unmodifiableMap(obj1);
                }
                if (EqualsBuilder.reflectionEquals((Object)obj1, (Object)obj2, (String[])new String[0])) continue;
                throw new AssertionError((Object)("Method " + method + " does not return equal values"));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new AssertionError("Error invoking method " + method, e);
            }
        }
    }

    private static boolean isGetter(Method method) {
        if ("hashCode".equals(method.getName()) || "equals".equals(method.getName()) || method.getName().startsWith("set")) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType()) && !Scan.class.equals(method.getReturnType());
    }
}

