/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestConnectionId {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConnectionId.class);
    private Configuration testConfig = HBaseConfiguration.create();
    private User testUser1 = User.createUserForTesting((Configuration)this.testConfig, (String)"test", (String[])new String[]{"testgroup"});
    private User testUser2 = User.createUserForTesting((Configuration)this.testConfig, (String)"test", (String[])new String[]{"testgroup"});
    private String serviceName = "test";
    private InetSocketAddress address = new InetSocketAddress(999);
    private ConnectionId connectionId1 = new ConnectionId(this.testUser1, this.serviceName, this.address);
    private ConnectionId connectionId2 = new ConnectionId(this.testUser2, this.serviceName, this.address);

    @Test
    public void testGetServiceName() {
        Assert.assertEquals((Object)"test", (Object)this.connectionId1.getServiceName());
    }

    @Test
    public void testGetAddress() {
        Assert.assertEquals((Object)this.address, (Object)this.connectionId1.getAddress());
        Assert.assertEquals((Object)this.address, (Object)this.connectionId2.getAddress());
    }

    @Test
    public void testGetTicket() {
        Assert.assertEquals((Object)this.testUser1, (Object)this.connectionId1.getTicket());
        Assert.assertNotEquals((Object)this.testUser2, (Object)this.connectionId1.getTicket());
    }

    @Test
    public void testToString() {
        String expectedString = "0.0.0.0/0.0.0.0:999/test/test (auth:SIMPLE)";
        Assert.assertEquals((Object)expectedString, (Object)this.connectionId1.toString());
    }

    @Test
    public void testEqualsWithHashCode() {
        Assert.assertTrue((boolean)this.connectionId1.equals((Object)this.connectionId1));
        ConnectionId connectionId = new ConnectionId(this.testUser1, this.serviceName, this.address);
        Assert.assertTrue((connectionId.equals((Object)this.connectionId1) && this.connectionId1.equals((Object)connectionId) ? 1 : 0) != 0);
        Assert.assertEquals((long)connectionId.hashCode(), (long)this.connectionId1.hashCode());
        ConnectionId connectionId3 = new ConnectionId(this.testUser1, this.serviceName, this.address);
        Assert.assertTrue((this.connectionId1.equals((Object)connectionId) && connectionId.equals((Object)connectionId3) && this.connectionId1.equals((Object)connectionId3) ? 1 : 0) != 0);
        Assert.assertEquals((long)connectionId.hashCode(), (long)connectionId3.hashCode());
        Assert.assertFalse((boolean)this.connectionId1.equals(null));
        Assert.assertFalse((boolean)this.connectionId1.equals((Object)this.connectionId2));
    }

    @Test
    public void testHashCode() {
        int testHashCode = this.connectionId1.hashCode();
        int expectedHashCode = ConnectionId.hashCode((User)this.testUser1, (String)this.serviceName, (InetSocketAddress)this.address);
        Assert.assertEquals((long)expectedHashCode, (long)testHashCode);
        Assert.assertNotEquals((Object)this.connectionId1, (Object)this.connectionId2);
        Assert.assertNotEquals((long)this.connectionId1.hashCode(), (long)this.connectionId2.hashCode());
    }
}

