/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.StringUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileUtil.class);
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();
    private static final String FILE = "x";
    private static final String LINK = "y";
    private static final String DIR = "dir";
    private static final String FILE_1_NAME = "file1";
    private File del;
    private File tmp;
    private File dir1;
    private File dir2;
    private File partitioned;
    private File xSubDir;
    private File xSubSubDir;
    private File ySubDir;
    private File file2;
    private File file22;
    private File file3;
    private File zlink;
    private InetAddress inet1;
    private InetAddress inet2;
    private InetAddress inet3;
    private InetAddress inet4;
    private InetAddress inet5;
    private InetAddress inet6;
    private URI uri1;
    private URI uri2;
    private URI uri3;
    private URI uri4;
    private URI uri5;
    private URI uri6;
    private FileSystem fs1;
    private FileSystem fs2;
    private FileSystem fs3;
    private FileSystem fs4;
    private FileSystem fs5;
    private FileSystem fs6;

    @Before
    public void setup() throws IOException {
        this.del = this.testFolder.newFolder("del");
        this.tmp = this.testFolder.newFolder("tmp");
        this.partitioned = this.testFolder.newFolder("partitioned");
        this.zlink = new File(this.del, "zlink");
        this.xSubDir = new File(this.del, "xSubDir");
        this.xSubSubDir = new File(this.xSubDir, "xSubSubDir");
        this.ySubDir = new File(this.del, "ySubDir");
        this.file2 = new File(this.xSubDir, "file2");
        this.file22 = new File(this.xSubSubDir, "file22");
        this.file3 = new File(this.ySubDir, "file3");
        this.dir1 = new File(this.del, "dir1");
        this.dir2 = new File(this.del, "dir2");
        FileUtils.forceMkdir((File)this.dir1);
        FileUtils.forceMkdir((File)this.dir2);
        Verify.createNewFile(new File(this.del, FILE));
        File tmpFile = Verify.createNewFile(new File(this.tmp, FILE));
        Verify.createNewFile(new File(this.dir1, FILE));
        Verify.createNewFile(new File(this.dir2, FILE));
        File link = new File(this.del, LINK);
        FileUtil.symLink((String)tmpFile.toString(), (String)link.toString());
        File linkDir = new File(this.del, "tmpDir");
        FileUtil.symLink((String)this.tmp.toString(), (String)linkDir.toString());
        Assert.assertEquals((long)5L, (long)Objects.requireNonNull(this.del.listFiles()).length);
        this.createFile(this.partitioned, "part-r-00000", "foo");
        this.createFile(this.partitioned, "part-r-00001", "bar");
        FileUtil.symLink((String)this.del.toString(), (String)(this.dir1.toString() + "/cycle"));
    }

    @After
    public void tearDown() throws IOException {
        this.testFolder.delete();
    }

    private File createFile(File directory, String name, String contents) throws IOException {
        File newFile = new File(directory, name);
        try (PrintWriter pw = new PrintWriter(newFile);){
            pw.println(contents);
        }
        return newFile;
    }

    @Test(timeout=30000L)
    public void testListFiles() throws IOException {
        File[] files = FileUtil.listFiles((File)this.partitioned);
        Assert.assertEquals((long)2L, (long)files.length);
        File newDir = new File(this.tmp.getPath(), "test");
        Verify.mkdir(newDir);
        Assert.assertTrue((String)"Failed to create test dir", (boolean)newDir.exists());
        files = FileUtil.listFiles((File)newDir);
        Assert.assertEquals((long)0L, (long)files.length);
        Assert.assertTrue((boolean)newDir.delete());
        Assert.assertFalse((String)"Failed to delete test dir", (boolean)newDir.exists());
        try {
            files = FileUtil.listFiles((File)newDir);
            Assert.fail((String)("IOException expected on listFiles() for non-existent dir " + newDir.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testListAPI() throws IOException {
        String[] files = FileUtil.list((File)this.partitioned);
        Assert.assertEquals((String)"Unexpected number of pre-existing files", (long)2L, (long)files.length);
        File newDir = new File(this.tmp.getPath(), "test");
        Verify.mkdir(newDir);
        Assert.assertTrue((String)"Failed to create test dir", (boolean)newDir.exists());
        files = FileUtil.list((File)newDir);
        Assert.assertEquals((String)"New directory unexpectedly contains files", (long)0L, (long)files.length);
        Assert.assertTrue((boolean)newDir.delete());
        Assert.assertFalse((String)"Failed to delete test dir", (boolean)newDir.exists());
        try {
            files = FileUtil.list((File)newDir);
            Assert.fail((String)("IOException expected on list() for non-existent dir " + newDir.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testFullyDelete() throws IOException {
        boolean ret = FileUtil.fullyDelete((File)this.del);
        Assert.assertTrue((boolean)ret);
        Verify.notExists(this.del);
        this.validateTmpDir();
    }

    @Test(timeout=30000L)
    public void testFullyDeleteSymlinks() throws IOException {
        File link = new File(this.del, LINK);
        this.assertDelListLength(5);
        boolean ret = FileUtil.fullyDelete((File)link);
        Assert.assertTrue((boolean)ret);
        Verify.notExists(link);
        this.assertDelListLength(4);
        this.validateTmpDir();
        File linkDir = new File(this.del, "tmpDir");
        ret = FileUtil.fullyDelete((File)linkDir);
        Assert.assertTrue((boolean)ret);
        Verify.notExists(linkDir);
        this.assertDelListLength(3);
        this.validateTmpDir();
    }

    @Test(timeout=30000L)
    public void testFullyDeleteDanglingSymlinks() throws IOException {
        boolean ret = FileUtil.fullyDelete((File)this.tmp);
        Assert.assertTrue((boolean)ret);
        Verify.notExists(this.tmp);
        File link = new File(this.del, LINK);
        this.assertDelListLength(5);
        ret = FileUtil.fullyDelete((File)link);
        Assert.assertTrue((boolean)ret);
        this.assertDelListLength(4);
        File linkDir = new File(this.del, "tmpDir");
        ret = FileUtil.fullyDelete((File)linkDir);
        Assert.assertTrue((boolean)ret);
        this.assertDelListLength(3);
    }

    @Test(timeout=30000L)
    public void testFullyDeleteContents() throws IOException {
        boolean ret = FileUtil.fullyDeleteContents((File)this.del);
        Assert.assertTrue((boolean)ret);
        Verify.exists(this.del);
        Assert.assertEquals((long)0L, (long)Objects.requireNonNull(this.del.listFiles()).length);
        this.validateTmpDir();
    }

    private void validateTmpDir() {
        Verify.exists(this.tmp);
        Assert.assertEquals((long)1L, (long)Objects.requireNonNull(this.tmp.listFiles()).length);
        Verify.exists(new File(this.tmp, FILE));
    }

    private void setupDirsAndNonWritablePermissions() throws IOException {
        Verify.createNewFile(new MyFile(this.del, FILE_1_NAME));
        Verify.mkdirs(this.xSubDir);
        Verify.createNewFile(this.file2);
        Verify.mkdirs(this.xSubSubDir);
        Verify.createNewFile(this.file22);
        TestFileUtil.revokePermissions(this.file22);
        TestFileUtil.revokePermissions(this.xSubSubDir);
        TestFileUtil.revokePermissions(this.file2);
        TestFileUtil.revokePermissions(this.xSubDir);
        Verify.mkdirs(this.ySubDir);
        Verify.createNewFile(this.file3);
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        FileUtil.symLink((String)tmpFile.toString(), (String)this.zlink.toString());
    }

    private static void grantPermissions(File f) {
        FileUtil.setReadable((File)f, (boolean)true);
        FileUtil.setWritable((File)f, (boolean)true);
        FileUtil.setExecutable((File)f, (boolean)true);
    }

    private static void revokePermissions(File f) {
        FileUtil.setWritable((File)f, (boolean)false);
        FileUtil.setExecutable((File)f, (boolean)false);
        FileUtil.setReadable((File)f, (boolean)false);
    }

    private void validateAndSetWritablePermissions(boolean expectedRevokedPermissionDirsExist, boolean ret) {
        TestFileUtil.grantPermissions(this.xSubDir);
        TestFileUtil.grantPermissions(this.xSubSubDir);
        Assert.assertFalse((String)"The return value should have been false.", (boolean)ret);
        Assert.assertTrue((String)"The file file1 should not have been deleted.", (boolean)new File(this.del, FILE_1_NAME).exists());
        Assert.assertEquals((String)"The directory xSubDir *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.xSubDir.exists());
        Assert.assertEquals((String)"The file file2 *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.file2.exists());
        Assert.assertEquals((String)"The directory xSubSubDir *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.xSubSubDir.exists());
        Assert.assertEquals((String)"The file file22 *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.file22.exists());
        Assert.assertFalse((String)"The directory ySubDir should have been deleted.", (boolean)this.ySubDir.exists());
        Assert.assertFalse((String)"The link zlink should have been deleted.", (boolean)this.zlink.exists());
    }

    @Test(timeout=30000L)
    public void testFailFullyDelete() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        LOG.info("Running test to verify failure of fullyDelete()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDelete((File)new MyFile(this.del));
        this.validateAndSetWritablePermissions(true, ret);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteGrantPermissions() throws IOException {
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDelete((File)new MyFile(this.del), (boolean)true);
        this.validateAndSetWritablePermissions(false, ret);
    }

    private void assertDelListLength(int expectedLength) {
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])this.del.list()).describedAs("del list", new Object[0])).isNotNull()).hasSize(expectedLength);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteContents() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        LOG.info("Running test to verify failure of fullyDeleteContents()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDeleteContents((File)new MyFile(this.del));
        this.validateAndSetWritablePermissions(true, ret);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteContentsGrantPermissions() throws IOException {
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDeleteContents((File)new MyFile(this.del), (boolean)true);
        this.validateAndSetWritablePermissions(false, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testGetDU() throws Exception {
        long du = FileUtil.getDU((File)this.testFolder.getRoot());
        long expected = 2 * (3 + System.getProperty("line.separator").length());
        Assert.assertEquals((long)expected, (long)du);
        File doesNotExist = new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog");
        long duDoesNotExist = FileUtil.getDU((File)doesNotExist);
        Assert.assertEquals((long)0L, (long)duDoesNotExist);
        File notADirectory = new File(this.partitioned, "part-r-00000");
        long duNotADirectoryActual = FileUtil.getDU((File)notADirectory);
        long duNotADirectoryExpected = 3 + System.getProperty("line.separator").length();
        Assert.assertEquals((long)duNotADirectoryExpected, (long)duNotADirectoryActual);
        try {
            try {
                FileUtil.chmod((String)notADirectory.getAbsolutePath(), (String)"0000");
            }
            catch (InterruptedException ie) {
                Assert.assertNull((Object)ie);
            }
            Assert.assertFalse((boolean)FileUtil.canRead((File)notADirectory));
            long du3 = FileUtil.getDU((File)this.partitioned);
            Assert.assertEquals((long)expected, (long)du3);
            try {
                FileUtil.chmod((String)this.partitioned.getAbsolutePath(), (String)"0000");
            }
            catch (InterruptedException ie) {
                Assert.assertNull((Object)ie);
            }
            Assert.assertFalse((boolean)FileUtil.canRead((File)this.partitioned));
            long du4 = FileUtil.getDU((File)this.partitioned);
            Assert.assertEquals((long)0L, (long)du4);
        }
        finally {
            FileUtil.chmod((String)this.partitioned.getAbsolutePath(), (String)"0777", (boolean)true);
        }
    }

    @Test(timeout=30000L)
    public void testUnTar() throws Exception {
        File simpleTar = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleTar);
        try (TarOutputStream tos = new TarOutputStream((OutputStream)os);){
            TarEntry te = new TarEntry("/bar/foo");
            byte[] data = "some-content".getBytes("UTF-8");
            te.setSize((long)data.length);
            tos.putNextEntry(te);
            tos.write(data);
            tos.closeEntry();
            tos.flush();
            tos.finish();
        }
        FileUtil.unTar((File)simpleTar, (File)this.tmp);
        Verify.exists(new File(this.tmp, "/bar/foo"));
        Assert.assertEquals((long)12L, (long)new File(this.tmp, "/bar/foo").length());
        File regularFile = Verify.createNewFile(new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog"));
        LambdaTestUtils.intercept(IOException.class, () -> FileUtil.unTar((File)simpleTar, (File)regularFile));
    }

    @Test(timeout=30000L)
    public void testReplaceFile() throws IOException {
        File srcFile = Verify.createNewFile(new File(this.tmp, "src"));
        File targetFile = new File(this.tmp, "target");
        Verify.notExists(targetFile);
        FileUtil.replaceFile((File)srcFile, (File)targetFile);
        Verify.notExists(srcFile);
        Verify.exists(targetFile);
        Verify.createNewFile(srcFile);
        Verify.exists(srcFile);
        FileUtil.replaceFile((File)srcFile, (File)targetFile);
        Verify.notExists(srcFile);
        Verify.exists(targetFile);
        Verify.createNewFile(srcFile);
        Verify.exists(srcFile);
        Verify.delete(targetFile);
        Verify.mkdirs(targetFile);
        File obstacle = Verify.createNewFile(new File(targetFile, "obstacle"));
        Assert.assertTrue((targetFile.exists() && targetFile.isDirectory() ? 1 : 0) != 0);
        try {
            FileUtil.replaceFile((File)srcFile, (File)targetFile);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Verify.exists(srcFile);
        Assert.assertTrue((targetFile.exists() && targetFile.isDirectory() ? 1 : 0) != 0);
        Verify.exists(obstacle);
    }

    @Test(timeout=30000L)
    public void testCreateLocalTempFile() throws IOException {
        File baseFile = new File(this.tmp, "base");
        File tmp1 = FileUtil.createLocalTempFile((File)baseFile, (String)"foo", (boolean)false);
        File tmp2 = FileUtil.createLocalTempFile((File)baseFile, (String)"foo", (boolean)true);
        Assert.assertFalse((boolean)tmp1.getAbsolutePath().equals(baseFile.getAbsolutePath()));
        Assert.assertFalse((boolean)tmp2.getAbsolutePath().equals(baseFile.getAbsolutePath()));
        Assert.assertTrue((tmp1.exists() && tmp2.exists() ? 1 : 0) != 0);
        Assert.assertTrue((tmp1.canWrite() && tmp2.canWrite() ? 1 : 0) != 0);
        Assert.assertTrue((tmp1.canRead() && tmp2.canRead() ? 1 : 0) != 0);
        Verify.delete(tmp1);
        Verify.delete(tmp2);
        Assert.assertTrue((!tmp1.exists() && !tmp2.exists() ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testUnZip() throws Exception {
        File simpleZip = new File(this.del, FILE);
        try (FileOutputStream os = new FileOutputStream(simpleZip);
             ZipArchiveOutputStream tos = new ZipArchiveOutputStream((OutputStream)os);){
            ArrayList<ZipArchiveEntry> ZipArchiveList = new ArrayList<ZipArchiveEntry>(7);
            int count = 0;
            for (int i = 0; i < 7; ++i) {
                ZipArchiveList.add(new ZipArchiveEntry("foo_" + i));
                ZipArchiveEntry archiveEntry = (ZipArchiveEntry)ZipArchiveList.get(i);
                archiveEntry.setUnixMode(count += 64);
                byte[] data = "some-content".getBytes("UTF-8");
                archiveEntry.setSize((long)data.length);
                tos.putArchiveEntry((ArchiveEntry)archiveEntry);
                tos.write(data);
            }
            tos.closeArchiveEntry();
            tos.flush();
            tos.finish();
        }
        FileUtil.unZip((File)simpleZip, (File)this.tmp);
        File foo0 = new File(this.tmp, "foo_0");
        File foo1 = new File(this.tmp, "foo_1");
        File foo2 = new File(this.tmp, "foo_2");
        File foo3 = new File(this.tmp, "foo_3");
        File foo4 = new File(this.tmp, "foo_4");
        File foo5 = new File(this.tmp, "foo_5");
        File foo6 = new File(this.tmp, "foo_6");
        Assert.assertTrue((boolean)foo0.exists());
        Assert.assertTrue((boolean)foo1.exists());
        Assert.assertTrue((boolean)foo2.exists());
        Assert.assertTrue((boolean)foo3.exists());
        Assert.assertTrue((boolean)foo4.exists());
        Assert.assertTrue((boolean)foo5.exists());
        Assert.assertTrue((boolean)foo6.exists());
        Assert.assertEquals((long)12L, (long)foo0.length());
        Assert.assertTrue((String)"file lacks execute permissions", (boolean)foo0.canExecute());
        Assert.assertFalse((String)"file has write permissions", (boolean)foo0.canWrite());
        Assert.assertFalse((String)"file has read permissions", (boolean)foo0.canRead());
        Assert.assertFalse((String)"file has execute permissions", (boolean)foo1.canExecute());
        Assert.assertTrue((String)"file lacks write permissions", (boolean)foo1.canWrite());
        Assert.assertFalse((String)"file has read permissions", (boolean)foo1.canRead());
        Assert.assertTrue((String)"file lacks execute permissions", (boolean)foo2.canExecute());
        Assert.assertTrue((String)"file lacks write permissions", (boolean)foo2.canWrite());
        Assert.assertFalse((String)"file has read permissions", (boolean)foo2.canRead());
        Assert.assertFalse((String)"file has execute permissions", (boolean)foo3.canExecute());
        Assert.assertFalse((String)"file has write permissions", (boolean)foo3.canWrite());
        Assert.assertTrue((String)"file lacks read permissions", (boolean)foo3.canRead());
        Assert.assertTrue((String)"file lacks execute permissions", (boolean)foo4.canExecute());
        Assert.assertFalse((String)"file has write permissions", (boolean)foo4.canWrite());
        Assert.assertTrue((String)"file lacks read permissions", (boolean)foo4.canRead());
        Assert.assertFalse((String)"file has execute permissions", (boolean)foo5.canExecute());
        Assert.assertTrue((String)"file lacks write permissions", (boolean)foo5.canWrite());
        Assert.assertTrue((String)"file lacks read permissions", (boolean)foo5.canRead());
        Assert.assertTrue((String)"file lacks execute permissions", (boolean)foo6.canExecute());
        Assert.assertTrue((String)"file lacks write permissions", (boolean)foo6.canWrite());
        Assert.assertTrue((String)"file lacks read permissions", (boolean)foo6.canRead());
        File regularFile = Verify.createNewFile(new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog"));
        LambdaTestUtils.intercept(IOException.class, () -> FileUtil.unZip((File)simpleZip, (File)regularFile));
    }

    @Test(timeout=30000L)
    public void testUnZip2() throws IOException {
        File simpleZip = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleZip);
        try (ZipArchiveOutputStream tos = new ZipArchiveOutputStream((OutputStream)os);){
            ZipArchiveEntry ze = new ZipArchiveEntry("../foo");
            byte[] data = "some-content".getBytes(StandardCharsets.UTF_8);
            ze.setSize((long)data.length);
            tos.putArchiveEntry((ArchiveEntry)ze);
            tos.write(data);
            tos.closeArchiveEntry();
            tos.flush();
            tos.finish();
        }
        try {
            FileUtil.unZip((File)simpleZip, (File)this.tmp);
            Assert.fail((String)"unZip should throw IOException.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("would create file outside of", e);
        }
    }

    @Test(timeout=30000L)
    public void testCopy5() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.newInstance((URI)uri, (Configuration)conf);
        String content = "some-content";
        File srcFile = this.createFile(this.tmp, "src", "some-content");
        Path srcPath = new Path(srcFile.toURI());
        File dest = new File(this.del, "dest");
        boolean result = FileUtil.copy((FileSystem)fs, (Path)srcPath, (File)dest, (boolean)false, (Configuration)conf);
        Assert.assertTrue((boolean)result);
        Verify.exists(dest);
        Assert.assertEquals((long)("some-content".getBytes().length + System.getProperty("line.separator").getBytes().length), (long)dest.length());
        Verify.exists(srcFile);
        Verify.delete(dest);
        Verify.notExists(dest);
        result = FileUtil.copy((FileSystem)fs, (Path)srcPath, (File)dest, (boolean)true, (Configuration)conf);
        Assert.assertTrue((boolean)result);
        Verify.exists(dest);
        Assert.assertEquals((long)("some-content".getBytes().length + System.getProperty("line.separator").getBytes().length), (long)dest.length());
        Verify.notExists(srcFile);
        Verify.delete(dest);
        Verify.notExists(dest);
        srcPath = new Path(this.partitioned.toURI());
        result = FileUtil.copy((FileSystem)fs, (Path)srcPath, (File)dest, (boolean)true, (Configuration)conf);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((dest.exists() && dest.isDirectory() ? 1 : 0) != 0);
        File[] files = dest.listFiles();
        Assert.assertTrue((files != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)files.length);
        for (File f : files) {
            Assert.assertEquals((long)(3 + System.getProperty("line.separator").getBytes().length), (long)f.length());
        }
        Verify.notExists(this.partitioned);
    }

    @Test(timeout=30000L)
    public void testStat2Paths1() {
        Assert.assertNull((Object)FileUtil.stat2Paths(null));
        FileStatus[] fileStatuses = new FileStatus[]{};
        Path[] paths = FileUtil.stat2Paths((FileStatus[])fileStatuses);
        Assert.assertEquals((long)0L, (long)paths.length);
        Path path1 = new Path("file://foo");
        Path path2 = new Path("file://moo");
        fileStatuses = new FileStatus[]{new FileStatus(3L, false, 0, 0L, 0L, path1), new FileStatus(3L, false, 0, 0L, 0L, path2)};
        paths = FileUtil.stat2Paths((FileStatus[])fileStatuses);
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertEquals((Object)paths[0], (Object)path1);
        Assert.assertEquals((Object)paths[1], (Object)path2);
    }

    @Test(timeout=30000L)
    public void testStat2Paths2() {
        Path defaultPath = new Path("file://default");
        Path[] paths = FileUtil.stat2Paths(null, (Path)defaultPath);
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)defaultPath, (Object)paths[0]);
        paths = FileUtil.stat2Paths(null, null);
        Assert.assertTrue((paths != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals(null, (Object)paths[0]);
        Path path1 = new Path("file://foo");
        Path path2 = new Path("file://moo");
        FileStatus[] fileStatuses = new FileStatus[]{new FileStatus(3L, false, 0, 0L, 0L, path1), new FileStatus(3L, false, 0, 0L, 0L, path2)};
        paths = FileUtil.stat2Paths((FileStatus[])fileStatuses, (Path)defaultPath);
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertEquals((Object)paths[0], (Object)path1);
        Assert.assertEquals((Object)paths[1], (Object)path2);
    }

    @Test(timeout=30000L)
    public void testSymlink() throws Exception {
        byte[] data = "testSymLink".getBytes();
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        FileOutputStream os = new FileOutputStream(file);
        os.write(data);
        os.close();
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)data.length, (long)file.length());
        Assert.assertEquals((long)data.length, (long)link.length());
        FileInputStream in = new FileInputStream(link);
        long len = 0L;
        while (in.read() > 0) {
            ++len;
        }
        in.close();
        Assert.assertEquals((long)data.length, (long)len);
    }

    @Test(timeout=30000L)
    public void testSymlinkRenameTo() throws Exception {
        File file = new File(this.del, FILE);
        file.createNewFile();
        File link = new File(this.del, "_link");
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Verify.exists(file);
        Verify.exists(link);
        File link2 = new File(this.del, "_link2");
        Assert.assertTrue((boolean)link.renameTo(link2));
        Verify.exists(file);
        Verify.exists(link2);
        Verify.notExists(link);
    }

    @Test(timeout=30000L)
    public void testSymlinkDelete() throws Exception {
        File file = new File(this.del, FILE);
        file.createNewFile();
        File link = new File(this.del, "_link");
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Verify.exists(file);
        Verify.exists(link);
        Verify.delete(link);
        Verify.notExists(link);
        Verify.exists(file);
    }

    @Test(timeout=30000L)
    public void testSymlinkLength() throws Exception {
        byte[] data = "testSymLinkData".getBytes();
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        FileOutputStream os = new FileOutputStream(file);
        os.write(data);
        os.close();
        Assert.assertEquals((long)0L, (long)link.length());
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)data.length, (long)file.length());
        Assert.assertEquals((long)data.length, (long)link.length());
        Verify.delete(file);
        Verify.notExists(file);
        Assert.assertEquals((long)0L, (long)link.length());
        Verify.delete(link);
        Verify.notExists(link);
    }

    @Test
    public void testSymlinkWithNullInput() throws IOException {
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        int result = FileUtil.symLink(null, null);
        Assert.assertEquals((long)1L, (long)result);
        result = FileUtil.symLink((String)file.getAbsolutePath(), null);
        Assert.assertEquals((long)1L, (long)result);
        result = FileUtil.symLink(null, (String)link.getAbsolutePath());
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testSymlinkFileAlreadyExists() throws IOException {
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        int result1 = FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)result1);
        result1 = FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)1L, (long)result1);
    }

    @Test
    public void testSymlinkSameFile() throws IOException {
        File file = new File(this.del, FILE);
        Verify.delete(file);
        int result = FileUtil.symLink((String)file.getAbsolutePath(), (String)file.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testSymlink2DifferentFile() throws IOException {
        File file = new File(this.del, FILE);
        File fileSecond = new File(this.del, "x_1");
        File link = new File(this.del, "_link");
        int result = FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)result);
        result = FileUtil.symLink((String)fileSecond.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testSymlink2DifferentLinks() throws IOException {
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        File linkSecond = new File(this.del, "_link_1");
        int result = FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)result);
        result = FileUtil.symLink((String)file.getAbsolutePath(), (String)linkSecond.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)result);
    }

    private void doUntarAndVerify(File tarFile, File untarDir) throws IOException {
        if (untarDir.exists() && !FileUtil.fullyDelete((File)untarDir)) {
            throw new IOException("Could not delete directory '" + untarDir + "'");
        }
        FileUtil.unTar((File)tarFile, (File)untarDir);
        String parentDir = untarDir.getCanonicalPath() + "/" + "name";
        File testFile = new File(parentDir + "/" + "version");
        Verify.exists(testFile);
        Assert.assertTrue((testFile.length() == 0L ? 1 : 0) != 0);
        String imageDir = parentDir + "/" + "image";
        testFile = new File(imageDir + "/" + "fsimage");
        Verify.exists(testFile);
        Assert.assertTrue((testFile.length() == 157L ? 1 : 0) != 0);
        String currentDir = parentDir + "/" + "current";
        testFile = new File(currentDir + "/" + "fsimage");
        Verify.exists(testFile);
        Assert.assertTrue((testFile.length() == 4331L ? 1 : 0) != 0);
        testFile = new File(currentDir + "/" + "edits");
        Verify.exists(testFile);
        Assert.assertTrue((testFile.length() == 1033L ? 1 : 0) != 0);
        testFile = new File(currentDir + "/" + "fstime");
        Verify.exists(testFile);
        Assert.assertTrue((testFile.length() == 8L ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testUntar() throws IOException {
        String tarGzFileName = System.getProperty("test.cache.data", "target/test/cache") + "/test-untar.tgz";
        String tarFileName = System.getProperty("test.cache.data", "build/test/cache") + "/test-untar.tar";
        File dataDir = GenericTestUtils.getTestDir();
        File untarDir = new File(dataDir, "untarDir");
        this.doUntarAndVerify(new File(tarGzFileName), untarDir);
        this.doUntarAndVerify(new File(tarFileName), untarDir);
    }

    @Test(timeout=30000L)
    public void testUntarMissingFile() throws Throwable {
        File dataDir = GenericTestUtils.getTestDir();
        File tarFile = new File(dataDir, "missing; true");
        File untarDir = new File(dataDir, "untarDir");
        LambdaTestUtils.intercept(IOException.class, () -> FileUtil.unTar((File)tarFile, (File)untarDir));
    }

    @Test(timeout=30000L)
    public void testUntarMissingFileThroughJava() throws Throwable {
        File dataDir = GenericTestUtils.getTestDir();
        File tarFile = new File(dataDir, "missing; true");
        File untarDir = new File(dataDir, "untarDir");
        LambdaTestUtils.intercept(IOException.class, () -> FileUtil.unTarUsingJava((File)tarFile, (File)untarDir, (boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCreateJarWithClassPath() throws Exception {
        List<File> wildcardMatches = Arrays.asList(new File(this.tmp, "wildcard1.jar"), new File(this.tmp, "wildcard2.jar"), new File(this.tmp, "wildcard3.JAR"), new File(this.tmp, "wildcard4.JAR"));
        for (File wildcardMatch : wildcardMatches) {
            Assert.assertTrue((String)("failure creating file: " + wildcardMatch), (boolean)wildcardMatch.createNewFile());
        }
        Verify.createNewFile(new File(this.tmp, "text.txt"));
        Verify.createNewFile(new File(this.tmp, "executable.exe"));
        Verify.createNewFile(new File(this.tmp, "README"));
        String wildcardPath = this.tmp.getCanonicalPath() + File.separator + "*";
        String nonExistentSubdir = this.tmp.getCanonicalPath() + "/" + "subdir" + "/";
        List<String> classPaths = Arrays.asList("", "cp1.jar", "cp2.jar", wildcardPath, "cp3.jar", nonExistentSubdir);
        String inputClassPath = StringUtils.join((CharSequence)File.pathSeparator, classPaths);
        String[] jarCp = FileUtil.createJarWithClassPath((String)(inputClassPath + File.pathSeparator + "unexpandedwildcard/*"), (Path)new Path(this.tmp.getCanonicalPath()), System.getenv());
        String classPathJar = jarCp[0];
        Assert.assertNotEquals((String)"Unexpanded wildcard was not placed in extra classpath", (long)jarCp[1].indexOf("unexpanded"), (long)-1L);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(classPathJar);
            Manifest jarManifest = jarFile.getManifest();
            Assert.assertNotNull((Object)jarManifest);
            Attributes mainAttributes = jarManifest.getMainAttributes();
            Assert.assertNotNull((Object)mainAttributes);
            Assert.assertTrue((boolean)mainAttributes.containsKey(Attributes.Name.CLASS_PATH));
            String classPathAttr = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
            Assert.assertNotNull((Object)classPathAttr);
            ArrayList<String> expectedClassPaths = new ArrayList<String>();
            for (String classPath : classPaths) {
                if (classPath.length() == 0) continue;
                if (wildcardPath.equals(classPath)) {
                    for (File wildcardMatch : wildcardMatches) {
                        expectedClassPaths.add(wildcardMatch.getCanonicalFile().toURI().toURL().toExternalForm());
                    }
                    continue;
                }
                File fileCp = null;
                fileCp = !new Path(classPath).isAbsolute() ? new File(this.tmp, classPath).getCanonicalFile() : new File(classPath).getCanonicalFile();
                if (nonExistentSubdir.equals(classPath)) {
                    expectedClassPaths.add(fileCp.toURI().toURL().toExternalForm() + "/");
                    continue;
                }
                expectedClassPaths.add(fileCp.toURI().toURL().toExternalForm());
            }
            List<String> actualClassPaths = Arrays.asList(classPathAttr.split(" "));
            Collections.sort(expectedClassPaths);
            Collections.sort(actualClassPaths);
            Assert.assertEquals(expectedClassPaths, actualClassPaths);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LOG.warn("exception closing jarFile: " + classPathJar, (Throwable)e);
                }
            }
        }
    }

    @Test
    public void testGetJarsInDirectory() throws Exception {
        List jars = FileUtil.getJarsInDirectory((String)"/foo/bar/bogus/");
        Assert.assertTrue((String)"no jars should be returned for a bogus path", (boolean)jars.isEmpty());
        File jar1 = new File(this.tmp, "wildcard1.jar");
        File jar2 = new File(this.tmp, "wildcard2.JAR");
        List<File> matches = Arrays.asList(jar1, jar2);
        for (File match : matches) {
            Assert.assertTrue((String)("failure creating file: " + match), (boolean)match.createNewFile());
        }
        Verify.createNewFile(new File(this.tmp, "text.txt"));
        Verify.createNewFile(new File(this.tmp, "executable.exe"));
        Verify.createNewFile(new File(this.tmp, "README"));
        String directory = this.tmp.getCanonicalPath();
        jars = FileUtil.getJarsInDirectory((String)directory);
        Assert.assertEquals((String)"there should be 2 jars", (long)2L, (long)jars.size());
        for (Path jar : jars) {
            URL url = jar.toUri().toURL();
            Assert.assertTrue((String)"the jar should match either of the jars", (url.equals(jar1.getCanonicalFile().toURI().toURL()) || url.equals(jar2.getCanonicalFile().toURI().toURL()) ? 1 : 0) != 0);
        }
    }

    @Ignore
    public void setupCompareFs() {
        String host1 = "1.2.3.4";
        String host2 = "2.3.4.5";
        int port1 = 7000;
        int port2 = 7001;
        String uris1 = "hdfs://" + host1 + ":" + Integer.toString(port1) + "/tmp/foo";
        String uris2 = "hdfs://" + host1 + ":" + Integer.toString(port2) + "/tmp/foo";
        String uris3 = "hdfs://" + host2 + ":" + Integer.toString(port2) + "/tmp/foo";
        String uris4 = "hdfs://" + host2 + ":" + Integer.toString(port2) + "/tmp/foo";
        String uris5 = "file:///" + host1 + ":" + Integer.toString(port1) + "/tmp/foo";
        String uris6 = "hdfs:///" + host1 + "/tmp/foo";
        try {
            this.uri1 = new URI(uris1);
            this.uri2 = new URI(uris2);
            this.uri3 = new URI(uris3);
            this.uri4 = new URI(uris4);
            this.uri5 = new URI(uris5);
            this.uri6 = new URI(uris6);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.inet1 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet1.getCanonicalHostName()).thenReturn((Object)host1);
        this.inet2 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet2.getCanonicalHostName()).thenReturn((Object)host1);
        this.inet3 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet3.getCanonicalHostName()).thenReturn((Object)host2);
        this.inet4 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet4.getCanonicalHostName()).thenReturn((Object)host2);
        this.inet5 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet5.getCanonicalHostName()).thenReturn((Object)host1);
        this.inet6 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet6.getCanonicalHostName()).thenReturn((Object)host1);
        try {
            Mockito.when((Object)InetAddress.getByName(uris1)).thenReturn((Object)this.inet1);
            Mockito.when((Object)InetAddress.getByName(uris2)).thenReturn((Object)this.inet2);
            Mockito.when((Object)InetAddress.getByName(uris3)).thenReturn((Object)this.inet3);
            Mockito.when((Object)InetAddress.getByName(uris4)).thenReturn((Object)this.inet4);
            Mockito.when((Object)InetAddress.getByName(uris5)).thenReturn((Object)this.inet5);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.fs1 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs1.getUri()).thenReturn((Object)this.uri1);
        this.fs2 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs2.getUri()).thenReturn((Object)this.uri2);
        this.fs3 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs3.getUri()).thenReturn((Object)this.uri3);
        this.fs4 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs4.getUri()).thenReturn((Object)this.uri4);
        this.fs5 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs5.getUri()).thenReturn((Object)this.uri5);
        this.fs6 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs6.getUri()).thenReturn((Object)this.uri6);
    }

    @Test
    public void testCompareFsNull() throws Exception {
        this.setupCompareFs();
        Assert.assertFalse((boolean)FileUtil.compareFs(null, (FileSystem)this.fs1));
        Assert.assertFalse((boolean)FileUtil.compareFs((FileSystem)this.fs1, null));
    }

    @Test
    public void testCompareFsDirectories() throws Exception {
        this.setupCompareFs();
        Assert.assertTrue((boolean)FileUtil.compareFs((FileSystem)this.fs1, (FileSystem)this.fs1));
        Assert.assertFalse((boolean)FileUtil.compareFs((FileSystem)this.fs1, (FileSystem)this.fs2));
        Assert.assertFalse((boolean)FileUtil.compareFs((FileSystem)this.fs1, (FileSystem)this.fs5));
        Assert.assertTrue((boolean)FileUtil.compareFs((FileSystem)this.fs3, (FileSystem)this.fs4));
        Assert.assertFalse((boolean)FileUtil.compareFs((FileSystem)this.fs1, (FileSystem)this.fs6));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=8000L)
    public void testCreateSymbolicLinkUsingJava() throws IOException {
        File simpleTar = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleTar);
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)os);){
            String tmpDir = "tmp/test";
            File tmpDir1 = new File("tmp/test", "dir1/");
            File tmpDir2 = new File("tmp/test", "dir2/");
            Verify.mkdirs(tmpDir1);
            Verify.mkdirs(tmpDir2);
            java.nio.file.Path symLink = Paths.get(tmpDir1.getPath(), "sl");
            Files.createSymbolicLink(symLink, Paths.get(tmpDir2.getPath(), new String[0]), new FileAttribute[0]);
            Assert.assertTrue((boolean)Files.isSymbolicLink(symLink.toAbsolutePath()));
            this.putEntriesInTar(tos, tmpDir1.getParentFile());
            tos.close();
            File untarFile = new File("tmp/test", "2");
            FileUtil.unTarUsingJava((File)simpleTar, (File)untarFile, (boolean)false);
            Assert.assertTrue((boolean)Files.exists(untarFile.toPath(), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.exists(Paths.get(untarFile.getPath(), "tmp/test"), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isSymbolicLink(Paths.get(untarFile.getPath(), symLink.toString())));
        }
        finally {
            FileUtils.deleteDirectory((File)new File("tmp"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testCreateArbitrarySymlinkUsingJava() throws IOException {
        File simpleTar = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleTar);
        File rootDir = new File("tmp");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)os);){
            tos.setLongFileMode(2);
            File arbitraryDir = new File(rootDir, "arbitrary-dir/");
            Verify.mkdirs(arbitraryDir);
            File tarRoot = new File(rootDir, "tar-root/");
            File symlinkRoot = new File(tarRoot, "dir1/");
            Verify.mkdirs(symlinkRoot);
            java.nio.file.Path symLink = Paths.get(symlinkRoot.getPath(), "sl");
            Files.createSymbolicLink(symLink, arbitraryDir.toPath().toAbsolutePath(), new FileAttribute[0]);
            this.putEntriesInTar(tos, tarRoot);
            this.putEntriesInTar(tos, new File(symLink.toFile(), "dir-outside-tar-root/"));
            tos.close();
            File untarFile = new File(rootDir, "extracted");
            FileUtil.unTarUsingJava((File)simpleTar, (File)untarFile, (boolean)false);
        }
        finally {
            FileUtils.deleteDirectory((File)rootDir);
        }
    }

    private void putEntriesInTar(TarArchiveOutputStream tos, File f) throws IOException {
        if (Files.isSymbolicLink(f.toPath())) {
            TarArchiveEntry tarEntry = new TarArchiveEntry(f.getPath(), 50);
            tarEntry.setLinkName(Files.readSymbolicLink(f.toPath()).toString());
            tos.putArchiveEntry((ArchiveEntry)tarEntry);
            tos.closeArchiveEntry();
            return;
        }
        if (f.isDirectory()) {
            tos.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(f));
            tos.closeArchiveEntry();
            for (File child : f.listFiles()) {
                this.putEntriesInTar(tos, child);
            }
        }
        if (f.isFile()) {
            int count;
            tos.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(f));
            BufferedInputStream origin = new BufferedInputStream(new FileInputStream(f));
            byte[] data = new byte[2048];
            while ((count = origin.read(data)) != -1) {
                tos.write(data, 0, count);
            }
            tos.flush();
            tos.closeArchiveEntry();
            origin.close();
        }
    }

    @Test
    public void testReadSymlinkWithNullInput() {
        String result = FileUtil.readLink(null);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testReadSymlink() throws IOException {
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        String result = FileUtil.readLink((File)link);
        Assert.assertEquals((Object)file.getAbsolutePath(), (Object)result);
    }

    @Test
    public void testReadSymlinkWithAFileAsInput() throws IOException {
        File file = new File(this.del, FILE);
        String result = FileUtil.readLink((File)file);
        Assert.assertEquals((Object)"", (Object)result);
        Verify.delete(file);
    }

    @Test
    public void testWriteBytesFileSystem() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Path testPath = new Path(new Path(uri), "writebytes.out");
        byte[] write = new byte[]{0, 1, 2, 3};
        FileUtil.write((FileSystem)fs, (Path)testPath, (byte[])write);
        byte[] read = FileUtils.readFileToByteArray((File)new File(testPath.toUri()));
        Assert.assertArrayEquals((byte[])write, (byte[])read);
    }

    @Test
    public void testWriteStringsFileSystem() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Path testPath = new Path(new Path(uri), "writestrings.out");
        List<String> write = Arrays.asList("over", "the", "lazy", "dog");
        FileUtil.write((FileSystem)fs, (Path)testPath, write, (Charset)StandardCharsets.UTF_8);
        List read = FileUtils.readLines((File)new File(testPath.toUri()), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals(write, (Object)read);
    }

    @Test
    public void testWriteStringFileSystem() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Path testPath = new Path(new Path(uri), "writestring.out");
        String write = "A\u00ea\u00f1\u00fcC";
        FileUtil.write((FileSystem)fs, (Path)testPath, (CharSequence)write, (Charset)StandardCharsets.UTF_8);
        String read = FileUtils.readFileToString((File)new File(testPath.toUri()), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)write, (Object)read);
    }

    @Test
    public void testWriteStringNoCharSetFileSystem() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Path testPath = new Path(new Path(uri), "writestring.out");
        String write = "A\u00ea\u00f1\u00fcC";
        FileUtil.write((FileSystem)fs, (Path)testPath, (CharSequence)write);
        String read = FileUtils.readFileToString((File)new File(testPath.toUri()), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)write, (Object)read);
    }

    @Test
    public void testWriteBytesFileContext() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileContext fc = FileContext.getFileContext((URI)uri, (Configuration)conf);
        Path testPath = new Path(new Path(uri), "writebytes.out");
        byte[] write = new byte[]{0, 1, 2, 3};
        FileUtil.write((FileContext)fc, (Path)testPath, (byte[])write);
        byte[] read = FileUtils.readFileToByteArray((File)new File(testPath.toUri()));
        Assert.assertArrayEquals((byte[])write, (byte[])read);
    }

    @Test
    public void testWriteStringsFileContext() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileContext fc = FileContext.getFileContext((URI)uri, (Configuration)conf);
        Path testPath = new Path(new Path(uri), "writestrings.out");
        List<String> write = Arrays.asList("over", "the", "lazy", "dog");
        FileUtil.write((FileContext)fc, (Path)testPath, write, (Charset)StandardCharsets.UTF_8);
        List read = FileUtils.readLines((File)new File(testPath.toUri()), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals(write, (Object)read);
    }

    @Test
    public void testWriteStringFileContext() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileContext fc = FileContext.getFileContext((URI)uri, (Configuration)conf);
        Path testPath = new Path(new Path(uri), "writestring.out");
        String write = "A\u00ea\u00f1\u00fcC";
        FileUtil.write((FileContext)fc, (Path)testPath, (CharSequence)write, (Charset)StandardCharsets.UTF_8);
        String read = FileUtils.readFileToString((File)new File(testPath.toUri()), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)write, (Object)read);
    }

    @Test
    public void testWriteStringNoCharSetFileContext() throws IOException {
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileContext fc = FileContext.getFileContext((URI)uri, (Configuration)conf);
        Path testPath = new Path(new Path(uri), "writestring.out");
        String write = "A\u00ea\u00f1\u00fcC";
        FileUtil.write((FileContext)fc, (Path)testPath, (CharSequence)write);
        String read = FileUtils.readFileToString((File)new File(testPath.toUri()), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)write, (Object)read);
    }

    public static int getCacheSize() {
        return FileSystem.cacheSize();
    }

    public static class MyFile
    extends File {
        private static final long serialVersionUID = 1L;

        public MyFile(File f) {
            super(f.getAbsolutePath());
        }

        public MyFile(File parent, String child) {
            super(parent, child);
        }

        @Override
        public boolean delete() {
            LOG.info("Trying to delete myFile " + this.getAbsolutePath());
            boolean bool = false;
            bool = this.getName().equals(TestFileUtil.FILE_1_NAME) ? false : super.delete();
            if (bool) {
                LOG.info("Deleted " + this.getAbsolutePath() + " successfully");
            } else {
                LOG.info("Cannot delete " + this.getAbsolutePath());
            }
            return bool;
        }

        @Override
        public File[] listFiles() {
            File[] files = super.listFiles();
            if (files == null) {
                return null;
            }
            List<File> filesList = Arrays.asList(files);
            Collections.sort(filesList);
            File[] myFiles = new MyFile[files.length];
            int i = 0;
            for (File f : filesList) {
                myFiles[i++] = new MyFile(f);
            }
            return myFiles;
        }
    }

    public static class Verify {
        public static File createNewFile(File file) throws IOException {
            Assert.assertTrue((String)("Unable to create new file " + file), (boolean)file.createNewFile());
            return file;
        }

        public static File mkdir(File file) {
            Assert.assertTrue((String)("Unable to mkdir for " + file), (boolean)file.mkdir());
            return file;
        }

        public static File mkdirs(File file) {
            Assert.assertTrue((String)("Unable to mkdirs for " + file), (boolean)file.mkdirs());
            return file;
        }

        public static File delete(File file) {
            Assert.assertTrue((String)("Unable to delete " + file), (boolean)file.delete());
            return file;
        }

        public static File exists(File file) {
            Assert.assertTrue((String)("Expected file " + file + " doesn't exist"), (boolean)file.exists());
            return file;
        }

        public static File notExists(File file) {
            Assert.assertFalse((String)("Expected file " + file + " must not exist"), (boolean)file.exists());
            return file;
        }
    }
}

