/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Set;
import org.apache.hadoop.hbase.logging.Log4jUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class LogMonitoring {
    public static void dumpTailOfLogs(PrintWriter out, long tailKb) throws IOException {
        Set<File> logs = Log4jUtils.getActiveLogFiles();
        for (File f : logs) {
            out.println("+++++++++++++++++++++++++++++++");
            out.println(f.getAbsolutePath());
            out.println("+++++++++++++++++++++++++++++++");
            try {
                LogMonitoring.dumpTailOfLog(f, out, tailKb);
            }
            catch (IOException ioe) {
                out.println("Unable to dump log at " + f);
                ioe.printStackTrace(out);
            }
            out.println("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void dumpTailOfLog(File f, PrintWriter out, long tailKb) throws IOException {
        FileInputStream fis;
        block4: {
            fis = new FileInputStream(f);
            BufferedReader r = null;
            try {
                String line;
                FileChannel channel = fis.getChannel();
                channel.position(Math.max(0L, channel.size() - tailKb * 1024L));
                r = new BufferedReader(new InputStreamReader(fis));
                r.readLine();
                while ((line = r.readLine()) != null) {
                    out.println(line);
                }
                if (r == null) break block4;
            }
            catch (Throwable throwable) {
                if (r != null) {
                    IOUtils.closeStream(r);
                }
                IOUtils.closeStream((Closeable)fis);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)fis);
    }
}

