/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import java.util.NoSuchElementException;
import org.apache.spark.util.collection.PercentileHeap$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4QAE\n\u0001/uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tS\u0001\u0011)\u0019!C\u0002U!Aq\u0007\u0001B\u0001B\u0003%1\u0006C\u00039\u0001\u0011\u0005\u0011\b\u0003\u0004@\u0001\u0001\u0006I\u0001\u0011\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002!\t\u000b!\u0003A\u0011A%\t\u000b5\u0003A\u0011\u0001(\t\u000bI\u0003A\u0011\u0001(\t\u000bM\u0003A\u0011\u0001+\t\u000bi\u0003A\u0011B.\t\r}\u0003\u0001\u0015\"\u0003a\u0011\u0015\t\u0007\u0001\"\u0001c\u000f!\u00197#!A\t\u0002]!g\u0001\u0003\n\u0014\u0003\u0003E\taF3\t\u000bazA\u0011\u00014\t\u000f\u001d|\u0011\u0013!C\u0001Q\nq\u0001+\u001a:dK:$\u0018\u000e\\3IK\u0006\u0004(B\u0001\u000b\u0016\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0003-]\tA!\u001e;jY*\u0011\u0001$G\u0001\u0006gB\f'o\u001b\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\f!\u0002]3sG\u0016tG/Y4f\u0007\u0001\u0001\"aH\u0014\n\u0005!\u0002#A\u0002#pk\ndW-A\u0002pe\u0012,\u0012a\u000b\t\u0004YQ2cBA\u00173\u001d\tq\u0013'D\u00010\u0015\t\u0001T%\u0001\u0004=e>|GOP\u0005\u0002C%\u00111\u0007I\u0001\ba\u0006\u001c7.Y4f\u0013\t)dG\u0001\u0005Pe\u0012,'/\u001b8h\u0015\t\u0019\u0004%\u0001\u0003pe\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002;}Q\u00111(\u0010\t\u0003y\u0001i\u0011a\u0005\u0005\u0006S\u0011\u0001\u001da\u000b\u0005\bI\u0011\u0001\n\u00111\u0001'\u0003-\u0019X.\u00197mKJD\u0015\r\u001c4\u0011\u0007\u0005+e%D\u0001C\u0015\t\u0019E)A\u0004nkR\f'\r\\3\u000b\u0005Q\u0001\u0013B\u0001$C\u00055\u0001&/[8sSRL\u0018+^3vK\u0006QA.\u0019:hKJD\u0015\r\u001c4\u0002\u000f%\u001cX)\u001c9usR\t!\n\u0005\u0002 \u0017&\u0011A\n\t\u0002\b\u0005>|G.Z1o\u0003\u0011\u0019\u0018N_3\u0015\u0003=\u0003\"a\b)\n\u0005E\u0003#aA%oi\u0006Y1/\\1mY\u0016\u00148+\u001b>f\u0003\u0019Ign]3siR\u0011Q\u000b\u0017\t\u0003?YK!a\u0016\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u00063*\u0001\rAJ\u0001\u0002q\u0006\u00112-\u00197dk2\fG/\u001a#fm&\fG/[8o)\r1C,\u0018\u0005\u0006%.\u0001\ra\u0014\u0005\u0006=.\u0001\raT\u0001\u000bY\u0006\u0014x-\u001a:TSj,\u0017!\u0003:fE\u0006d\u0017M\\2f)\u0005)\u0016A\u00039fe\u000e,g\u000e^5mKV\ta%\u0001\bQKJ\u001cWM\u001c;jY\u0016DU-\u00199\u0011\u0005qz1CA\b\u001f)\u0005!\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001jU\t1#nK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001\u000fI\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class PercentileHeap {
    private final double percentage;
    private final Ordering<Object> ord;
    private final PriorityQueue<Object> smallerHalf;
    private final PriorityQueue<Object> largerHalf;

    public static double $lessinit$greater$default$1() {
        return PercentileHeap$.MODULE$.$lessinit$greater$default$1();
    }

    public Ordering<Object> ord() {
        return this.ord;
    }

    public boolean isEmpty() {
        return this.smallerHalf.isEmpty() && this.largerHalf.isEmpty();
    }

    public int size() {
        return this.smallerHalf.size() + this.largerHalf.size();
    }

    public int smallerSize() {
        return this.smallerHalf.size();
    }

    public void insert(double x) {
        if (this.isEmpty()) {
            if (this.percentage < 0.5) {
                this.smallerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x}));
            } else {
                this.largerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x}));
            }
        } else if (x > this.percentile()) {
            this.largerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x}));
        } else {
            this.smallerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x}));
        }
        this.rebalance();
    }

    private double calculateDeviation(int smallerSize, int largerSize) {
        return (double)smallerSize * (1.0 - this.percentage) - (double)largerSize * this.percentage;
    }

    private void rebalance() {
        double newDev;
        double currentDev = this.calculateDeviation(this.smallerHalf.size(), this.largerHalf.size());
        if (currentDev > 0.0 && package$.MODULE$.abs(newDev = this.calculateDeviation(this.smallerHalf.size() - 1, this.largerHalf.size() + 1)) < currentDev) {
            this.largerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)this.smallerHalf.dequeue())}));
        }
        if (currentDev < 0.0) {
            double newDev2 = this.calculateDeviation(this.smallerHalf.size() + 1, this.largerHalf.size() - 1);
            if (package$.MODULE$.abs(newDev2) < -currentDev) {
                this.smallerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)this.largerHalf.dequeue())}));
                return;
            }
            return;
        }
    }

    public double percentile() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("PercentileHeap is empty.");
        }
        double dev = this.calculateDeviation(this.smallerHalf.size(), this.largerHalf.size());
        if (this.smallerHalf.nonEmpty() && this.largerHalf.nonEmpty() && package$.MODULE$.abs(dev / (double)this.size()) < 0.01) {
            return (BoxesRunTime.unboxToDouble((Object)this.largerHalf.head()) + BoxesRunTime.unboxToDouble((Object)this.smallerHalf.head())) / 2.0;
        }
        if (dev < 0.0) {
            return BoxesRunTime.unboxToDouble((Object)this.largerHalf.head());
        }
        return BoxesRunTime.unboxToDouble((Object)this.smallerHalf.head());
    }

    public PercentileHeap(double percentage, Ordering<Object> ord) {
        this.percentage = percentage;
        this.ord = ord;
        Predef$.MODULE$.assert(percentage >= 0.0 && percentage <= 1.0);
        this.smallerHalf = (PriorityQueue)PriorityQueue$.MODULE$.empty(ord);
        this.largerHalf = (PriorityQueue)PriorityQueue$.MODULE$.empty(ord.reverse());
    }
}

