/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.replication;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.replication.proto.Replication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintReplicationRecords
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PrintReplicationRecords.class);
    private Connector conn;
    private PrintStream out;
    private SimpleDateFormat sdf;

    public PrintReplicationRecords(Connector conn, PrintStream out) {
        this.conn = conn;
        this.out = out;
        this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    }

    @Override
    public void run() {
        Scanner s;
        this.out.println(this.sdf.format(new Date()) + " Replication entries from metadata table");
        this.out.println("------------------------------------------------------------------");
        try {
            s = this.conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        }
        catch (TableNotFoundException e) {
            log.error("Metadata table does not exist");
            return;
        }
        s.setRange(MetadataSchema.ReplicationSection.getRange());
        s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        for (Map.Entry entry : s) {
            try {
                this.out.println(((Key)entry.getKey()).toStringNoTruncate() + "=" + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom(((Value)entry.getValue()).get())));
            }
            catch (InvalidProtocolBufferException e) {
                this.out.println(((Key)entry.getKey()).toStringNoTruncate() + "= Could not deserialize Status message");
            }
        }
        this.out.println();
        this.out.println(this.sdf.format(new Date()) + " Replication entries from replication table");
        this.out.println("--------------------------------------------------------------------");
        try {
            s = this.conn.createScanner("accumulo.replication", Authorizations.EMPTY);
        }
        catch (TableNotFoundException e) {
            log.error("Replication table does not exist");
            return;
        }
        for (Map.Entry entry : s) {
            try {
                this.out.println(((Key)entry.getKey()).toStringNoTruncate() + "=" + ProtobufUtil.toString((GeneratedMessage)Replication.Status.parseFrom(((Value)entry.getValue()).get())));
            }
            catch (InvalidProtocolBufferException e) {
                this.out.println(((Key)entry.getKey()).toStringNoTruncate() + "= Could not deserialize Status message");
            }
        }
    }
}

