/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;

public class WriterImpl
extends org.apache.orc.impl.WriterImpl
implements Writer {
    private final ObjectInspector inspector;
    private final VectorizedRowBatch internalBatch;
    private final StructField[] fields;

    WriterImpl(FileSystem fs, Path path, OrcFile.WriterOptions opts) throws IOException {
        super(fs, path, (OrcFile.WriterOptions)opts);
        this.inspector = opts.getInspector();
        boolean useDecimal64ColumnVectors = opts.getConfiguration() != null && HiveConf.getVar((Configuration)opts.getConfiguration(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
        this.internalBatch = useDecimal64ColumnVectors ? opts.getSchema().createRowBatch(TypeDescription.RowBatchVersion.USE_DECIMAL64, opts.getBatchSize()) : opts.getSchema().createRowBatch(opts.getBatchSize());
        this.fields = WriterImpl.initializeFieldsFromOi(this.inspector);
    }

    private static StructField[] initializeFieldsFromOi(ObjectInspector inspector) {
        if (inspector instanceof StructObjectInspector) {
            List fieldList = ((StructObjectInspector)inspector).getAllStructFieldRefs();
            StructField[] fields = new StructField[fieldList.size()];
            fieldList.toArray(fields);
            return fields;
        }
        return null;
    }

    static void setColumn(int rowId, ColumnVector column, ObjectInspector inspector, Object obj) {
        if (obj == null) {
            column.noNulls = false;
            column.isNull[rowId] = true;
        } else {
            switch (inspector.getCategory()) {
                case PRIMITIVE: {
                    switch (((PrimitiveObjectInspector)inspector).getPrimitiveCategory()) {
                        case BOOLEAN: {
                            LongColumnVector vector = (LongColumnVector)column;
                            vector.vector[rowId] = ((BooleanObjectInspector)inspector).get(obj) ? 1L : 0L;
                            break;
                        }
                        case BYTE: {
                            LongColumnVector vector = (LongColumnVector)column;
                            vector.vector[rowId] = ((ByteObjectInspector)inspector).get(obj);
                            break;
                        }
                        case SHORT: {
                            LongColumnVector vector = (LongColumnVector)column;
                            vector.vector[rowId] = ((ShortObjectInspector)inspector).get(obj);
                            break;
                        }
                        case INT: {
                            LongColumnVector vector = (LongColumnVector)column;
                            vector.vector[rowId] = ((IntObjectInspector)inspector).get(obj);
                            break;
                        }
                        case LONG: {
                            LongColumnVector vector = (LongColumnVector)column;
                            vector.vector[rowId] = ((LongObjectInspector)inspector).get(obj);
                            break;
                        }
                        case FLOAT: {
                            DoubleColumnVector vector = (DoubleColumnVector)column;
                            vector.vector[rowId] = ((FloatObjectInspector)inspector).get(obj);
                            break;
                        }
                        case DOUBLE: {
                            DoubleColumnVector vector = (DoubleColumnVector)column;
                            vector.vector[rowId] = ((DoubleObjectInspector)inspector).get(obj);
                            break;
                        }
                        case BINARY: {
                            BytesColumnVector vector = (BytesColumnVector)column;
                            BytesWritable blob = ((BinaryObjectInspector)inspector).getPrimitiveWritableObject(obj);
                            vector.setVal(rowId, blob.getBytes(), 0, blob.getLength());
                            break;
                        }
                        case STRING: {
                            BytesColumnVector vector = (BytesColumnVector)column;
                            Text blob = ((StringObjectInspector)inspector).getPrimitiveWritableObject(obj);
                            vector.setVal(rowId, blob.getBytes(), 0, blob.getLength());
                            break;
                        }
                        case VARCHAR: {
                            BytesColumnVector vector = (BytesColumnVector)column;
                            Text blob = ((HiveVarcharObjectInspector)inspector).getPrimitiveWritableObject(obj).getTextValue();
                            vector.setVal(rowId, blob.getBytes(), 0, blob.getLength());
                            break;
                        }
                        case CHAR: {
                            BytesColumnVector vector = (BytesColumnVector)column;
                            Text blob = ((HiveCharObjectInspector)inspector).getPrimitiveWritableObject(obj).getTextValue();
                            vector.setVal(rowId, blob.getBytes(), 0, blob.getLength());
                            break;
                        }
                        case TIMESTAMP: {
                            TimestampColumnVector vector = (TimestampColumnVector)column;
                            vector.setIsUTC(true);
                            vector.set(rowId, ((TimestampObjectInspector)inspector).getPrimitiveJavaObject(obj).toSqlTimestamp());
                            break;
                        }
                        case DATE: {
                            LongColumnVector vector = (LongColumnVector)column;
                            vector.vector[rowId] = ((DateObjectInspector)inspector).getPrimitiveWritableObject(obj).getDays();
                            break;
                        }
                        case DECIMAL: {
                            if (column instanceof Decimal64ColumnVector) {
                                Decimal64ColumnVector vector = (Decimal64ColumnVector)column;
                                vector.set(rowId, ((HiveDecimalObjectInspector)inspector).getPrimitiveWritableObject(obj));
                                break;
                            }
                            DecimalColumnVector vector = (DecimalColumnVector)column;
                            vector.set(rowId, ((HiveDecimalObjectInspector)inspector).getPrimitiveWritableObject(obj));
                        }
                    }
                    break;
                }
                case STRUCT: {
                    StructColumnVector vector = (StructColumnVector)column;
                    StructObjectInspector oi = (StructObjectInspector)inspector;
                    List fields = oi.getAllStructFieldRefs();
                    for (int c = 0; c < vector.fields.length; ++c) {
                        StructField field = (StructField)fields.get(c);
                        WriterImpl.setColumn(rowId, vector.fields[c], field.getFieldObjectInspector(), oi.getStructFieldData(obj, field));
                    }
                    break;
                }
                case UNION: {
                    UnionColumnVector vector = (UnionColumnVector)column;
                    UnionObjectInspector oi = (UnionObjectInspector)inspector;
                    byte tag = oi.getTag(obj);
                    vector.tags[rowId] = tag;
                    WriterImpl.setColumn(rowId, vector.fields[tag], (ObjectInspector)oi.getObjectInspectors().get(tag), oi.getField(obj));
                    break;
                }
                case LIST: {
                    ListColumnVector vector = (ListColumnVector)column;
                    ListObjectInspector oi = (ListObjectInspector)inspector;
                    int offset = vector.childCount;
                    int length = oi.getListLength(obj);
                    vector.offsets[rowId] = offset;
                    vector.lengths[rowId] = length;
                    vector.child.ensureSize(offset + length, true);
                    vector.childCount += length;
                    for (int c = 0; c < length; ++c) {
                        WriterImpl.setColumn(offset + c, vector.child, oi.getListElementObjectInspector(), oi.getListElement(obj, c));
                    }
                    break;
                }
                case MAP: {
                    MapColumnVector vector = (MapColumnVector)column;
                    MapObjectInspector oi = (MapObjectInspector)inspector;
                    int offset = vector.childCount;
                    Set map = oi.getMap(obj).entrySet();
                    int length = map.size();
                    vector.offsets[rowId] = offset;
                    vector.lengths[rowId] = length;
                    vector.keys.ensureSize(offset + length, true);
                    vector.values.ensureSize(offset + length, true);
                    vector.childCount += length;
                    Iterator iterator = map.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry item;
                        Map.Entry pair = item = iterator.next();
                        WriterImpl.setColumn(offset, vector.keys, oi.getMapKeyObjectInspector(), pair.getKey());
                        WriterImpl.setColumn(offset, vector.values, oi.getMapValueObjectInspector(), pair.getValue());
                        ++offset;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ObjectInspector kind " + inspector.getCategory());
                }
            }
        }
    }

    void flushInternalBatch() throws IOException {
        if (this.internalBatch.size != 0) {
            super.addRowBatch(this.internalBatch);
            this.internalBatch.reset();
        }
    }

    @Override
    public void addRow(Object row) throws IOException {
        int rowId = this.internalBatch.size++;
        if (this.fields != null) {
            StructObjectInspector soi = (StructObjectInspector)this.inspector;
            for (int i = 0; i < this.fields.length; ++i) {
                WriterImpl.setColumn(rowId, this.internalBatch.cols[i], this.fields[i].getFieldObjectInspector(), soi.getStructFieldData(row, this.fields[i]));
            }
        } else {
            WriterImpl.setColumn(rowId, this.internalBatch.cols[0], this.inspector, row);
        }
        if (this.internalBatch.size == this.internalBatch.getMaxSize()) {
            this.flushInternalBatch();
        }
    }

    public long writeIntermediateFooter() throws IOException {
        this.flushInternalBatch();
        return super.writeIntermediateFooter();
    }

    public void addRowBatch(VectorizedRowBatch batch) throws IOException {
        this.flushInternalBatch();
        super.addRowBatch(batch);
    }

    public void close() throws IOException {
        this.flushInternalBatch();
        super.close();
    }
}

