/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.ql.io.parquet.vector.ParquetDataColumnReader;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetDataColumnReaderFactory {
    private ParquetDataColumnReaderFactory() {
    }

    private static ParquetDataColumnReader getDataColumnReaderByTypeHelper(boolean isDictionary, PrimitiveType parquetType, TypeInfo hiveType, Dictionary dictionary, ValuesReader valuesReader, boolean skipTimestampConversion, ZoneId writerTimezone) throws IOException {
        int length = ParquetDataColumnReaderFactory.getVarcharLength(hiveType);
        String typeName = TypeInfoUtils.getBaseName((String)hiveType.getTypeName());
        switch (parquetType.getPrimitiveTypeName()) {
            case INT32: {
                if (OriginalType.UINT_8 == parquetType.getOriginalType() || OriginalType.UINT_16 == parquetType.getOriginalType() || OriginalType.UINT_32 == parquetType.getOriginalType() || OriginalType.UINT_64 == parquetType.getOriginalType()) {
                    switch (typeName) {
                        case "smallint": {
                            return isDictionary ? new Types32UInt2SmallintPageReader(dictionary, length) : new Types32UInt2SmallintPageReader(valuesReader, length);
                        }
                        case "tinyint": {
                            return isDictionary ? new Types32UInt2TinyintPageReader(dictionary, length) : new Types32UInt2TinyintPageReader(valuesReader, length);
                        }
                        case "decimal": {
                            return isDictionary ? new Types32UInt2DecimalPageReader(dictionary, length, ((DecimalTypeInfo)hiveType).getPrecision(), ((DecimalTypeInfo)hiveType).getScale()) : new Types32UInt2DecimalPageReader(valuesReader, length, ((DecimalTypeInfo)hiveType).getPrecision(), ((DecimalTypeInfo)hiveType).getScale());
                        }
                    }
                    return isDictionary ? new TypesFromUInt32PageReader(dictionary, length) : new TypesFromUInt32PageReader(valuesReader, length);
                }
                switch (typeName) {
                    case "smallint": {
                        return isDictionary ? new Types32Int2SmallintPageReader(dictionary, length) : new Types32Int2SmallintPageReader(valuesReader, length);
                    }
                    case "tinyint": {
                        return isDictionary ? new Types32Int2TinyintPageReader(dictionary, length) : new Types32Int2TinyintPageReader(valuesReader, length);
                    }
                    case "decimal": {
                        return isDictionary ? new Types32Int2DecimalPageReader(dictionary, length, ((DecimalTypeInfo)hiveType).getPrecision(), ((DecimalTypeInfo)hiveType).getScale()) : new Types32Int2DecimalPageReader(valuesReader, length, ((DecimalTypeInfo)hiveType).getPrecision(), ((DecimalTypeInfo)hiveType).getScale());
                    }
                }
                return isDictionary ? new TypesFromInt32PageReader(dictionary, length) : new TypesFromInt32PageReader(valuesReader, length);
            }
            case INT64: {
                if (OriginalType.UINT_8 == parquetType.getOriginalType() || OriginalType.UINT_16 == parquetType.getOriginalType() || OriginalType.UINT_32 == parquetType.getOriginalType() || OriginalType.UINT_64 == parquetType.getOriginalType()) {
                    switch (typeName) {
                        case "int": {
                            return isDictionary ? new Types64UInt2IntPageReader(dictionary, length) : new Types64UInt2IntPageReader(valuesReader, length);
                        }
                        case "smallint": {
                            return isDictionary ? new Types64UInt2SmallintPageReader(dictionary, length) : new Types64UInt2SmallintPageReader(valuesReader, length);
                        }
                        case "tinyint": {
                            return isDictionary ? new Types64UInt2TinyintPageReader(dictionary, length) : new Types64UInt2TinyintPageReader(valuesReader, length);
                        }
                        case "decimal": {
                            return isDictionary ? new Types64UInt2DecimalPageReader(dictionary, length, ((DecimalTypeInfo)hiveType).getPrecision(), ((DecimalTypeInfo)hiveType).getScale()) : new Types64UInt2DecimalPageReader(valuesReader, length, ((DecimalTypeInfo)hiveType).getPrecision(), ((DecimalTypeInfo)hiveType).getScale());
                        }
                    }
                    return isDictionary ? new TypesFromUInt64PageReader(dictionary, length) : new TypesFromUInt64PageReader(valuesReader, length);
                }
                switch (typeName) {
                    case "int": {
                        return isDictionary ? new Types64Int2IntPageReader(dictionary, length) : new Types64Int2IntPageReader(valuesReader, length);
                    }
                    case "smallint": {
                        return isDictionary ? new Types64Int2SmallintPageReader(dictionary, length) : new Types64Int2SmallintPageReader(valuesReader, length);
                    }
                    case "tinyint": {
                        return isDictionary ? new Types64Int2TinyintPageReader(dictionary, length) : new Types64Int2TinyintPageReader(valuesReader, length);
                    }
                    case "decimal": {
                        return isDictionary ? new Types64Int2DecimalPageReader(dictionary, length, ((DecimalTypeInfo)hiveType).getPrecision(), ((DecimalTypeInfo)hiveType).getScale()) : new Types64Int2DecimalPageReader(valuesReader, length, ((DecimalTypeInfo)hiveType).getPrecision(), ((DecimalTypeInfo)hiveType).getScale());
                    }
                }
                return isDictionary ? new TypesFromInt64PageReader(dictionary, length) : new TypesFromInt64PageReader(valuesReader, length);
            }
            case FLOAT: {
                return isDictionary ? new TypesFromFloatPageReader(dictionary, length) : new TypesFromFloatPageReader(valuesReader, length);
            }
            case INT96: {
                return isDictionary ? new TypesFromInt96PageReader(dictionary, length, skipTimestampConversion, writerTimezone) : new TypesFromInt96PageReader(valuesReader, length, skipTimestampConversion, writerTimezone);
            }
            case BOOLEAN: {
                return isDictionary ? new TypesFromBooleanPageReader(dictionary, length) : new TypesFromBooleanPageReader(valuesReader, length);
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                return ParquetDataColumnReaderFactory.getConvertorFromBinary(isDictionary, parquetType, hiveType, valuesReader, dictionary);
            }
            case DOUBLE: {
                return isDictionary ? new TypesFromDoublePageReader(dictionary, length) : new TypesFromDoublePageReader(valuesReader, length);
            }
        }
        return isDictionary ? new DefaultParquetDataColumnReader(dictionary, length) : new DefaultParquetDataColumnReader(valuesReader, length);
    }

    private static ParquetDataColumnReader getConvertorFromBinary(boolean isDict, PrimitiveType parquetType, TypeInfo hiveType, ValuesReader valuesReader, Dictionary dictionary) {
        OriginalType originalType = parquetType.getOriginalType();
        int length = ParquetDataColumnReaderFactory.getVarcharLength(hiveType);
        if (originalType == null) {
            return isDict ? new DefaultParquetDataColumnReader(dictionary, length) : new DefaultParquetDataColumnReader(valuesReader, length);
        }
        switch (originalType) {
            case DECIMAL: {
                short scale = (short)parquetType.asPrimitiveType().getDecimalMetadata().getScale();
                return isDict ? new TypesFromDecimalPageReader(dictionary, length, scale) : new TypesFromDecimalPageReader(valuesReader, length, scale);
            }
            case UTF8: {
                return isDict ? new TypesFromStringPageReader(dictionary, length) : new TypesFromStringPageReader(valuesReader, length);
            }
        }
        return isDict ? new DefaultParquetDataColumnReader(dictionary, length) : new DefaultParquetDataColumnReader(valuesReader, length);
    }

    public static ParquetDataColumnReader getDataColumnReaderByTypeOnDictionary(PrimitiveType parquetType, TypeInfo hiveType, Dictionary realReader, boolean skipTimestampConversion, ZoneId writerTimezone) throws IOException {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(true, parquetType, hiveType, realReader, null, skipTimestampConversion, writerTimezone);
    }

    public static ParquetDataColumnReader getDataColumnReaderByType(PrimitiveType parquetType, TypeInfo hiveType, ValuesReader realReader, boolean skipTimestampConversion, ZoneId writerTimezone) throws IOException {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(false, parquetType, hiveType, null, realReader, skipTimestampConversion, writerTimezone);
    }

    private static int getVarcharLength(TypeInfo hiveType) {
        int length = -1;
        if (hiveType instanceof PrimitiveTypeInfo) {
            PrimitiveTypeInfo hivePrimitiveType = (PrimitiveTypeInfo)hiveType;
            switch (hivePrimitiveType.getPrimitiveCategory()) {
                case CHAR: {
                    length = ((CharTypeInfo)hivePrimitiveType).getLength();
                    break;
                }
                case VARCHAR: {
                    length = ((VarcharTypeInfo)hivePrimitiveType).getLength();
                    break;
                }
            }
        }
        return length;
    }

    public static class TypesFromStringPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromStringPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromStringPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public byte[] readVarchar() {
            byte[] value = this.valuesReader.readBytes().getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            byte[] value = this.dict.decodeToBinary(id).getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readChar() {
            byte[] value = this.valuesReader.readBytes().getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        @Override
        public byte[] readChar(int id) {
            byte[] value = this.dict.decodeToBinary(id).getBytesUnsafe();
            return this.truncateIfNecesssary(value);
        }

        private byte[] truncateIfNecesssary(byte[] bytes) {
            if (this.length <= 0 || bytes == null) {
                return bytes;
            }
            int len = bytes.length;
            int truncatedLength = StringExpr.truncate((byte[])bytes, (int)0, (int)len, (int)this.length);
            if (truncatedLength >= len) {
                return bytes;
            }
            return Arrays.copyOf(bytes, truncatedLength);
        }
    }

    public static class TypesFromDecimalPageReader
    extends DefaultParquetDataColumnReader {
        private HiveDecimalWritable tempDecimal = new HiveDecimalWritable();
        private short scale;

        public TypesFromDecimalPageReader(ValuesReader realReader, int length, short scale) {
            super(realReader, length);
            this.scale = scale;
        }

        public TypesFromDecimalPageReader(Dictionary dict, int length, short scale) {
            super(dict, length);
            this.scale = scale;
        }

        @Override
        public byte[] readString() {
            return this.convertToBytes(this.valuesReader.readBytes());
        }

        @Override
        public byte[] readString(int id) {
            return this.convertToBytes(this.dict.decodeToBinary(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readBytes()));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToBinary(id)));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(this.convertToString(this.valuesReader.readBytes()));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(this.convertToString(this.dict.decodeToBinary(id)));
            return TypesFromDecimalPageReader.convertToBytes(value);
        }

        private String convertToString(Binary value) {
            this.tempDecimal.set(value.getBytesUnsafe(), (int)this.scale);
            return this.tempDecimal.toString();
        }

        private byte[] convertToBytes(Binary value) {
            return TypesFromDecimalPageReader.convertToBytes(this.convertToString(value));
        }
    }

    public static class TypesFromInt96PageReader
    extends DefaultParquetDataColumnReader {
        private boolean skipTimestampConversion = false;
        private ZoneId writerTimezone;

        public TypesFromInt96PageReader(ValuesReader realReader, int length, boolean skipTimestampConversion, ZoneId writerTimezone) {
            super(realReader, length);
            this.skipTimestampConversion = skipTimestampConversion;
            this.writerTimezone = writerTimezone;
        }

        public TypesFromInt96PageReader(Dictionary dict, int length, boolean skipTimestampConversion, ZoneId writerTimezone) {
            super(dict, length);
            this.skipTimestampConversion = skipTimestampConversion;
            this.writerTimezone = writerTimezone;
        }

        private Timestamp convert(Binary binary) {
            ByteBuffer buf = binary.toByteBuffer();
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = buf.getLong();
            int julianDay = buf.getInt();
            NanoTime nt = new NanoTime(julianDay, timeOfDayNanos);
            return NanoTimeUtils.getTimestamp(nt, this.skipTimestampConversion, this.writerTimezone);
        }

        @Override
        public Timestamp readTimestamp(int id) {
            return this.convert(this.dict.decodeToBinary(id));
        }

        @Override
        public Timestamp readTimestamp() {
            return this.convert(this.valuesReader.readBytes());
        }

        @Override
        public byte[] readString() {
            return TypesFromInt96PageReader.convertToBytes(this.readTimestamp());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt96PageReader.convertToBytes(this.readTimestamp(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp()));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp(id)));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp()));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt96PageReader.convertToString(this.readTimestamp(id)));
            return TypesFromInt96PageReader.convertToBytes(value);
        }

        private static String convertToString(Timestamp value) {
            return value.toString();
        }

        private static byte[] convertToBytes(Timestamp value) {
            return TypesFromInt96PageReader.convertToBytes(TypesFromInt96PageReader.convertToString(value));
        }
    }

    public static class TypesFromBooleanPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromBooleanPageReader(ValuesReader valuesReader, int length) {
            super(valuesReader, length);
        }

        public TypesFromBooleanPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public byte[] readString() {
            return TypesFromBooleanPageReader.convertToBytes(this.valuesReader.readBoolean());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromBooleanPageReader.convertToBytes(this.dict.decodeToBoolean(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.valuesReader.readBoolean()));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.dict.decodeToBoolean(id)));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.valuesReader.readBoolean()));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromBooleanPageReader.convertToString(this.dict.decodeToBoolean(id)));
            return TypesFromBooleanPageReader.convertToBytes(value);
        }

        private static String convertToString(boolean value) {
            return Boolean.toString(value);
        }

        private static byte[] convertToBytes(boolean value) {
            return TypesFromBooleanPageReader.convertToBytes(TypesFromBooleanPageReader.convertToString(value));
        }
    }

    public static class TypesFromDoublePageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromDoublePageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromDoublePageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public byte[] readString() {
            return TypesFromDoublePageReader.convertToBytes(this.valuesReader.readDouble());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromDoublePageReader.convertToBytes(this.dict.decodeToDouble(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.valuesReader.readDouble()));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.dict.decodeToDouble(id)));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.valuesReader.readDouble()));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromDoublePageReader.convertToString(this.dict.decodeToDouble(id)));
            return TypesFromDoublePageReader.convertToBytes(value);
        }

        private static String convertToString(double value) {
            return Double.toString(value);
        }

        private static byte[] convertToBytes(double value) {
            return TypesFromDoublePageReader.convertToBytes(TypesFromDoublePageReader.convertToString(value));
        }
    }

    public static class TypesFromFloatPageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromFloatPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromFloatPageReader(Dictionary realReader, int length) {
            super(realReader, length);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readFloat();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public byte[] readString() {
            return TypesFromFloatPageReader.convertToBytes(this.valuesReader.readFloat());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromFloatPageReader.convertToBytes(this.dict.decodeToFloat(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.valuesReader.readFloat()));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.dict.decodeToFloat(id)));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.valuesReader.readFloat()));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromFloatPageReader.convertToString(this.dict.decodeToFloat(id)));
            return TypesFromFloatPageReader.convertToBytes(value);
        }

        private static String convertToString(float value) {
            return Float.toString(value);
        }

        private static byte[] convertToBytes(float value) {
            return TypesFromFloatPageReader.convertToBytes(TypesFromFloatPageReader.convertToString(value));
        }
    }

    public static class Types32UInt2DecimalPageReader
    extends TypesFromInt32PageReader {
        private int precision = 0;
        private int scale = 0;
        private final HiveDecimalWritable hiveDecimalWritable = new HiveDecimalWritable(0L);

        public Types32UInt2DecimalPageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length);
            this.precision = precision;
            this.scale = scale;
        }

        public Types32UInt2DecimalPageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public boolean isValid(long value) {
            this.hiveDecimalWritable.setFromLong(value);
            this.hiveDecimalWritable.mutateEnforcePrecisionScale(this.precision, this.scale);
            return value >= 0L && this.hiveDecimalWritable.isSet();
        }
    }

    public static class Types32UInt2TinyintPageReader
    extends TypesFromInt32PageReader {
        public Types32UInt2TinyintPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types32UInt2TinyintPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= 127L && value >= 0L;
        }
    }

    public static class Types32UInt2SmallintPageReader
    extends TypesFromInt32PageReader {
        public Types32UInt2SmallintPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types32UInt2SmallintPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= 32767L && value >= 0L;
        }
    }

    public static class TypesFromUInt32PageReader
    extends TypesFromInt32PageReader {
        public TypesFromUInt32PageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromUInt32PageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value >= 0L;
        }

        @Override
        public boolean isValid(float value) {
            return value >= 0.0f;
        }

        @Override
        public boolean isValid(double value) {
            return value >= 0.0;
        }
    }

    public static class Types32Int2DecimalPageReader
    extends TypesFromInt32PageReader {
        private int precision = 0;
        private int scale = 0;
        private final HiveDecimalWritable hiveDecimalWritable = new HiveDecimalWritable(0L);

        public Types32Int2DecimalPageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length);
            this.precision = precision;
            this.scale = scale;
        }

        public Types32Int2DecimalPageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public boolean isValid(long value) {
            this.hiveDecimalWritable.setFromLong(value);
            this.hiveDecimalWritable.mutateEnforcePrecisionScale(this.precision, this.scale);
            return this.hiveDecimalWritable.isSet();
        }
    }

    public static class Types32Int2TinyintPageReader
    extends TypesFromInt32PageReader {
        public Types32Int2TinyintPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types32Int2TinyintPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= 127L && value >= -128L;
        }
    }

    public static class Types32Int2SmallintPageReader
    extends TypesFromInt32PageReader {
        public Types32Int2SmallintPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types32Int2SmallintPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= 32767L && value >= -32768L;
        }
    }

    public static class Types64UInt2DecimalPageReader
    extends TypesFromInt64PageReader {
        private int precision = 0;
        private int scale = 0;
        private final HiveDecimalWritable hiveDecimalWritable = new HiveDecimalWritable(0L);

        public Types64UInt2DecimalPageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length);
            this.precision = precision;
            this.scale = scale;
        }

        public Types64UInt2DecimalPageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public boolean isValid(long value) {
            this.hiveDecimalWritable.setFromLong(value);
            this.hiveDecimalWritable.mutateEnforcePrecisionScale(this.precision, this.scale);
            return value >= 0L && this.hiveDecimalWritable.isSet();
        }
    }

    public static class Types64UInt2TinyintPageReader
    extends TypesFromInt64PageReader {
        public Types64UInt2TinyintPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types64UInt2TinyintPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= 127L && value >= 0L;
        }
    }

    public static class Types64UInt2SmallintPageReader
    extends TypesFromInt64PageReader {
        public Types64UInt2SmallintPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types64UInt2SmallintPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= 32767L && value >= 0L;
        }
    }

    public static class Types64UInt2IntPageReader
    extends TypesFromInt64PageReader {
        public Types64UInt2IntPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types64UInt2IntPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= Integer.MAX_VALUE && value >= 0L;
        }
    }

    public static class TypesFromUInt64PageReader
    extends TypesFromInt64PageReader {
        public TypesFromUInt64PageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromUInt64PageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value >= 0L;
        }

        @Override
        public boolean isValid(float value) {
            return value >= 0.0f;
        }

        @Override
        public boolean isValid(double value) {
            return value >= 0.0;
        }
    }

    public static class Types64Int2DecimalPageReader
    extends TypesFromInt64PageReader {
        private int precision = 0;
        private int scale = 0;
        private final HiveDecimalWritable hiveDecimalWritable = new HiveDecimalWritable(0L);

        public Types64Int2DecimalPageReader(ValuesReader realReader, int length, int precision, int scale) {
            super(realReader, length);
            this.precision = precision;
            this.scale = scale;
        }

        public Types64Int2DecimalPageReader(Dictionary dict, int length, int precision, int scale) {
            super(dict, length);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public boolean isValid(long value) {
            this.hiveDecimalWritable.setFromLong(value);
            this.hiveDecimalWritable.mutateEnforcePrecisionScale(this.precision, this.scale);
            return this.hiveDecimalWritable.isSet();
        }
    }

    public static class Types64Int2TinyintPageReader
    extends TypesFromInt64PageReader {
        public Types64Int2TinyintPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types64Int2TinyintPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= 127L && value >= -128L;
        }
    }

    public static class Types64Int2SmallintPageReader
    extends TypesFromInt64PageReader {
        public Types64Int2SmallintPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types64Int2SmallintPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= 32767L && value >= -32768L;
        }
    }

    public static class Types64Int2IntPageReader
    extends TypesFromInt64PageReader {
        public Types64Int2IntPageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public Types64Int2IntPageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public boolean isValid(long value) {
            return value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE;
        }
    }

    public static class TypesFromInt64PageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromInt64PageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromInt64PageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public long readInteger() {
            return this.valuesReader.readLong();
        }

        @Override
        public long readInteger(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readLong();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readLong();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public byte[] readString() {
            return TypesFromInt64PageReader.convertToBytes(this.valuesReader.readLong());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt64PageReader.convertToBytes(this.dict.decodeToLong(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.valuesReader.readLong()));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.dict.decodeToLong(id)));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.valuesReader.readLong()));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt64PageReader.convertToString(this.dict.decodeToLong(id)));
            return TypesFromInt64PageReader.convertToBytes(value);
        }

        private static String convertToString(long value) {
            return Long.toString(value);
        }

        private static byte[] convertToBytes(long value) {
            return TypesFromInt64PageReader.convertToBytes(TypesFromInt64PageReader.convertToString(value));
        }
    }

    public static class TypesFromInt32PageReader
    extends DefaultParquetDataColumnReader {
        public TypesFromInt32PageReader(ValuesReader realReader, int length) {
            super(realReader, length);
        }

        public TypesFromInt32PageReader(Dictionary dict, int length) {
            super(dict, length);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readInteger();
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readInteger();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readInteger();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public byte[] readString() {
            return TypesFromInt32PageReader.convertToBytes(this.valuesReader.readInteger());
        }

        @Override
        public byte[] readString(int id) {
            return TypesFromInt32PageReader.convertToBytes(this.dict.decodeToInt(id));
        }

        @Override
        public byte[] readVarchar() {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.valuesReader.readInteger()));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readVarchar(int id) {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.dict.decodeToInt(id)));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar() {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.valuesReader.readInteger()));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        @Override
        public byte[] readChar(int id) {
            String value = this.enforceMaxLength(TypesFromInt32PageReader.convertToString(this.dict.decodeToInt(id)));
            return TypesFromInt32PageReader.convertToBytes(value);
        }

        private static String convertToString(int value) {
            return Integer.toString(value);
        }

        private static byte[] convertToBytes(int value) {
            return TypesFromInt32PageReader.convertToBytes(TypesFromInt32PageReader.convertToString(value));
        }
    }

    public static class DefaultParquetDataColumnReader
    implements ParquetDataColumnReader {
        protected ValuesReader valuesReader;
        protected Dictionary dict;
        protected int length = -1;

        public DefaultParquetDataColumnReader(ValuesReader valuesReader, int length) {
            this.valuesReader = valuesReader;
            this.length = length;
        }

        public DefaultParquetDataColumnReader(Dictionary dict, int length) {
            this.dict = dict;
            this.length = length;
        }

        @Override
        public void initFromPage(int i, ByteBufferInputStream in) throws IOException {
            this.valuesReader.initFromPage(i, in);
        }

        @Override
        public boolean readBoolean() {
            return this.valuesReader.readBoolean();
        }

        @Override
        public boolean readBoolean(int id) {
            return this.dict.decodeToBoolean(id);
        }

        @Override
        public byte[] readString(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readString() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readVarchar() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readVarchar(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readChar() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readChar(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readBytes() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readBytes(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readDecimal() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readDecimal(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readFloat();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readDouble();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToDouble(id);
        }

        @Override
        public Timestamp readTimestamp() {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public Timestamp readTimestamp(int id) {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public long readInteger() {
            return this.valuesReader.readInteger();
        }

        @Override
        public long readInteger(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public boolean isValid(long value) {
            return true;
        }

        @Override
        public boolean isValid(float value) {
            return true;
        }

        @Override
        public boolean isValid(double value) {
            return true;
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readLong();
        }

        @Override
        public int readValueDictionaryId() {
            return this.valuesReader.readValueDictionaryId();
        }

        public void skip() {
            this.valuesReader.skip();
        }

        @Override
        public Dictionary getDictionary() {
            return this.dict;
        }

        protected String enforceMaxLength(String value) {
            return HiveBaseChar.enforceMaxLength((String)value, (int)this.length);
        }

        protected String getPaddedString(String value) {
            return HiveBaseChar.getPaddedValue((String)value, (int)this.length);
        }

        protected static byte[] convertToBytes(String value) {
            try {
                return value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to encode string in UTF-8", e);
            }
        }
    }
}

