/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.impl.InactiveServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapClusterStateForCompile {
    protected static final Logger LOG = LoggerFactory.getLogger(LlapClusterStateForCompile.class);
    private static final long CLUSTER_UPDATE_INTERVAL_MS = 120000L;
    private volatile Long lastClusterUpdateNs;
    private volatile Integer noConfigNodeCount;
    private volatile Integer executorCount;
    private volatile int numExecutorsPerNode = -1;
    private LlapRegistryService svc;
    private final Configuration conf;
    private final long updateIntervalNs;
    private final Object updateInfoLock = new Object();
    private static final Cache<String, LlapClusterStateForCompile> CACHE = CacheBuilder.newBuilder().initialCapacity(10).maximumSize(100L).build();

    public static LlapClusterStateForCompile getClusterInfo(final Configuration conf) {
        final String nodes = HiveConf.getTrimmedVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
        final String userName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZK_REGISTRY_USER, (String)LlapRegistryService.currentUser());
        Callable<LlapClusterStateForCompile> generator = new Callable<LlapClusterStateForCompile>(){

            @Override
            public LlapClusterStateForCompile call() throws Exception {
                LOG.info("Creating cluster info for " + userName + ":" + nodes);
                return new LlapClusterStateForCompile(conf, 120000L);
            }
        };
        try {
            return (LlapClusterStateForCompile)CACHE.get((Object)(userName + ":" + nodes), (Callable)generator);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public LlapClusterStateForCompile(Configuration conf, long updateIntervalMs) {
        this.conf = conf;
        this.updateIntervalNs = updateIntervalMs * 1000000L;
    }

    public boolean hasClusterInfo() {
        return this.lastClusterUpdateNs != null;
    }

    public int getKnownExecutorCount() {
        return this.executorCount;
    }

    public int getNodeCountWithUnknownExecutors() {
        return this.noConfigNodeCount;
    }

    public int getNumExecutorsPerNode() {
        return this.numExecutorsPerNode;
    }

    private boolean isUpdateNeeded() {
        Long lastUpdateLocal = this.lastClusterUpdateNs;
        if (lastUpdateLocal == null) {
            return true;
        }
        long elapsed = System.nanoTime() - lastUpdateLocal;
        return elapsed >= this.updateIntervalNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initClusterInfo() {
        if (!this.isUpdateNeeded()) {
            return true;
        }
        Object object = this.updateInfoLock;
        synchronized (object) {
            LlapServiceInstanceSet instances;
            if (!this.isUpdateNeeded()) {
                return true;
            }
            if (this.svc == null) {
                try {
                    this.svc = LlapRegistryService.getClient((Configuration)this.conf);
                }
                catch (Throwable t) {
                    LOG.info("Cannot create the client; ignoring", t);
                    return false;
                }
            }
            try {
                instances = this.svc.getInstances(10L);
            }
            catch (IOException e) {
                LOG.info("Cannot update cluster information; ignoring", (Throwable)e);
                return false;
            }
            int executorsLocal = 0;
            int noConfigNodesLocal = 0;
            for (LlapServiceInstance si : instances.getAll()) {
                if (si instanceof InactiveServiceInstance) continue;
                Map props = si.getProperties();
                if (props == null) {
                    ++noConfigNodesLocal;
                    continue;
                }
                try {
                    int numExecutors = Integer.parseInt((String)props.get(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname));
                    executorsLocal += numExecutors;
                    if (this.numExecutorsPerNode != -1) continue;
                    this.numExecutorsPerNode = numExecutors;
                }
                catch (NumberFormatException e) {
                    ++noConfigNodesLocal;
                }
            }
            this.noConfigNodeCount = noConfigNodesLocal;
            this.executorCount = executorsLocal;
            this.lastClusterUpdateNs = System.nanoTime();
            return true;
        }
    }
}

