/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.PathBuilder;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class FunctionSerializer
implements JsonWriter.Serializer {
    public static final String FIELD_NAME = "function";
    private Function function;
    private HiveConf hiveConf;

    public FunctionSerializer(Function function, HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.function = function;
    }

    @Override
    public void writeTo(JsonWriter writer, ReplicationSpec additionalPropertiesProvider) throws SemanticException, IOException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        ArrayList<ResourceUri> resourceUris = new ArrayList<ResourceUri>();
        for (ResourceUri uri : this.function.getResourceUris()) {
            Path inputPath = new Path(uri.getUri());
            if ("hdfs".equals(inputPath.toUri().getScheme())) {
                FileSystem fileSystem = inputPath.getFileSystem((Configuration)this.hiveConf);
                Path qualifiedUri = PathBuilder.fullyQualifiedHDFSUri(inputPath, fileSystem);
                String checkSum = ReplChangeManager.checksumFor((Path)qualifiedUri, (FileSystem)fileSystem);
                String newFileUri = ReplChangeManager.encodeFileUri((String)qualifiedUri.toString(), (String)checkSum, null);
                resourceUris.add(new ResourceUri(uri.getResourceType(), newFileUri));
                continue;
            }
            resourceUris.add(uri);
        }
        Function copyObj = new Function(this.function);
        if (!resourceUris.isEmpty()) {
            assert (resourceUris.size() == this.function.getResourceUris().size());
            copyObj.setResourceUris(resourceUris);
        }
        try {
            writer.jsonGenerator.writeStringField(ReplicationSpec.KEY.REPL_SCOPE.toString(), "all");
            writer.jsonGenerator.writeStringField(ReplicationSpec.KEY.CURR_STATE_ID.toString(), additionalPropertiesProvider.getCurrentReplicationState());
            writer.jsonGenerator.writeStringField(FIELD_NAME, serializer.toString((TBase)copyObj, "UTF-8"));
        }
        catch (TException e) {
            throw new SemanticException(ErrorMsg.ERROR_SERIALIZE_METASTORE.getMsg(), e);
        }
    }
}

