/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.datastorage;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.pig.backend.datastorage.ContainerDescriptor;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.datastorage.DataStorageException;
import org.apache.pig.backend.datastorage.ElementDescriptor;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.datastorage.HDirectory;
import org.apache.pig.backend.hadoop.datastorage.HFile;
import org.apache.pig.backend.hadoop.datastorage.HPath;

public class HDataStorage
implements DataStorage {
    private static final HPath[] EMPTY_HPATH = new HPath[0];
    private FileSystem fs;
    private Configuration configuration;
    private Properties properties;
    private URI uri;

    public HDataStorage(URI uri, Properties properties) {
        this.properties = properties;
        this.uri = uri;
        this.init();
    }

    public HDataStorage(Properties properties) {
        this.properties = properties;
        this.init();
    }

    @Override
    public void init() {
        this.configuration = ConfigurationUtil.toConfiguration(this.properties);
        try {
            this.fs = this.uri != null ? FileSystem.get((URI)this.uri, (Configuration)this.configuration) : FileSystem.get((Configuration)this.configuration);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create DataStorage", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    @Override
    public Properties getConfiguration() {
        return this.properties;
    }

    @Override
    public void updateConfiguration(Properties newConfiguration) throws DataStorageException {
        if (newConfiguration == null) {
            return;
        }
        Enumeration<Object> newKeys = newConfiguration.keys();
        while (newKeys.hasMoreElements()) {
            String key = (String)newKeys.nextElement();
            String value = null;
            value = newConfiguration.getProperty(key);
            this.fs.getConf().set(key, value);
        }
    }

    @Override
    public Map<String, Object> getStatistics() throws IOException {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        long usedBytes = this.fs.getUsed();
        stats.put("pig.used.bytes", Long.valueOf(usedBytes).toString());
        if (this.fs instanceof DistributedFileSystem) {
            DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
            long rawCapacityBytes = dfs.getStatus().getCapacity();
            stats.put("pig.raw.capacity.bytes", Long.valueOf(rawCapacityBytes).toString());
            long rawUsedBytes = dfs.getStatus().getUsed();
            stats.put("pig.raw.used.capacity.bytes", Long.valueOf(rawUsedBytes).toString());
        }
        return stats;
    }

    @Override
    public ElementDescriptor asElement(String name) throws DataStorageException {
        return this.isContainer(name) ? new HDirectory(this, name) : new HFile(this, name);
    }

    @Override
    public ElementDescriptor asElement(ElementDescriptor element) throws DataStorageException {
        return this.asElement(element.toString());
    }

    @Override
    public ElementDescriptor asElement(String parent, String child) throws DataStorageException {
        return this.asElement(new Path(parent, child).toString());
    }

    @Override
    public ElementDescriptor asElement(ContainerDescriptor parent, String child) throws DataStorageException {
        return this.asElement(parent.toString(), child);
    }

    @Override
    public ElementDescriptor asElement(ContainerDescriptor parent, ElementDescriptor child) throws DataStorageException {
        return this.asElement(parent.toString(), child.toString());
    }

    @Override
    public ContainerDescriptor asContainer(String name) throws DataStorageException {
        return new HDirectory(this, name);
    }

    @Override
    public ContainerDescriptor asContainer(ContainerDescriptor container) throws DataStorageException {
        return new HDirectory(this, container.toString());
    }

    @Override
    public ContainerDescriptor asContainer(String parent, String child) throws DataStorageException {
        return new HDirectory(this, parent, child);
    }

    @Override
    public ContainerDescriptor asContainer(ContainerDescriptor parent, String child) throws DataStorageException {
        return new HDirectory(this, parent.toString(), child);
    }

    @Override
    public ContainerDescriptor asContainer(ContainerDescriptor parent, ContainerDescriptor child) throws DataStorageException {
        return new HDirectory(this, parent.toString(), child.toString());
    }

    @Override
    public void setActiveContainer(ContainerDescriptor container) {
        this.fs.setWorkingDirectory(new Path(container.toString()));
    }

    @Override
    public ContainerDescriptor getActiveContainer() {
        return new HDirectory(this, this.fs.getWorkingDirectory());
    }

    @Override
    public boolean isContainer(String name) throws DataStorageException {
        boolean isContainer = false;
        Path path = new Path(name);
        try {
            if (this.fs.exists(path) && !this.fs.isFile(path)) {
                isContainer = true;
            }
        }
        catch (IOException e) {
            int errCode = 6007;
            String msg = "Unable to check name " + name;
            throw new DataStorageException(msg, errCode, 16, e);
        }
        return isContainer;
    }

    public HPath[] asCollection(String pattern) throws DataStorageException {
        try {
            FileStatus[] paths = this.fs.globStatus(new Path(pattern));
            if (paths == null) {
                return EMPTY_HPATH;
            }
            ArrayList<HPath> hpaths = new ArrayList<HPath>();
            for (int i = 0; i < paths.length; ++i) {
                HPath hpath = (HPath)this.asElement(paths[i].getPath().toString());
                if (hpath.systemElement()) continue;
                hpaths.add(hpath);
            }
            return hpaths.toArray(new HPath[0]);
        }
        catch (IOException e) {
            int errCode = 6008;
            String msg = "Failed to obtain glob for " + pattern;
            throw new DataStorageException(msg, errCode, 16, e);
        }
    }

    public FileSystem getHFS() {
        return this.fs;
    }
}

