/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.CellCounter;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestCellCounter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellCounter.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytesBinary((String)"\\x01row1");
    private static final byte[] ROW2 = Bytes.toBytesBinary((String)"\\x01row2");
    private static final String FAMILY_A_STRING = "a";
    private static final String FAMILY_B_STRING = "b";
    private static final byte[] FAMILY_A = Bytes.toBytes((String)"a");
    private static final byte[] FAMILY_B = Bytes.toBytes((String)"b");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static Path FQ_OUTPUT_DIR;
    private static final String OUTPUT_DIR;
    private static long now;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        FQ_OUTPUT_DIR = new Path(OUTPUT_DIR).makeQualified((FileSystem)new LocalFileSystem());
        FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellCounter() throws Exception {
        TableName sourceTable = TableName.valueOf((String)this.name.getMethodName());
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        try (Table t = UTIL.createTable(sourceTable, (byte[][])families);){
            Put p = new Put(ROW1);
            p.addColumn(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.addColumn(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable.getNameAsString(), FQ_OUTPUT_DIR.toString(), ";", "^row1"};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t1"));
            Assert.assertTrue((boolean)data.contains("b;q\t1"));
            Assert.assertTrue((boolean)data.contains("a;q\t1"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
        }
        finally {
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellCounterPrefix() throws Exception {
        TableName sourceTable = TableName.valueOf((String)this.name.getMethodName());
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        try (Table t = UTIL.createTable(sourceTable, (byte[][])families);){
            Put p = new Put(ROW1);
            p.addColumn(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.addColumn(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable.getNameAsString(), FQ_OUTPUT_DIR.toString(), ";", "\\x01row1"};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t1"));
            Assert.assertTrue((boolean)data.contains("b;q\t1"));
            Assert.assertTrue((boolean)data.contains("a;q\t1"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
        }
        finally {
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellCounterStartTimeRange() throws Exception {
        TableName sourceTable = TableName.valueOf((String)this.name.getMethodName());
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        try (Table t = UTIL.createTable(sourceTable, (byte[][])families);){
            Put p = new Put(ROW1);
            p.addColumn(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.addColumn(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable.getNameAsString(), FQ_OUTPUT_DIR.toString(), ";", "^row1", "--starttime=" + now, "--endtime=" + now + 2};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t1"));
            Assert.assertTrue((boolean)data.contains("b;q\t1"));
            Assert.assertTrue((boolean)data.contains("a;q\t1"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
        }
        finally {
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellCounteEndTimeRange() throws Exception {
        TableName sourceTable = TableName.valueOf((String)this.name.getMethodName());
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        try (Table t = UTIL.createTable(sourceTable, (byte[][])families);){
            Put p = new Put(ROW1);
            p.addColumn(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.addColumn(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable.getNameAsString(), FQ_OUTPUT_DIR.toString(), ";", "^row1", "--endtime=" + now + 1};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t1"));
            Assert.assertTrue((boolean)data.contains("b;q\t1"));
            Assert.assertTrue((boolean)data.contains("a;q\t1"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
        }
        finally {
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellCounteOutOfTimeRange() throws Exception {
        TableName sourceTable = TableName.valueOf((String)this.name.getMethodName());
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        try (Table t = UTIL.createTable(sourceTable, (byte[][])families);){
            Put p = new Put(ROW1);
            p.addColumn(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.addColumn(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable.getNameAsString(), FQ_OUTPUT_DIR.toString(), ";", "--starttime=" + now + 1, "--endtime=" + now + 2};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(OUTPUT_DIR + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.isEmpty());
        }
        finally {
            FileUtil.fullyDelete((File)new File(OUTPUT_DIR));
        }
    }

    private boolean runCount(String[] args) throws Exception {
        int status = ToolRunner.run((Configuration)new Configuration(UTIL.getConfiguration()), (Tool)new CellCounter(), (String[])args);
        return status == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellCounterMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                CellCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("ERROR: Wrong number of parameters:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage:"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellCounterForCompleteTable() throws Exception {
        TableName sourceTable = TableName.valueOf((String)this.name.getMethodName());
        String outputPath = OUTPUT_DIR + sourceTable;
        LocalFileSystem localFileSystem = new LocalFileSystem();
        Path outputDir = new Path(outputPath).makeQualified(localFileSystem.getUri(), localFileSystem.getWorkingDirectory());
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        Table t = UTIL.createTable(sourceTable, (byte[][])families);
        try {
            Put p = new Put(ROW1);
            p.addColumn(FAMILY_A, QUALIFIER, now, Bytes.toBytes((String)"Data11"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data12"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data13"));
            t.put(p);
            p = new Put(ROW2);
            p.addColumn(FAMILY_B, QUALIFIER, now, Bytes.toBytes((String)"Dat21"));
            p.addColumn(FAMILY_A, QUALIFIER, now + 1L, Bytes.toBytes((String)"Data22"));
            p.addColumn(FAMILY_B, QUALIFIER, now + 2L, Bytes.toBytes((String)"Data23"));
            t.put(p);
            String[] args = new String[]{sourceTable.getNameAsString(), outputDir.toString(), ";"};
            this.runCount(args);
            FileInputStream inputStream = new FileInputStream(outputPath + File.separator + "part-r-00000");
            String data = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertTrue((boolean)data.contains("Total Families Across all Rows\t2"));
            Assert.assertTrue((boolean)data.contains("Total Qualifiers across all Rows\t4"));
            Assert.assertTrue((boolean)data.contains("Total ROWS\t2"));
            Assert.assertTrue((boolean)data.contains("b;q\t2"));
            Assert.assertTrue((boolean)data.contains("a;q\t2"));
            Assert.assertTrue((boolean)data.contains("row1;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row1;b;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row2;a;q_Versions\t1"));
            Assert.assertTrue((boolean)data.contains("row2;b;q_Versions\t1"));
            FileUtil.fullyDelete((File)new File(outputPath));
            args = new String[]{"-D hbase.mapreduce.scan.column.family=a, b", sourceTable.getNameAsString(), outputDir.toString(), ";"};
            this.runCount(args);
            inputStream = new FileInputStream(outputPath + File.separator + "part-r-00000");
            String data2 = IOUtils.toString((InputStream)inputStream);
            inputStream.close();
            Assert.assertEquals((Object)data, (Object)data2);
        }
        finally {
            t.close();
            localFileSystem.close();
            FileUtil.fullyDelete((File)new File(outputPath));
        }
    }

    @Test
    public void TestCellCounterWithoutOutputDir() throws Exception {
        String[] args = new String[]{"tableName"};
        Assert.assertEquals((String)"CellCounter should exit with -1 as output directory is not specified.", (long)-1L, (long)ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new CellCounter(), (String[])args));
    }

    static {
        OUTPUT_DIR = "target" + File.separator + "test-data" + File.separator + "output";
        now = System.currentTimeMillis();
    }
}

