/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.RowCounter;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestRowCounter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowCounter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRowCounter.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TABLE_NAME = "testRowCounter";
    private static final String TABLE_NAME_TS_RANGE = "testRowCounter_ts_range";
    private static final String COL_FAM = "col_fam";
    private static final String COL1 = "c1";
    private static final String COL2 = "c2";
    private static final String COMPOSITE_COLUMN = "C:A:A";
    private static final int TOTAL_ROWS = 10;
    private static final int ROWS_WITH_ONE_COL = 2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)TABLE_NAME), Bytes.toBytes((String)COL_FAM));
        TestRowCounter.writeRows(table, 10, 2);
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRowCounterNoColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME};
        this.runRowCount(args, 10);
    }

    @Test
    public void testRowCounterExclusiveColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:c1"};
        this.runRowCount(args, 8);
    }

    @Test
    public void testRowCounterColumnWithColonInQualifier() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:C:A:A"};
        this.runRowCount(args, 8);
    }

    @Test
    public void testRowCounterHiddenColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:c2"};
        this.runRowCount(args, 10);
    }

    @Test
    public void testRowCounterColumnAndRowRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00rov,\\x00rox", "col_fam:c1"};
        this.runRowCount(args, 8);
    }

    @Test
    public void testRowCounterRowSingleRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3"};
        this.runRowCount(args, 2);
    }

    @Test
    public void testRowCounterRowSingleRangeUpperBound() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=,\\x00row3"};
        this.runRowCount(args, 3);
    }

    @Test
    public void testRowCounterRowMultiRangeUpperBound() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=,\\x00row3;\\x00row5,\\x00row7"};
        this.runRowCount(args, 5);
    }

    @Test
    public void testRowCounterRowMultiRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3;\\x00row5,\\x00row8"};
        this.runRowCount(args, 5);
    }

    @Test
    public void testRowCounterRowMultiEmptyRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3;;"};
        this.runRowCount(args, 2);
    }

    @Test
    public void testRowCounter10kRowRange() throws Exception {
        String tableName = "testRowCounter10k";
        try (Table table = TEST_UTIL.createTable(TableName.valueOf((String)tableName), Bytes.toBytes((String)COL_FAM));){
            TestRowCounter.writeRows(table, 10000, 0);
        }
        String[] args = new String[]{tableName, "--range=\\x00row9872,\\x00row9875"};
        this.runRowCount(args, 3);
    }

    @Test
    public void testRowCounterTimeRange() throws Exception {
        byte[] family = Bytes.toBytes((String)COL_FAM);
        byte[] col1 = Bytes.toBytes((String)COL1);
        Put put1 = new Put(Bytes.toBytes((String)"row_timerange_1"));
        Put put2 = new Put(Bytes.toBytes((String)"row_timerange_2"));
        Put put3 = new Put(Bytes.toBytes((String)"row_timerange_3"));
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)TABLE_NAME_TS_RANGE), Bytes.toBytes((String)COL_FAM));
        long ts = System.currentTimeMillis();
        put1.addColumn(family, col1, ts, Bytes.toBytes((String)"val1"));
        table.put(put1);
        Thread.sleep(100L);
        ts = System.currentTimeMillis();
        put2.addColumn(family, col1, ts, Bytes.toBytes((String)"val2"));
        put3.addColumn(family, col1, ts, Bytes.toBytes((String)"val3"));
        table.put(put2);
        table.put(put3);
        table.close();
        String[] args = new String[]{TABLE_NAME_TS_RANGE, "col_fam:c1", "--starttime=0", "--endtime=" + ts};
        this.runRowCount(args, 1);
        args = new String[]{TABLE_NAME_TS_RANGE, "col_fam:c1", "--starttime=0", "--endtime=" + (ts - 10L)};
        this.runRowCount(args, 1);
        args = new String[]{TABLE_NAME_TS_RANGE, "col_fam:c1", "--starttime=" + ts, "--endtime=" + (ts + 1000L)};
        this.runRowCount(args, 2);
        args = new String[]{TABLE_NAME_TS_RANGE, "col_fam:c1", "--starttime=" + (ts - 30000L), "--endtime=" + (ts + 30000L)};
        this.runRowCount(args, 3);
    }

    private void runRowCount(String[] args, int expectedCount) throws Exception {
        RowCounter rowCounter = new RowCounter();
        rowCounter.setConf(TEST_UTIL.getConfiguration());
        args = Arrays.copyOf(args, args.length + 1);
        args[args.length - 1] = "--expectedCount=" + expectedCount;
        long start = System.currentTimeMillis();
        int result = rowCounter.run(args);
        long duration = System.currentTimeMillis() - start;
        LOG.debug("row count duration (ms): " + duration);
        Assert.assertTrue((result == 0 ? 1 : 0) != 0);
    }

    private void runCreateSubmittableJobWithArgs(String[] args, int expectedCount) throws Exception {
        Job job = RowCounter.createSubmittableJob((Configuration)TEST_UTIL.getConfiguration(), (String[])args);
        long start = System.currentTimeMillis();
        job.waitForCompletion(true);
        long duration = System.currentTimeMillis() - start;
        LOG.debug("row count duration (ms): " + duration);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counter counter = job.getCounters().findCounter((Enum)RowCounter.RowCounterMapper.Counters.ROWS);
        Assert.assertEquals((long)expectedCount, (long)counter.getValue());
    }

    @Test
    public void testCreateSubmittableJobWithArgsNoColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME};
        this.runCreateSubmittableJobWithArgs(args, 10);
    }

    @Test
    public void testCreateSubmittableJobWithArgsExclusiveColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:c1"};
        this.runCreateSubmittableJobWithArgs(args, 8);
    }

    @Test
    public void testCreateSubmittableJobWithArgsColumnWithColonInQualifier() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:C:A:A"};
        this.runCreateSubmittableJobWithArgs(args, 8);
    }

    @Test
    public void testCreateSubmittableJobWithArgsHiddenColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:c2"};
        this.runCreateSubmittableJobWithArgs(args, 10);
    }

    @Test
    public void testCreateSubmittableJobWithArgsColumnAndRowRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00rov,\\x00rox", "col_fam:c1"};
        this.runCreateSubmittableJobWithArgs(args, 8);
    }

    @Test
    public void testCreateSubmittableJobWithArgsRowSingleRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3"};
        this.runCreateSubmittableJobWithArgs(args, 2);
    }

    @Test
    public void testCreateSubmittableJobWithArgsRowSingleRangeUpperBound() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=,\\x00row3"};
        this.runCreateSubmittableJobWithArgs(args, 3);
    }

    @Test
    public void testCreateSubmittableJobWithArgsRowMultiRangeUpperBound() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=,\\x00row3;\\x00row5,\\x00row7"};
        this.runCreateSubmittableJobWithArgs(args, 5);
    }

    @Test
    public void testCreateSubmittableJobWithArgsRowMultiRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3;\\x00row5,\\x00row8"};
        this.runCreateSubmittableJobWithArgs(args, 5);
    }

    @Test
    public void testCreateSubmittableJobWithArgsRowMultiEmptyRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3;;"};
        this.runCreateSubmittableJobWithArgs(args, 2);
    }

    @Test
    public void testCreateSubmittableJobWithArgs10kRowRange() throws Exception {
        String tableName = "testRowCounterCreateSubmittableJobWithArgs10kRowRange";
        try (Table table = TEST_UTIL.createTable(TableName.valueOf((String)tableName), Bytes.toBytes((String)COL_FAM));){
            TestRowCounter.writeRows(table, 10000, 0);
        }
        String[] args = new String[]{tableName, "--range=\\x00row9872,\\x00row9875"};
        this.runCreateSubmittableJobWithArgs(args, 3);
    }

    @Test
    public void testCreateSubmittableJobWithArgsTimeRange() throws Exception {
        byte[] family = Bytes.toBytes((String)COL_FAM);
        byte[] col1 = Bytes.toBytes((String)COL1);
        Put put1 = new Put(Bytes.toBytes((String)"row_timerange_1"));
        Put put2 = new Put(Bytes.toBytes((String)"row_timerange_2"));
        Put put3 = new Put(Bytes.toBytes((String)"row_timerange_3"));
        String tableName = "testRowCounter_ts_rangeCreateSubmittableJobWithArgs";
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)tableName), Bytes.toBytes((String)COL_FAM));
        long ts = System.currentTimeMillis();
        put1.addColumn(family, col1, ts, Bytes.toBytes((String)"val1"));
        table.put(put1);
        Thread.sleep(100L);
        ts = System.currentTimeMillis();
        put2.addColumn(family, col1, ts, Bytes.toBytes((String)"val2"));
        put3.addColumn(family, col1, ts, Bytes.toBytes((String)"val3"));
        table.put(put2);
        table.put(put3);
        table.close();
        String[] args = new String[]{tableName, "col_fam:c1", "--starttime=0", "--endtime=" + ts};
        this.runCreateSubmittableJobWithArgs(args, 1);
        args = new String[]{tableName, "col_fam:c1", "--starttime=0", "--endtime=" + (ts - 10L)};
        this.runCreateSubmittableJobWithArgs(args, 1);
        args = new String[]{tableName, "col_fam:c1", "--starttime=" + ts, "--endtime=" + (ts + 1000L)};
        this.runCreateSubmittableJobWithArgs(args, 2);
        args = new String[]{tableName, "col_fam:c1", "--starttime=" + (ts - 30000L), "--endtime=" + (ts + 30000L)};
        this.runCreateSubmittableJobWithArgs(args, 3);
    }

    private static void writeRows(Table table, int totalRows, int rowsWithOneCol) throws IOException {
        Put put;
        byte[] row;
        int i;
        byte[] family = Bytes.toBytes((String)COL_FAM);
        byte[] value = Bytes.toBytes((String)"abcd");
        byte[] col1 = Bytes.toBytes((String)COL1);
        byte[] col2 = Bytes.toBytes((String)COL2);
        byte[] col3 = Bytes.toBytes((String)COMPOSITE_COLUMN);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (i = 0; i < totalRows - rowsWithOneCol; ++i) {
            row = Bytes.toBytesBinary((String)("\\x00row" + i));
            put = new Put(row);
            put.addColumn(family, col1, value);
            put.addColumn(family, col2, value);
            put.addColumn(family, col3, value);
            rowsUpdate.add(put);
        }
        while (i < totalRows) {
            row = Bytes.toBytes((String)("row" + i));
            put = new Put(row);
            put.addColumn(family, col2, value);
            rowsUpdate.add(put);
            ++i;
        }
        table.put(rowsUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportMain() throws Exception {
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        String[] args = new String[]{};
        try {
            try {
                RowCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)1L, (long)newSecurityManager.getExitCode());
            }
            try {
                args = new String[]{"table", "--range=1"};
                RowCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)1L, (long)newSecurityManager.getExitCode());
            }
        }
        finally {
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHelp() throws Exception {
        PrintStream oldPrintStream = System.out;
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(data);
            System.setOut(stream);
            String[] args = new String[]{"-h"};
            this.runRowCount(args, 0);
            this.assertUsageContent(data.toString());
            args = new String[]{"--help"};
            this.runRowCount(args, 0);
            this.assertUsageContent(data.toString());
        }
        finally {
            System.setOut(oldPrintStream);
        }
    }

    @Test
    public void testInvalidTable() throws Exception {
        try {
            String[] args = new String[]{"invalid"};
            this.runRowCount(args, 0);
            Assert.fail((String)"RowCounter should had failed with invalid table.");
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)(e instanceof AssertionError));
        }
    }

    private void assertUsageContent(String usage) {
        Assert.assertTrue((boolean)usage.contains("usage: hbase rowcounter <tablename> [options] [<column1> <column2>...]"));
        Assert.assertTrue((boolean)usage.contains("Options:\n"));
        Assert.assertTrue((boolean)usage.contains("--starttime=<arg>       starting time filter to start counting rows from.\n"));
        Assert.assertTrue((boolean)usage.contains("--endtime=<arg>         end time filter limit, to only count rows up to this timestamp.\n"));
        Assert.assertTrue((boolean)usage.contains("--range=<arg>           [startKey],[endKey][;[startKey],[endKey]...]]\n"));
        Assert.assertTrue((boolean)usage.contains("--expectedCount=<arg>   expected number of rows to be count.\n"));
        Assert.assertTrue((boolean)usage.contains("For performance, consider the following configuration properties:\n"));
        Assert.assertTrue((boolean)usage.contains("-Dhbase.client.scanner.caching=100\n"));
        Assert.assertTrue((boolean)usage.contains("-Dmapreduce.map.speculative=false\n"));
    }
}

