/*
 * Decompiled with CFR 0.152.
 */
package sdsu.algorithms.data;

import sdsu.algorithms.data.DiscreteProbability;
import sdsu.algorithms.data.OutOfBoundsException;

public class Bernoulli
extends DiscreteProbability {
    protected double successProbability;

    public Bernoulli(double d) throws OutOfBoundsException {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            throw new OutOfBoundsException("Probablility must be between 0 and 1Your value was: " + d);
        }
        this.successProbability = d;
    }

    public double density(double d) throws OutOfBoundsException {
        int n = (int)Math.round(d);
        if (n == 1) {
            return this.successProbability;
        }
        if (n == 0) {
            return 1.0 - this.successProbability;
        }
        throw new OutOfBoundsException("Bernoulli trails must result 0 and 1");
    }

    protected double inverseDistribution(double d) {
        if (d <= this.successProbability) {
            return 1.0;
        }
        return 0.0;
    }

    public double mean() {
        return this.successProbability;
    }

    public double nextElement() {
        return this.inverseDistribution(this.randomNumber.nextFloat());
    }

    public double variance() {
        return this.successProbability * (1.0 - this.successProbability);
    }
}

