/*
 * Decompiled with CFR 0.152.
 */
package sdsu.html;

import sdsu.html.Formatter;

public class WebPage {
    private String title = "";
    private StringBuffer body = new StringBuffer();
    private String backgroundColor = null;
    private String textColor = null;
    private String backgroundImageURL = null;
    static String versionNumber = "0.8";
    public static final String AQUA = "#00FFFF";
    public static final String BLACK = "#000000";
    public static final String BLUE = "#0000FF";
    public static final String GRAY = "#808080";
    public static final String GREEN = "#008000";
    public static final String OLIVE = "#808000";
    public static final String RED = "#FF0000";
    public static final String TEAL = "#008080";
    public static final String WHITE = "#FFFFFF";

    public WebPage() {
    }

    public WebPage(String string) {
        this.title = new Formatter(string).toString();
    }

    public void append(Object object) {
        this.body.append(object.toString());
    }

    public void appendLineBreak() {
        this.body.append("\n<BR>");
    }

    public void clearPageBody() {
        this.body = new StringBuffer();
    }

    public String getPageBody() {
        return this.body.toString();
    }

    public String getPageEnding() {
        return "\n</BODY>\n</HTML>";
    }

    public String getPageHeader() {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append("<!DOCTYPE HTML SYSTEM \"html.dtd\">");
        stringBuffer.append("\n<!-- Document generated via code written using java library sdsu.html version ");
        stringBuffer.append(versionNumber);
        stringBuffer.append(">");
        stringBuffer.append("\n<HTML>\n<HEAD>\n<TITLE>");
        stringBuffer.append(this.title);
        stringBuffer.append("\n</TITLE>\n</HEAD>");
        stringBuffer.append("\n<BODY");
        if (this.textColor != null) {
            stringBuffer.append(" TEXT=\"");
            stringBuffer.append(this.textColor);
            stringBuffer.append("\"");
        }
        if (this.backgroundColor != null) {
            stringBuffer.append(" BGCOLOR=\"");
            stringBuffer.append(this.backgroundColor);
            stringBuffer.append("\"");
        }
        if (this.backgroundImageURL != null) {
            stringBuffer.append(" BACKGROUND=\"");
            stringBuffer.append(this.backgroundImageURL);
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public void setBackgroundColor(String string) {
        this.backgroundColor = string;
    }

    public void setBackgroundImage(String string) {
        this.backgroundImageURL = string;
    }

    public void setTextColor(String string) {
        this.textColor = string;
    }

    public String toString() {
        return String.valueOf(this.getPageHeader()) + this.getPageBody() + this.getPageEnding();
    }
}

