/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetReadAccessResultListOfResults is the corresponding interface of BACnetReadAccessResultListOfResults
type BACnetReadAccessResultListOfResults interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetListOfReadAccessProperty returns ListOfReadAccessProperty (property field)
	GetListOfReadAccessProperty() []BACnetReadAccessProperty
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetReadAccessResultListOfResults is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetReadAccessResultListOfResults()
	// CreateBuilder creates a BACnetReadAccessResultListOfResultsBuilder
	CreateBACnetReadAccessResultListOfResultsBuilder() BACnetReadAccessResultListOfResultsBuilder
}

// _BACnetReadAccessResultListOfResults is the data-structure of this message
type _BACnetReadAccessResultListOfResults struct {
	OpeningTag               BACnetOpeningTag
	ListOfReadAccessProperty []BACnetReadAccessProperty
	ClosingTag               BACnetClosingTag

	// Arguments.
	TagNumber          uint8
	ObjectTypeArgument BACnetObjectType
}

var _ BACnetReadAccessResultListOfResults = (*_BACnetReadAccessResultListOfResults)(nil)

// NewBACnetReadAccessResultListOfResults factory function for _BACnetReadAccessResultListOfResults
func NewBACnetReadAccessResultListOfResults(openingTag BACnetOpeningTag, listOfReadAccessProperty []BACnetReadAccessProperty, closingTag BACnetClosingTag, tagNumber uint8, objectTypeArgument BACnetObjectType) *_BACnetReadAccessResultListOfResults {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetReadAccessResultListOfResults must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetReadAccessResultListOfResults must not be nil")
	}
	return &_BACnetReadAccessResultListOfResults{OpeningTag: openingTag, ListOfReadAccessProperty: listOfReadAccessProperty, ClosingTag: closingTag, TagNumber: tagNumber, ObjectTypeArgument: objectTypeArgument}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetReadAccessResultListOfResultsBuilder is a builder for BACnetReadAccessResultListOfResults
type BACnetReadAccessResultListOfResultsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, listOfReadAccessProperty []BACnetReadAccessProperty, closingTag BACnetClosingTag) BACnetReadAccessResultListOfResultsBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetReadAccessResultListOfResultsBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetReadAccessResultListOfResultsBuilder
	// WithListOfReadAccessProperty adds ListOfReadAccessProperty (property field)
	WithListOfReadAccessProperty(...BACnetReadAccessProperty) BACnetReadAccessResultListOfResultsBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetReadAccessResultListOfResultsBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetReadAccessResultListOfResultsBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetReadAccessResultListOfResultsBuilder
	// WithArgObjectTypeArgument sets a parser argument
	WithArgObjectTypeArgument(BACnetObjectType) BACnetReadAccessResultListOfResultsBuilder
	// Build builds the BACnetReadAccessResultListOfResults or returns an error if something is wrong
	Build() (BACnetReadAccessResultListOfResults, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetReadAccessResultListOfResults
}

// NewBACnetReadAccessResultListOfResultsBuilder() creates a BACnetReadAccessResultListOfResultsBuilder
func NewBACnetReadAccessResultListOfResultsBuilder() BACnetReadAccessResultListOfResultsBuilder {
	return &_BACnetReadAccessResultListOfResultsBuilder{_BACnetReadAccessResultListOfResults: new(_BACnetReadAccessResultListOfResults)}
}

type _BACnetReadAccessResultListOfResultsBuilder struct {
	*_BACnetReadAccessResultListOfResults

	collectedErr []error
}

var _ (BACnetReadAccessResultListOfResultsBuilder) = (*_BACnetReadAccessResultListOfResultsBuilder)(nil)

func (b *_BACnetReadAccessResultListOfResultsBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, listOfReadAccessProperty []BACnetReadAccessProperty, closingTag BACnetClosingTag) BACnetReadAccessResultListOfResultsBuilder {
	return b.WithOpeningTag(openingTag).WithListOfReadAccessProperty(listOfReadAccessProperty...).WithClosingTag(closingTag)
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetReadAccessResultListOfResultsBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetReadAccessResultListOfResultsBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) WithListOfReadAccessProperty(listOfReadAccessProperty ...BACnetReadAccessProperty) BACnetReadAccessResultListOfResultsBuilder {
	b.ListOfReadAccessProperty = listOfReadAccessProperty
	return b
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetReadAccessResultListOfResultsBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetReadAccessResultListOfResultsBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) WithArgTagNumber(tagNumber uint8) BACnetReadAccessResultListOfResultsBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetReadAccessResultListOfResultsBuilder) WithArgObjectTypeArgument(objectTypeArgument BACnetObjectType) BACnetReadAccessResultListOfResultsBuilder {
	b.ObjectTypeArgument = objectTypeArgument
	return b
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) Build() (BACnetReadAccessResultListOfResults, error) {
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetReadAccessResultListOfResults.deepCopy(), nil
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) MustBuild() BACnetReadAccessResultListOfResults {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetReadAccessResultListOfResultsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetReadAccessResultListOfResultsBuilder().(*_BACnetReadAccessResultListOfResultsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetReadAccessResultListOfResultsBuilder creates a BACnetReadAccessResultListOfResultsBuilder
func (b *_BACnetReadAccessResultListOfResults) CreateBACnetReadAccessResultListOfResultsBuilder() BACnetReadAccessResultListOfResultsBuilder {
	if b == nil {
		return NewBACnetReadAccessResultListOfResultsBuilder()
	}
	return &_BACnetReadAccessResultListOfResultsBuilder{_BACnetReadAccessResultListOfResults: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetReadAccessResultListOfResults) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetReadAccessResultListOfResults) GetListOfReadAccessProperty() []BACnetReadAccessProperty {
	return m.ListOfReadAccessProperty
}

func (m *_BACnetReadAccessResultListOfResults) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetReadAccessResultListOfResults(structType any) BACnetReadAccessResultListOfResults {
	if casted, ok := structType.(BACnetReadAccessResultListOfResults); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetReadAccessResultListOfResults); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetReadAccessResultListOfResults) GetTypeName() string {
	return "BACnetReadAccessResultListOfResults"
}

func (m *_BACnetReadAccessResultListOfResults) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.ListOfReadAccessProperty) > 0 {
		for _, element := range m.ListOfReadAccessProperty {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetReadAccessResultListOfResults) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetReadAccessResultListOfResultsParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType) (BACnetReadAccessResultListOfResults, error) {
	return BACnetReadAccessResultListOfResultsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument)
}

func BACnetReadAccessResultListOfResultsParseWithBufferProducer(tagNumber uint8, objectTypeArgument BACnetObjectType) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReadAccessResultListOfResults, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReadAccessResultListOfResults, error) {
		return BACnetReadAccessResultListOfResultsParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument)
	}
}

func BACnetReadAccessResultListOfResultsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType) (BACnetReadAccessResultListOfResults, error) {
	v, err := (&_BACnetReadAccessResultListOfResults{TagNumber: tagNumber, ObjectTypeArgument: objectTypeArgument}).parse(ctx, readBuffer, tagNumber, objectTypeArgument)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetReadAccessResultListOfResults) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType) (__bACnetReadAccessResultListOfResults BACnetReadAccessResultListOfResults, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetReadAccessResultListOfResults"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetReadAccessResultListOfResults")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	listOfReadAccessProperty, err := ReadTerminatedArrayField[BACnetReadAccessProperty](ctx, "listOfReadAccessProperty", ReadComplex[BACnetReadAccessProperty](BACnetReadAccessPropertyParseWithBufferProducer((BACnetObjectType)(objectTypeArgument)), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfReadAccessProperty' field"))
	}
	m.ListOfReadAccessProperty = listOfReadAccessProperty

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetReadAccessResultListOfResults"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetReadAccessResultListOfResults")
	}

	return m, nil
}

func (m *_BACnetReadAccessResultListOfResults) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetReadAccessResultListOfResults) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetReadAccessResultListOfResults"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetReadAccessResultListOfResults")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "listOfReadAccessProperty", m.GetListOfReadAccessProperty(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfReadAccessProperty' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetReadAccessResultListOfResults"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetReadAccessResultListOfResults")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetReadAccessResultListOfResults) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetReadAccessResultListOfResults) GetObjectTypeArgument() BACnetObjectType {
	return m.ObjectTypeArgument
}

//
////

func (m *_BACnetReadAccessResultListOfResults) IsBACnetReadAccessResultListOfResults() {}

func (m *_BACnetReadAccessResultListOfResults) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetReadAccessResultListOfResults) deepCopy() *_BACnetReadAccessResultListOfResults {
	if m == nil {
		return nil
	}
	_BACnetReadAccessResultListOfResultsCopy := &_BACnetReadAccessResultListOfResults{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetReadAccessProperty, BACnetReadAccessProperty](m.ListOfReadAccessProperty),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
		m.ObjectTypeArgument,
	}
	return _BACnetReadAccessResultListOfResultsCopy
}

func (m *_BACnetReadAccessResultListOfResults) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
