/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.checksum;

import com.scurrilous.circe.IncrementalIntHash;
import com.scurrilous.circe.checksum.IntHash;
import com.scurrilous.circe.crc.StandardCrcProvider;
import com.scurrilous.circe.params.CrcParameters;
import io.netty.buffer.ByteBuf;

public class Java8IntHash
implements IntHash {
    private final IncrementalIntHash hash = new StandardCrcProvider().getIncrementalInt(CrcParameters.CRC32C);

    @Override
    public int calculate(ByteBuf buffer) {
        return this.resume(0, buffer);
    }

    @Override
    public int resume(int current, ByteBuf buffer) {
        return this.resume(current, buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    @Override
    public int calculate(ByteBuf buffer, int offset, int len) {
        return this.resume(0, buffer, offset, len);
    }

    @Override
    public int resume(int current, ByteBuf buffer, int offset, int len) {
        if (buffer.hasArray()) {
            return this.hash.resume(current, buffer.array(), buffer.arrayOffset() + offset, len);
        }
        return this.hash.resume(current, buffer.slice(offset, len).nioBuffer());
    }

    @Override
    public int resume(int current, byte[] buffer, int offset, int len) {
        return this.hash.resume(current, buffer, offset, len);
    }

    @Override
    public boolean acceptsMemoryAddressBuffer() {
        return false;
    }
}

