/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Random;
import org.apache.pulsar.broker.loadbalance.PlacementStrategy;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WRRPlacementStrategy
implements PlacementStrategy {
    private static final Logger log = LoggerFactory.getLogger(WRRPlacementStrategy.class);
    private final Random rand = new Random();

    @Override
    public ResourceUnit findBrokerForPlacement(Multimap<Long, ResourceUnit> finalCandidates) {
        if (finalCandidates.isEmpty()) {
            return null;
        }
        log.debug("Total Final Candidates selected - [{}]", (Object)finalCandidates.size());
        int totalAvailability = 0;
        for (Map.Entry candidateOwner : finalCandidates.entries()) {
            totalAvailability += ((Long)candidateOwner.getKey()).intValue();
        }
        ResourceUnit selectedRU = null;
        if (totalAvailability <= 0) {
            return finalCandidates.get((Object)0L).stream().skip(this.rand.nextInt(finalCandidates.size())).findFirst().orElse(null);
        }
        int weightedSelector = this.rand.nextInt(totalAvailability);
        log.debug("Generated Weighted Selector Number - [{}] ", (Object)weightedSelector);
        long weightRangeSoFar = 0L;
        for (Map.Entry candidateOwner : finalCandidates.entries()) {
            if ((long)weightedSelector >= (weightRangeSoFar += ((Long)candidateOwner.getKey()).longValue())) continue;
            selectedRU = (ResourceUnit)candidateOwner.getValue();
            log.debug(" Weighted Round Robin Selected RU - [{}]", (Object)((ResourceUnit)candidateOwner.getValue()).getResourceId());
            break;
        }
        return selectedRU;
    }
}

