/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.conf;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.bookkeeper.common.conf.ConcurrentConfiguration;
import org.apache.bookkeeper.common.conf.ConfigurationUtil;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.configuration2.sync.Synchronizer;

public abstract class ComponentConfiguration
implements Configuration {
    protected static final String DELIMITER = ".";
    private final String componentPrefix;
    private final CompositeConfiguration underlyingConf;
    private final Configuration conf;

    protected ComponentConfiguration(CompositeConfiguration underlyingConf, String componentPrefix) {
        this.underlyingConf = underlyingConf;
        this.conf = new ConcurrentConfiguration();
        this.componentPrefix = componentPrefix;
        this.loadConf((Configuration)underlyingConf);
    }

    protected String getKeyName(String name) {
        return name;
    }

    public CompositeConfiguration getUnderlyingConf() {
        return this.underlyingConf;
    }

    public void loadConf(URL confURL) throws ConfigurationException {
        PropertiesConfiguration loadedConf = ConfigurationUtil.newConfiguration(conf -> conf.propertiesBuilder(confURL));
        this.loadConf((Configuration)loadedConf);
    }

    protected void loadConf(Configuration loadedConf) {
        loadedConf.getKeys().forEachRemaining(fullKey -> {
            if (fullKey.startsWith(this.componentPrefix)) {
                String componentKey = fullKey.substring(this.componentPrefix.length());
                this.setProperty(componentKey, loadedConf.getProperty(fullKey));
            }
        });
    }

    public void validate() throws ConfigurationException {
    }

    public Configuration subset(String prefix) {
        return this.conf.subset(this.getKeyName(prefix));
    }

    public boolean isEmpty() {
        return this.conf.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.conf.containsKey(this.getKeyName(key));
    }

    public void addProperty(String key, Object value) {
        this.conf.addProperty(this.getKeyName(key), value);
    }

    public void setProperty(String key, Object value) {
        this.conf.setProperty(this.getKeyName(key), value);
    }

    public void clearProperty(String key) {
        this.conf.clearProperty(this.getKeyName(key));
    }

    public void clear() {
        this.conf.clear();
    }

    public Object getProperty(String key) {
        return this.conf.getProperty(this.getKeyName(key));
    }

    public Iterator<String> getKeys(String prefix) {
        return this.conf.getKeys(this.getKeyName(prefix));
    }

    public Iterator<String> getKeys() {
        return this.conf.getKeys();
    }

    public Properties getProperties(String key) {
        return this.conf.getProperties(this.getKeyName(key));
    }

    public boolean getBoolean(String key) {
        return this.conf.getBoolean(this.getKeyName(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.conf.getBoolean(this.getKeyName(key), defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.conf.getBoolean(this.getKeyName(key), defaultValue);
    }

    public byte getByte(String key) {
        return this.conf.getByte(this.getKeyName(key));
    }

    public byte getByte(String key, byte defaultValue) {
        return this.conf.getByte(this.getKeyName(key), defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.conf.getByte(this.getKeyName(key), defaultValue);
    }

    public double getDouble(String key) {
        return this.conf.getDouble(this.getKeyName(key));
    }

    public double getDouble(String key, double defaultValue) {
        return this.conf.getDouble(this.getKeyName(key), defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.conf.getDouble(this.getKeyName(key), defaultValue);
    }

    public float getFloat(String key) {
        return this.conf.getFloat(this.getKeyName(key));
    }

    public float getFloat(String key, float defaultValue) {
        return this.conf.getFloat(this.getKeyName(key), defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.conf.getFloat(this.getKeyName(key), defaultValue);
    }

    public int getInt(String key) {
        return this.conf.getInt(this.getKeyName(key));
    }

    public int getInt(String key, int defaultValue) {
        return this.conf.getInt(this.getKeyName(key), defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.conf.getInt(this.getKeyName(key), defaultValue.intValue());
    }

    public long getLong(String key) {
        return this.conf.getLong(this.getKeyName(key));
    }

    public long getLong(String key, long defaultValue) {
        return this.conf.getLong(this.getKeyName(key), defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.conf.getLong(this.getKeyName(key), defaultValue);
    }

    public short getShort(String key) {
        return this.conf.getShort(this.getKeyName(key));
    }

    public short getShort(String key, short defaultValue) {
        return this.conf.getShort(this.getKeyName(key), defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.conf.getShort(this.getKeyName(key), defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.conf.getBigDecimal(this.getKeyName(key));
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.conf.getBigDecimal(this.getKeyName(key), defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.conf.getBigInteger(this.getKeyName(key));
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.conf.getBigInteger(this.getKeyName(key), defaultValue);
    }

    public String getString(String key) {
        return this.conf.getString(this.getKeyName(key));
    }

    public String getString(String key, String defaultValue) {
        return this.conf.getString(this.getKeyName(key), defaultValue);
    }

    public String[] getStringArray(String key) {
        return this.conf.getStringArray(this.getKeyName(key));
    }

    public List<Object> getList(String key) {
        return this.conf.getList(this.getKeyName(key));
    }

    public List<Object> getList(String key, List<?> defaultValue) {
        return this.conf.getList(this.getKeyName(key), defaultValue);
    }

    public ConfigurationInterpolator getInterpolator() {
        return this.conf.getInterpolator();
    }

    public void installInterpolator(Map<String, ? extends Lookup> prefixLookups, Collection<? extends Lookup> defLookups) {
        this.conf.installInterpolator(prefixLookups, defLookups);
    }

    public void setInterpolator(ConfigurationInterpolator ci) {
        this.conf.setInterpolator(ci);
    }

    public <T> T get(Class<T> cls, String key) {
        return (T)this.conf.get(cls, key);
    }

    public <T> T get(Class<T> cls, String key, T defaultValue) {
        return (T)this.conf.get(cls, key, defaultValue);
    }

    public Object getArray(Class<?> cls, String key) {
        return this.conf.getArray(cls, key);
    }

    @Deprecated
    public Object getArray(Class<?> cls, String key, Object defaultValue) {
        return this.conf.getArray(cls, key, defaultValue);
    }

    public <T> Collection<T> getCollection(Class<T> cls, String key, Collection<T> target) {
        return this.conf.getCollection(cls, key, target);
    }

    public <T> Collection<T> getCollection(Class<T> cls, String key, Collection<T> target, Collection<T> defaultValue) {
        return this.conf.getCollection(cls, key, target, defaultValue);
    }

    public Duration getDuration(String key) {
        return this.conf.getDuration(key);
    }

    public Duration getDuration(String key, Duration defaultValue) {
        return this.conf.getDuration(key, defaultValue);
    }

    public String getEncodedString(String key) {
        return this.conf.getEncodedString(key);
    }

    public String getEncodedString(String key, ConfigurationDecoder decoder) {
        return this.conf.getEncodedString(key, decoder);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumType) {
        return (T)this.conf.getEnum(key, enumType);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumType, T defaultValue) {
        return (T)this.conf.getEnum(key, enumType, defaultValue);
    }

    public Iterator<String> getKeys(String prefix, String delimiter) {
        return this.conf.getKeys(prefix, delimiter);
    }

    public <T> List<T> getList(Class<T> cls, String key) {
        return this.conf.getList(cls, key);
    }

    public <T> List<T> getList(Class<T> cls, String key, List<T> defaultValue) {
        return this.conf.getList(cls, key, defaultValue);
    }

    public ImmutableConfiguration immutableSubset(String prefix) {
        return this.conf.immutableSubset(prefix);
    }

    public int size() {
        return this.conf.size();
    }

    public Synchronizer getSynchronizer() {
        return this.conf.getSynchronizer();
    }

    public void lock(LockMode mode) {
        this.conf.lock(mode);
    }

    public void setSynchronizer(Synchronizer sync) {
        this.conf.setSynchronizer(sync);
    }

    public void unlock(LockMode mode) {
        this.conf.unlock(mode);
    }

    public String asJson() {
        try {
            return JsonUtil.toJson(this.toMap());
        }
        catch (JsonUtil.ParseJsonException e) {
            throw new RuntimeException("Failed to serialize the configuration as json", e);
        }
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Iterator<String> iterator = this.getKeys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object property = this.getProperty(key);
            if (property == null) continue;
            configMap.put(key, property.toString());
        }
        return configMap;
    }
}

