/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.shapes;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShpFileParser;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShpRecord;

public class ShapeFileReader
extends RecordReader<ShapeKey, ShpRecord> {
    ShpFileParser parser = null;
    private ShapeKey recordKey = null;
    private ShpRecord recordContent = null;
    private FSDataInputStream shpInputStream = null;
    private int[] indexes;
    private boolean useIndex = false;
    private int indexId = 0;

    public ShapeFileReader() {
    }

    public ShapeFileReader(int[] indexes) {
        this.indexes = indexes;
        this.useIndex = true;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split;
        Path filePath = fileSplit.getPath();
        FileSystem fileSys = filePath.getFileSystem(context.getConfiguration());
        FSDataInputStream stream = fileSys.open(filePath);
        this.initialize(stream);
    }

    public void initialize(FSDataInputStream stream) throws IOException {
        this.shpInputStream = stream;
        this.parser = new ShpFileParser(stream);
        this.parser.parseShapeFileHead();
    }

    public boolean nextKeyValue() throws IOException {
        if (this.useIndex) {
            long skipBytes;
            if (this.indexId == this.indexes.length) {
                return false;
            }
            long pos = (long)this.indexes[this.indexId] * 2L;
            if (this.shpInputStream.getPos() < pos && this.shpInputStream.skip(skipBytes = pos - this.shpInputStream.getPos()) != skipBytes) {
                throw new IOException("Failed to seek to the right place in .shp file");
            }
            int currentLength = this.indexes[this.indexId + 1] * 2 - 4;
            this.recordKey = new ShapeKey();
            this.recordKey.setIndex(this.parser.parseRecordHeadID());
            this.recordContent = currentLength >= 0 ? this.parser.parseRecordPrimitiveContent(currentLength) : new ShpRecord(new byte[0], ShapeType.NULL.getId());
            this.indexId += 2;
        } else {
            if (this.getProgress() >= 1.0f) {
                return false;
            }
            this.recordKey = new ShapeKey();
            this.recordKey.setIndex(this.parser.parseRecordHeadID());
            this.recordContent = this.parser.parseRecordPrimitiveContent();
        }
        return true;
    }

    public ShapeKey getCurrentKey() {
        return this.recordKey;
    }

    public ShpRecord getCurrentValue() {
        return this.recordContent;
    }

    public float getProgress() {
        return this.parser.getProgress();
    }

    public void close() throws IOException {
        this.shpInputStream.close();
    }
}

