/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.spider;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.sedona.common.enums.GeometryType;
import org.apache.sedona.common.spider.Generator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

abstract class PointBasedGenerator
implements Generator {
    private final Random random;
    private final GeometryType geometryType;
    private final RandomBoxParameter boxParameter;
    private final RandomPolygonParameter polygonParameter;

    public PointBasedGenerator(Random random, PointBasedParameter pointBasedParameter) {
        this.random = random;
        this.geometryType = pointBasedParameter.geometryType;
        this.boxParameter = pointBasedParameter.boxParameter;
        this.polygonParameter = pointBasedParameter.polygonParameter;
    }

    protected int bernoulli(double p) {
        return this.random.nextDouble() < p ? 1 : 0;
    }

    protected double uniform(double a, double b) {
        return (b - a) * this.random.nextDouble() + a;
    }

    protected double normal(double mu, double sigma) {
        return mu + sigma * Math.sqrt(-2.0 * Math.log(this.random.nextDouble())) * Math.sin(Math.PI * 2 * this.random.nextDouble());
    }

    protected int dice(int n) {
        return this.dice(1, n);
    }

    protected int dice(int min2, int max) {
        return this.random.nextInt(max - min2 + 1) + min2;
    }

    protected abstract Coordinate generateCoordinate();

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Geometry next() {
        switch (this.geometryType) {
            case POINT: {
                return this.generatePoint();
            }
            case POLYGON: {
                return this.generatePolygon();
            }
            case RECTANGLE: {
                return this.generateBox();
            }
        }
        throw new UnsupportedOperationException("Unsupported geometry type: " + this.geometryType);
    }

    protected Point generatePoint() {
        Coordinate coordinate = this.generateCoordinate();
        return GEOMETRY_FACTORY.createPoint(coordinate);
    }

    protected Polygon generateBox() {
        Coordinate coordinate = this.generateCoordinate();
        double width = this.uniform(0.0, this.boxParameter.maxWidth);
        double height = this.uniform(0.0, this.boxParameter.maxHeight);
        double lowerLeftX = coordinate.x - width / 2.0;
        double lowerLeftY = coordinate.y - height / 2.0;
        return GEOMETRY_FACTORY.createPolygon(new Coordinate[]{new Coordinate(lowerLeftX, lowerLeftY), new Coordinate(lowerLeftX + width, lowerLeftY), new Coordinate(lowerLeftX + width, lowerLeftY + height), new Coordinate(lowerLeftX, lowerLeftY + height), new Coordinate(lowerLeftX, lowerLeftY)});
    }

    protected Polygon generatePolygon() {
        Coordinate coordinate = this.generateCoordinate();
        int numSegments = this.dice(this.polygonParameter.minSegments, this.polygonParameter.maxSegments);
        double[] angles = new double[numSegments];
        for (int k = 0; k < numSegments; ++k) {
            angles[k] = this.uniform(0.0, Math.PI * 2);
        }
        Arrays.sort(angles);
        Coordinate[] coordinates = new Coordinate[numSegments + 1];
        for (int k = 0; k < numSegments; ++k) {
            double angle = angles[k];
            double distance = this.uniform(0.0, this.polygonParameter.maxSize / 2.0);
            double x = coordinate.x + distance * Math.cos(angle);
            double y = coordinate.y + distance * Math.sin(angle);
            coordinates[k] = new Coordinate(x, y);
        }
        coordinates[numSegments] = new Coordinate(coordinates[0]);
        return GEOMETRY_FACTORY.createPolygon(coordinates);
    }

    public static class PointBasedParameter {
        public final GeometryType geometryType;
        public final RandomBoxParameter boxParameter;
        public final RandomPolygonParameter polygonParameter;

        public PointBasedParameter(GeometryType geometryType, RandomBoxParameter boxParameter, RandomPolygonParameter polygonParameter) {
            this.geometryType = geometryType;
            this.boxParameter = boxParameter;
            this.polygonParameter = polygonParameter;
        }

        public static PointBasedParameter create(Map<String, String> conf) {
            GeometryType geometryType;
            String geomType;
            switch (geomType = conf.getOrDefault("geometryType", "point").toLowerCase(Locale.ROOT)) {
                case "point": {
                    geometryType = GeometryType.POINT;
                    break;
                }
                case "polygon": {
                    geometryType = GeometryType.POLYGON;
                    break;
                }
                case "box": {
                    geometryType = GeometryType.RECTANGLE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported geometry type: " + geomType);
                }
            }
            RandomBoxParameter boxParameter = RandomBoxParameter.create(conf);
            RandomPolygonParameter polygonParameter = RandomPolygonParameter.create(conf);
            return new PointBasedParameter(geometryType, boxParameter, polygonParameter);
        }
    }

    public static class RandomBoxParameter {
        public final double maxWidth;
        public final double maxHeight;

        public RandomBoxParameter(double maxWidth, double maxHeight) {
            if (maxWidth < 0.0) {
                throw new IllegalArgumentException("maxWidth must be non-negative");
            }
            if (maxHeight < 0.0) {
                throw new IllegalArgumentException("maxHeight must be non-negative");
            }
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
        }

        public static RandomBoxParameter create(Map<String, String> conf) {
            double maxWidth = Double.parseDouble(conf.getOrDefault("maxWidth", "0.01"));
            double maxHeight = Double.parseDouble(conf.getOrDefault("maxHeight", "0.01"));
            return new RandomBoxParameter(maxWidth, maxHeight);
        }
    }

    public static class RandomPolygonParameter {
        public final double maxSize;
        public final int minSegments;
        public final int maxSegments;

        public RandomPolygonParameter(double maxSize, int minSegments, int maxSegments) {
            if (maxSize < 0.0) {
                throw new IllegalArgumentException("maxSize must be non-negative");
            }
            if (minSegments < 3) {
                throw new IllegalArgumentException("minSegments must be at least 3");
            }
            if (maxSegments < minSegments) {
                throw new IllegalArgumentException("maxSegments must be at least minSegments");
            }
            this.maxSize = maxSize;
            this.minSegments = minSegments;
            this.maxSegments = maxSegments;
        }

        public static RandomPolygonParameter create(Map<String, String> conf) {
            double maxSize = Double.parseDouble(conf.getOrDefault("maxSize", "0.01"));
            int minSegments = Integer.parseInt(conf.getOrDefault("minSegments", "3"));
            int maxSegments = Integer.parseInt(conf.getOrDefault("maxSegments", "3"));
            return new RandomPolygonParameter(maxSize, minSegments, maxSegments);
        }
    }
}

