/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.twak.utils.Cache;

public class ImageU {
    public static File rootFile = new File(".");
    public static Cache<String, BufferedImage> cacheResource = new Cache<String, BufferedImage>(){

        @Override
        public BufferedImage create(String i) {
            return ImageU.getResourceAsImage(i);
        }
    };
    public static Cache<String, BufferedImage> cache = new Cache<String, BufferedImage>(){

        @Override
        public BufferedImage create(String i) {
            return ImageU.getImage(i);
        }
    };
    public static Cache<String, BufferedImage> timeOutCache = new Cache<String, BufferedImage>(){
        Map<String, Long> lastRead = new HashMap<String, Long>();

        @Override
        public BufferedImage get(String in) {
            if (in == null) {
                return null;
            }
            BufferedImage out = (BufferedImage)this.cache.get(in);
            if (this.lastRead.get(in) == null || this.lastRead.get(in) < new File(in).lastModified()) {
                out = ImageU.getImage(in);
                this.cache.put(in, out);
                this.lastRead.put(in, System.currentTimeMillis());
            }
            return out;
        }

        @Override
        public BufferedImage create(String i) {
            return ImageU.getImage(i);
        }
    };

    public static BufferedImage clone(BufferedImage in) {
        BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), in.getType(), null);
        Graphics g2 = out.getGraphics();
        g2.drawImage(in, 0, 0, null);
        g2.dispose();
        return out;
    }

    public static BufferedImage getFlipH(String name) {
        BufferedImage image = ImageU.getImage(name);
        BufferedImage i2 = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = (Graphics2D)i2.getGraphics();
        g2.drawImage(image, image.getWidth(), 0, -image.getWidth(), image.getHeight(), null);
        return i2;
    }

    public static BufferedImage getImage(String name) {
        try {
            return ImageIO.read(new FileInputStream(new File(name)));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static BufferedImage clip(BufferedImage image, int x, int y, int width, int height) {
        try {
            BufferedImage out = new BufferedImage(width, height, image.getType());
            Graphics g2 = out.getGraphics();
            g2.drawImage(image, -x, -y, null);
            g2.dispose();
            return out;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getResourceAsImage(String image) {
        try {
            return ImageIO.read(ImageU.class.getResourceAsStream(image));
        }
        catch (IOException ex) {
            System.out.println("error loading image" + image);
            ex.printStackTrace();
            return null;
        }
    }
}

