/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.executor.facade;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.kernel.executor.facade.AbstractJobFacade;
import org.apache.shardingsphere.elasticjob.kernel.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.kernel.internal.failover.FailoverService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ExecutionContextService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.kernel.tracing.config.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.tracing.event.JobTracingEventBus;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.spi.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.spi.listener.param.ShardingContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingJobFacade
extends AbstractJobFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingJobFacade.class);
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final ExecutionContextService executionContextService;
    private final ExecutionService executionService;
    private final FailoverService failoverService;
    private final Collection<ElasticJobListener> elasticJobListeners;
    private final JobTracingEventBus jobTracingEventBus;

    public ShardingJobFacade(CoordinatorRegistryCenter regCenter, String jobName, Collection<ElasticJobListener> elasticJobListeners, TracingConfiguration<?> tracingConfig) {
        super(regCenter, jobName, elasticJobListeners, tracingConfig);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionContextService = new ExecutionContextService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.elasticJobListeners = elasticJobListeners.stream().sorted(Comparator.comparingInt(ElasticJobListener::order)).collect(Collectors.toList());
        this.jobTracingEventBus = null == tracingConfig ? new JobTracingEventBus() : new JobTracingEventBus(tracingConfig);
    }

    @Override
    public ShardingContexts getShardingContexts() {
        List<Integer> failoverShardingItems;
        boolean isFailover = this.configService.load(true).isFailover();
        if (isFailover && !(failoverShardingItems = this.failoverService.getLocalFailoverItems()).isEmpty()) {
            return this.executionContextService.getJobShardingContext(failoverShardingItems);
        }
        this.shardingService.shardingIfNecessary();
        List<Integer> shardingItems = this.shardingService.getLocalShardingItems();
        if (isFailover) {
            shardingItems.removeAll(this.failoverService.getLocalTakeOffItems());
        }
        shardingItems.removeAll(this.executionService.getDisabledItems(shardingItems));
        return this.executionContextService.getJobShardingContext(shardingItems);
    }
}

