/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.consul.TtlScheduler;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join(isSingleton=false)
public class ConsulInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulInstanceRegisterRepository.class);
    private ConsulClient consulClient;
    private NewService newService;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Math.max(Runtime.getRuntime().availableProcessors(), 1), ShenyuThreadFactory.create((String)"consul-config-watch", (boolean)true));
    private final List<ScheduledFuture<?>> watchFutures = new ArrayList();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Map<String, Long> consulIndexes = new HashMap<String, Long>();
    private String token;
    private String waitTime;
    private String watchDelay;
    private String tags;
    private String checkTtl;
    private TtlScheduler ttlScheduler;
    private final Map<String, List<InstanceEntity>> watcherInstanceRegisterMap = new HashMap<String, List<InstanceEntity>>();
    private final Set<String> watchSelectKeySet = new HashSet<String>();

    public void init(RegisterConfig config) {
        Properties props = config.getProps();
        this.checkTtl = props.getProperty("checkTtl", "5");
        this.token = props.getProperty("token", "");
        this.waitTime = props.getProperty("waitTime", "30");
        this.watchDelay = props.getProperty("watchDelay", "5");
        this.tags = props.getProperty("tags");
        String serverList = config.getServerLists();
        if (StringUtils.isBlank((CharSequence)serverList)) {
            throw new ShenyuException("shenyu.register.serverLists can not be null.");
        }
        String[] addresses = serverList.split(":");
        if (addresses.length != 2) {
            throw new ShenyuException("shenyu.register.serverLists formatter is not incorrect.");
        }
        this.consulClient = new ConsulClient(addresses[0], Integer.parseInt(addresses[1]));
        this.ttlScheduler = new TtlScheduler(Integer.parseInt(this.checkTtl), this.consulClient);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public void persistInstance(InstanceEntity instance) {
        String instanceNodeName = this.buildInstanceNodeName(instance);
        this.newService = new NewService();
        this.newService.setName(instance.getAppName());
        this.newService.setId(String.join((CharSequence)"-", instance.getAppName(), instanceNodeName));
        this.newService.setAddress(instance.getHost());
        this.newService.setPort(instance.getPort());
        this.newService.setCheck(this.createCheck());
        if (StringUtils.isNotEmpty((CharSequence)this.tags)) {
            this.newService.setTags(new ArrayList<String>(Arrays.asList(this.tags.split(","))));
        }
        this.newService.setMeta(Collections.singletonMap("nodeData", GsonUtils.getInstance().toJson((Object)instance)));
        this.consulClient.agentServiceRegister(this.newService, this.token);
        this.ttlScheduler.add(this.newService.getId());
        LOGGER.info("consul client register success: {}", (Object)this.newService);
    }

    private NewService.Check createCheck() {
        NewService.Check check = new NewService.Check();
        check.setTtl(this.checkTtl + "s");
        return check;
    }

    public void close() {
        if (this.running.compareAndSet(true, false) && !ObjectUtils.isEmpty(this.watchFutures)) {
            this.watchFutures.forEach(watchFuture -> watchFuture.cancel(true));
        }
        if (!ObjectUtils.isEmpty((Object)this.newService)) {
            this.consulClient.agentServiceDeregister(this.newService.getId(), this.token);
            this.ttlScheduler.remove(this.newService.getId());
        }
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    public List<InstanceEntity> selectInstances(String selectKey) {
        if (this.watcherInstanceRegisterMap.containsKey(selectKey)) {
            return this.watcherInstanceRegisterMap.get(selectKey);
        }
        this.watcherStart(selectKey);
        List<InstanceEntity> healthServices = this.getHealthServices(selectKey, "-1");
        this.watcherInstanceRegisterMap.put(selectKey, healthServices);
        return healthServices;
    }

    public void watcherStart(String selectKey) {
        this.running.compareAndSet(false, true);
        if (!this.watchSelectKeySet.add(selectKey)) {
            return;
        }
        this.watchFutures.add(this.executor.scheduleWithFixedDelay(() -> this.watchConfigKeyValues(selectKey), 5L, Integer.parseInt(this.watchDelay), TimeUnit.SECONDS));
    }

    public void watchConfigKeyValues(String selectKey) {
        if (!this.running.get()) {
            return;
        }
        List<InstanceEntity> healthServices = this.getHealthServices(selectKey, this.waitTime);
        if (!ObjectUtils.isEmpty(healthServices)) {
            this.watcherInstanceRegisterMap.put(selectKey, healthServices);
        } else {
            this.watcherInstanceRegisterMap.remove(selectKey);
        }
    }

    public List<InstanceEntity> getHealthServices(String selectKey, String waitTime) {
        Long newIndex = Optional.ofNullable(this.consulIndexes.get(selectKey)).orElse(-1L);
        HealthServicesRequest healthServicesRequest = HealthServicesRequest.newBuilder().setToken(this.token).setPassing(true).setQueryParams(QueryParams.Builder.builder().setWaitTime(Long.parseLong(waitTime)).setIndex(newIndex.longValue()).build()).build();
        Response healthServices = this.consulClient.getHealthServices(selectKey, healthServicesRequest);
        this.consulIndexes.put(selectKey, healthServices.getConsulIndex());
        if (CollectionUtils.isEmpty((Collection)((Collection)healthServices.getValue()))) {
            return Collections.emptyList();
        }
        return ((List)healthServices.getValue()).stream().map(healthService -> InstanceEntity.builder().appName(healthService.getService().getService()).host(healthService.getService().getAddress()).port(healthService.getService().getPort()).build()).collect(Collectors.toList());
    }

    private URI getURI(Map<String, String> metadata, HealthService healthService) {
        int port;
        String scheme = "http";
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            if (!entry.getValue().contains("http") && !entry.getValue().contains("HTTPS")) continue;
            scheme = "https";
            break;
        }
        if ((port = healthService.getService().getPort().intValue()) <= 0) {
            port = "https".equals(scheme) ? 443 : 80;
        }
        String uri = String.format("%s://%s:%s", scheme, healthService.getService().getAddress(), port);
        return URI.create(uri);
    }
}

