/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WindowTinyLFUMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2176631265536166614L;
    private final Cache<K, V> cache;

    public WindowTinyLFUMap(long maximumSize) {
        this.cache = Caffeine.newBuilder().maximumSize(maximumSize).build();
    }

    public WindowTinyLFUMap(int initialCapacity, long maximumSize, Boolean weakKey) {
        this.cache = Boolean.TRUE.equals(weakKey) ? Caffeine.newBuilder().weakKeys().initialCapacity(initialCapacity).maximumSize(maximumSize).build() : Caffeine.newBuilder().initialCapacity(initialCapacity).maximumSize(maximumSize).build();
    }

    public WindowTinyLFUMap(int initialSize, long expireAfterWrite, long maximumSize, Boolean weakKey) {
        this.cache = Boolean.TRUE.equals(weakKey) ? Caffeine.newBuilder().weakKeys().initialCapacity(initialSize).expireAfterWrite(expireAfterWrite, TimeUnit.MILLISECONDS).maximumSize(maximumSize).build() : Caffeine.newBuilder().initialCapacity(initialSize).expireAfterWrite(expireAfterWrite, TimeUnit.MILLISECONDS).maximumSize(maximumSize).build();
    }

    @Override
    public V put(K key, V value) {
        Object v = this.cache.getIfPresent(key);
        this.cache.put(key, value);
        return (V)v;
    }

    @Override
    public V get(Object key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public V remove(Object key) {
        Object value = this.cache.getIfPresent(key);
        this.cache.invalidate(key);
        this.cache.cleanUp();
        return (V)value;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    @Override
    public int size() {
        return this.cache.asMap().entrySet().size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cache.asMap().entrySet();
    }
}

