/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.timer;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.common.timer.TaskEntity;
import org.apache.shenyu.common.timer.TimerTaskList;

public abstract class TimerTask {
    private final long delayMs;
    private TimerTaskList.TimerTaskEntry timerTaskEntry;

    public TimerTask(long delayMs) {
        this(delayMs, TimeUnit.MILLISECONDS);
    }

    public TimerTask(long delay, TimeUnit unit) {
        this.delayMs = unit.toMillis(delay);
    }

    synchronized void setTimerTaskEntry(TimerTaskList.TimerTaskEntry entry) {
        if (Objects.nonNull(this.timerTaskEntry) && this.timerTaskEntry != entry) {
            this.timerTaskEntry.remove();
        }
        this.timerTaskEntry = entry;
    }

    long getDelayMs() {
        return this.delayMs;
    }

    TimerTaskList.TimerTaskEntry getTimerTaskEntry() {
        return this.timerTaskEntry;
    }

    public synchronized void cancel() {
        if (Objects.nonNull(this.timerTaskEntry)) {
            this.timerTaskEntry.remove();
        }
        this.timerTaskEntry = null;
    }

    public abstract void run(TaskEntity var1);
}

