/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.filter;

import com.tencent.polaris.api.config.configuration.ConfigFilterConfig;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Supplier;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.api.plugin.filter.ConfigFileFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ConfigFileFilterChain {
    private final Boolean enable;
    private final Map<String, ConfigFileFilter> pluginChain = new HashMap<String, ConfigFileFilter>();

    public ConfigFileResponse execute(ConfigFile configFile, Function<ConfigFile, ConfigFileResponse> next) {
        if (next == null) {
            throw new PolarisException(ErrorCode.PARAMETER_ERROR, "Exit Function is null");
        }
        if (!this.enable.booleanValue()) {
            return next.apply(configFile);
        }
        for (String plugin : this.pluginChain.keySet()) {
            Function<ConfigFile, ConfigFileResponse> curr = next;
            next = this.pluginChain.get(plugin).doFilter(configFile, curr);
        }
        return next.apply(configFile);
    }

    public ConfigFileFilterChain(Supplier supplier, ConfigFilterConfig config) {
        this.enable = config.isEnable();
        if (!config.isEnable()) {
            return;
        }
        config.getChain().forEach(chain -> this.pluginChain.put((String)chain, (ConfigFileFilter)supplier.getPlugin(PluginTypes.CONFIG_FILTER.getBaseType(), (String)chain)));
    }
}

