/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.pojo;

import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceKey;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class ServiceChangeEvent
implements Serializable {
    private ServiceKey serviceKey;
    private List<Instance> allInstances = Collections.emptyList();
    private List<Instance> addInstances = Collections.emptyList();
    private List<OneInstanceUpdate> updateInstances = Collections.emptyList();
    private List<Instance> deleteInstances = Collections.emptyList();

    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    public List<Instance> getAddInstances() {
        return this.addInstances;
    }

    public List<OneInstanceUpdate> getUpdateInstances() {
        return this.updateInstances;
    }

    public List<Instance> getDeleteInstances() {
        return this.deleteInstances;
    }

    public List<Instance> getAllInstances() {
        return this.allInstances;
    }

    public static ServiceEventBuilder builder() {
        return new ServiceEventBuilder();
    }

    public String toString() {
        return "ServiceChangeEvent{serviceKey=" + this.serviceKey + ", allInstances=" + this.allInstances + ", addInstances=" + this.addInstances + ", updateInstances=" + this.updateInstances + ", deleteInstances=" + this.deleteInstances + '}';
    }

    public static final class ServiceEventBuilder {
        private ServiceKey serviceKey;
        private List<Instance> allInstances = Collections.emptyList();
        private List<Instance> addInstances = Collections.emptyList();
        private List<OneInstanceUpdate> updateInstances = Collections.emptyList();
        private List<Instance> deleteInstances = Collections.emptyList();

        private ServiceEventBuilder() {
        }

        public ServiceEventBuilder serviceKey(ServiceKey serviceKey) {
            this.serviceKey = serviceKey;
            return this;
        }

        public ServiceEventBuilder allInstances(List<Instance> allInstances) {
            this.allInstances = allInstances;
            return this;
        }

        public ServiceEventBuilder addInstances(List<Instance> addInstances) {
            this.addInstances = addInstances;
            return this;
        }

        public ServiceEventBuilder updateInstances(List<OneInstanceUpdate> updateInstances) {
            this.updateInstances = updateInstances;
            return this;
        }

        public ServiceEventBuilder deleteInstances(List<Instance> deleteInstances) {
            this.deleteInstances = deleteInstances;
            return this;
        }

        public ServiceChangeEvent build() {
            ServiceChangeEvent serviceChangeEvent = new ServiceChangeEvent();
            serviceChangeEvent.addInstances = this.addInstances;
            serviceChangeEvent.deleteInstances = this.deleteInstances;
            serviceChangeEvent.serviceKey = this.serviceKey;
            serviceChangeEvent.updateInstances = this.updateInstances;
            serviceChangeEvent.allInstances = this.allInstances;
            return serviceChangeEvent;
        }
    }

    public static class OneInstanceUpdate {
        private Instance before;
        private Instance after;

        public OneInstanceUpdate(Instance before, Instance after) {
            this.before = before;
            this.after = after;
        }

        public Instance getBefore() {
            return this.before;
        }

        public Instance getAfter() {
            return this.after;
        }
    }
}

