/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.registry.memory;

import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import shade.polaris.com.fasterxml.jackson.databind.JsonNode;
import shade.polaris.com.fasterxml.jackson.databind.ObjectMapper;
import shade.polaris.com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import shade.polaris.com.google.protobuf.Message;
import shade.polaris.com.google.protobuf.util.JsonFormat;
import shade.polaris.org.yaml.snakeyaml.Yaml;

public class MessagePersistHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MessagePersistHandler.class);
    private static final String CACHE_SUFFIX = ".yaml";
    private static final Pattern REGEX_PATTERN_SERVICE = Pattern.compile("^svc#.+#.+#.+\\.yaml$");
    private static final String PATTERN_SERVICE = "svc#%s#%s#%s.yaml";
    private final File persistDirFile;
    private final String persistDirPath;
    private final int maxWriteRetry;
    private final int maxReadRetry;
    private final long retryInterval;
    private final JsonFormat.Printer printer = JsonFormat.printer();
    private final JsonFormat.Parser parser = JsonFormat.parser();

    public MessagePersistHandler(String persistDirPath, int maxWriteRetry, int maxReadRetry, long retryInterval) {
        this.maxReadRetry = maxReadRetry;
        this.maxWriteRetry = maxWriteRetry;
        this.retryInterval = retryInterval;
        this.persistDirPath = Utils.translatePath(persistDirPath);
        this.persistDirFile = new File(this.persistDirPath);
    }

    public void init() throws IOException {
        try {
            if (!this.persistDirFile.exists() && !this.persistDirFile.mkdirs()) {
                throw new IOException(String.format("fail to create dir %s", this.persistDirPath));
            }
            if (!Files.isWritable(FileSystems.getDefault().getPath(this.persistDirPath, new String[0]))) {
                throw new IOException(String.format("fail to check permission for dir %s", this.persistDirPath));
            }
        }
        catch (Throwable e) {
            throw new IOException(String.format("fail to check permission for dir %s", this.persistDirPath), e);
        }
    }

    public void deleteService(ServiceEventKey svcEventKey) {
        String fileName = MessagePersistHandler.serviceKeyToFileName(svcEventKey);
        String persistFilePath = this.persistDirPath + File.separator + fileName;
        try {
            Files.deleteIfExists(FileSystems.getDefault().getPath(persistFilePath, new String[0]));
        }
        catch (IOException e) {
            LOG.error("fail to delete cache file {}", (Object)persistFilePath);
        }
        String lockFileName = fileName + ".lock";
        String persistFileLockPath = this.persistDirPath + File.separator + lockFileName;
        try {
            Files.deleteIfExists(FileSystems.getDefault().getPath(persistFileLockPath, new String[0]));
        }
        catch (IOException e) {
            LOG.error("fail to delete cache lock file {}", (Object)persistFileLockPath);
        }
    }

    public void saveService(ServiceEventKey svcEventKey, Message message) {
        int retryTimes;
        LOG.info("start to save service {}", (Object)svcEventKey);
        for (retryTimes = 0; retryTimes <= this.maxWriteRetry; ++retryTimes) {
            Path path = this.doSaveService(svcEventKey, message);
            if (null == path) continue;
            LOG.info("end to save service {} to {}", (Object)svcEventKey, (Object)path);
            return;
        }
        LOG.error("fail to persist service {} after retry {}", (Object)svcEventKey, (Object)retryTimes);
    }

    private static String serviceKeyToFileName(ServiceEventKey svcEventKey) {
        try {
            String encodedNamespace = URLEncoder.encode(svcEventKey.getServiceKey().getNamespace(), "UTF-8");
            String encodedService = URLEncoder.encode(svcEventKey.getServiceKey().getService(), "UTF-8");
            String eventType = URLEncoder.encode(svcEventKey.getEventType().toString().toLowerCase(), "UTF-8");
            return String.format(PATTERN_SERVICE, encodedNamespace, encodedService, eventType);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    private static ServiceEventKey fileNameToServiceKey(String fileName) {
        fileName = fileName.substring(0, fileName.length() - CACHE_SUFFIX.length());
        String[] pieces = fileName.split("#");
        try {
            String namespace = URLDecoder.decode(pieces[1], "UTF-8");
            String service = URLDecoder.decode(pieces[2], "UTF-8");
            String eventTypeStr = URLDecoder.decode(pieces[3], "UTF-8");
            ServiceEventKey.EventType eventType = ServiceEventKey.EventType.valueOf(eventTypeStr.toUpperCase());
            return new ServiceEventKey(new ServiceKey(namespace, service), eventType);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTmpFile(File persistTmpFile, File persistLockFile, Message message) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(persistLockFile, "rw");
             FileChannel channel = raf.getChannel();){
            FileLock lock = channel.tryLock();
            if (lock == null) {
                throw new IOException("fail to lock file " + persistTmpFile.getAbsolutePath() + ", ignore and retry later");
            }
            try {
                this.doWriteTmpFile(persistTmpFile, message);
            }
            finally {
                lock.release();
            }
        }
    }

    private void doWriteTmpFile(File persistTmpFile, Message message) throws IOException {
        if (!persistTmpFile.exists() && !persistTmpFile.createNewFile()) {
            LOG.warn("tmp file {} already exists", (Object)persistTmpFile.getAbsolutePath());
        }
        try (FileOutputStream outputFile = new FileOutputStream(persistTmpFile);){
            String jsonStr = this.printer.print(message);
            JsonNode jsonNodeTree = new ObjectMapper().readTree(jsonStr);
            String jsonAsYaml = new YAMLMapper().writeValueAsString(jsonNodeTree);
            outputFile.write(jsonAsYaml.getBytes(StandardCharsets.UTF_8));
            outputFile.flush();
        }
    }

    private Path doSaveService(ServiceEventKey svcEventKey, Message message) {
        String fileName = MessagePersistHandler.serviceKeyToFileName(svcEventKey);
        String tmpFileName = fileName + ".tmp";
        String lockFileName = fileName + ".lock";
        String persistFilePathStr = this.persistDirPath + File.separator + fileName;
        Path persistPath = FileSystems.getDefault().getPath(persistFilePathStr, new String[0]);
        File persistTmpFile = new File(this.persistDirPath + File.separator + tmpFileName);
        File persistLockFile = new File(this.persistDirPath + File.separator + lockFileName);
        try {
            if (!persistLockFile.exists() && !persistLockFile.createNewFile()) {
                LOG.warn("lock file {} already exists", (Object)persistLockFile.getAbsolutePath());
            }
            this.writeTmpFile(persistTmpFile, persistLockFile, message);
            Files.move(FileSystems.getDefault().getPath(persistTmpFile.getAbsolutePath(), new String[0]), persistPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            LOG.error("fail to write file {}", (Object)persistTmpFile, (Object)e);
            return null;
        }
        return persistPath.toAbsolutePath();
    }

    public Map<ServiceEventKey, Message> loadPersistedServices(final Message message) {
        Path curDir = Paths.get(this.persistDirPath, new String[0]);
        final HashMap<ServiceEventKey, Message> result = new HashMap<ServiceEventKey, Message>();
        try {
            Files.walkFileTree(curDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) {
                    int retryTimes;
                    Path fileNamePath = filePath.getFileName();
                    if (null == fileNamePath) {
                        return FileVisitResult.CONTINUE;
                    }
                    String fileName = fileNamePath.toString();
                    if (!REGEX_PATTERN_SERVICE.matcher(fileName).matches()) {
                        return FileVisitResult.CONTINUE;
                    }
                    ServiceEventKey svcEventKey = MessagePersistHandler.fileNameToServiceKey(fileName);
                    Message readMessage = null;
                    for (retryTimes = 0; retryTimes <= MessagePersistHandler.this.maxReadRetry; ++retryTimes) {
                        Message.Builder builder = message.newBuilderForType();
                        readMessage = MessagePersistHandler.this.loadMessage(filePath.toFile(), builder);
                        if (null != readMessage) break;
                        Utils.sleepUninterrupted(MessagePersistHandler.this.retryInterval);
                    }
                    if (null == readMessage) {
                        LOG.debug("fail to read service from {} after retry {} times", (Object)fileName, (Object)retryTimes);
                        return FileVisitResult.CONTINUE;
                    }
                    result.put(svcEventKey, readMessage);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.error("fail to visit cache directory {}", (Object)this.persistDirPath);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message loadMessage(File persistFile, Message.Builder builder) {
        if (null == persistFile || !persistFile.exists()) {
            return null;
        }
        FileInputStream inputStream2 = null;
        InputStreamReader reader = null;
        Yaml yaml = new Yaml();
        try {
            inputStream2 = new FileInputStream(persistFile);
            reader = new InputStreamReader((InputStream)inputStream2, StandardCharsets.UTF_8);
            Map jsonMap = (Map)yaml.load(reader);
            ObjectMapper jsonWriter = new ObjectMapper();
            String jsonStr = jsonWriter.writeValueAsString(jsonMap);
            this.parser.merge(jsonStr, builder);
            Message message = builder.build();
            return message;
        }
        catch (IOException e) {
            LOG.debug("fail to read file {}", (Object)persistFile.getAbsoluteFile(), (Object)e);
            Message message = null;
            return message;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.warn("fail to close reader for {}", (Object)persistFile.getAbsoluteFile(), (Object)e);
                }
            }
            if (null != inputStream2) {
                try {
                    ((InputStream)inputStream2).close();
                }
                catch (IOException e) {
                    LOG.warn("fail to close stream for {}", (Object)persistFile.getAbsoluteFile(), (Object)e);
                }
            }
        }
    }
}

