/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.aspect.controller;

import com.google.common.base.Stopwatch;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.apache.shenyu.admin.aspect.controller.ControllerMethodAdvice;
import org.apache.shenyu.admin.config.properties.DashboardProperties;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;

@Component
public class SuperAdminPasswordSafeAdvice
implements ControllerMethodAdvice {
    private final DashboardProperties properties;
    private final DashboardUserService userService;

    public SuperAdminPasswordSafeAdvice(DashboardProperties properties, DashboardUserService userService) {
        this.properties = properties;
        this.userService = userService;
    }

    @Override
    public void doPreProcess(Object bean, Method method, Stopwatch stopwatch) {
        if (!Boolean.TRUE.equals(this.properties.getEnableOnlySuperAdminPermission())) {
            return;
        }
        if (!Boolean.TRUE.equals(this.properties.getEnableSuperAdminPasswordSafe())) {
            return;
        }
        if (!SessionUtil.isAdmin()) {
            return;
        }
        RequiresPermissions permissions = (RequiresPermissions)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequiresPermissions.class);
        if (Objects.isNull(permissions) || Objects.isNull(permissions.value())) {
            return;
        }
        if (this.properties.getOnlySuperAdminPermission().stream().anyMatch(p -> Arrays.asList(permissions.value()).contains(p))) {
            this.userService.checkUserPassword(SessionUtil.visitor().getUserId());
        }
    }
}

