/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ShenyuDictDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class ShenyuDictDO
extends BaseDO {
    private static final long serialVersionUID = -3968123108441795604L;
    private String type;
    private String dictCode;
    private String dictName;
    private String dictValue;
    private String desc;
    private Integer sort;
    private Boolean enabled;

    public ShenyuDictDO() {
    }

    public ShenyuDictDO(String type, String dictCode, String dictName, String dictValue, String desc, Integer sort, Boolean enabled) {
        this.type = type;
        this.dictCode = dictCode;
        this.dictName = dictName;
        this.dictValue = dictValue;
        this.desc = desc;
        this.sort = sort;
        this.enabled = enabled;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public void setDictCode(String dictCode) {
        this.dictCode = dictCode;
    }

    public String getDictName() {
        return this.dictName;
    }

    public void setDictName(String dictName) {
        this.dictName = dictName;
    }

    public String getDictValue() {
        return this.dictValue;
    }

    public void setDictValue(String dictValue) {
        this.dictValue = dictValue;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public static ShenyuDictDOBuilder builder() {
        return new ShenyuDictDOBuilder();
    }

    public static ShenyuDictDO buildShenyuDictDO(ShenyuDictDTO shenyuDictDTO) {
        return Optional.ofNullable(shenyuDictDTO).map(item -> {
            ShenyuDictDO shenyuDictDO = ShenyuDictDO.builder().id(item.getId()).dictCode(item.getDictCode()).dictName(item.getDictName()).dictValue(item.getDictValue()).desc(item.getDesc()).enabled(item.getEnabled()).sort(item.getSort()).type(item.getType()).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                shenyuDictDO.setId(UUIDUtils.getInstance().generateShortUuid());
            }
            return shenyuDictDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShenyuDictDO that = (ShenyuDictDO)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.dictCode, that.dictCode) && Objects.equals(this.dictName, that.dictName) && Objects.equals(this.dictValue, that.dictValue) && Objects.equals(this.desc, that.desc) && Objects.equals(this.sort, that.sort) && Objects.equals(this.enabled, that.enabled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.dictCode, this.dictName, this.dictValue, this.desc, this.sort, this.enabled);
    }

    public static final class ShenyuDictDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String type;
        private String dictCode;
        private String dictName;
        private String dictValue;
        private String desc;
        private Integer sort;
        private Boolean enabled;

        private ShenyuDictDOBuilder() {
        }

        public ShenyuDictDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ShenyuDictDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public ShenyuDictDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public ShenyuDictDOBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ShenyuDictDOBuilder dictCode(String dictCode) {
            this.dictCode = dictCode;
            return this;
        }

        public ShenyuDictDOBuilder dictName(String dictName) {
            this.dictName = dictName;
            return this;
        }

        public ShenyuDictDOBuilder dictValue(String dictValue) {
            this.dictValue = dictValue;
            return this;
        }

        public ShenyuDictDOBuilder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public ShenyuDictDOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public ShenyuDictDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public ShenyuDictDO build() {
            ShenyuDictDO shenyuDictDO = new ShenyuDictDO();
            shenyuDictDO.setId(this.id);
            shenyuDictDO.setDateCreated(this.dateCreated);
            shenyuDictDO.setDateUpdated(this.dateUpdated);
            shenyuDictDO.setType(this.type);
            shenyuDictDO.setDictCode(this.dictCode);
            shenyuDictDO.setDictName(this.dictName);
            shenyuDictDO.setDictValue(this.dictValue);
            shenyuDictDO.setDesc(this.desc);
            shenyuDictDO.setSort(this.sort);
            shenyuDictDO.setEnabled(this.enabled);
            return shenyuDictDO;
        }
    }
}

