/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class PluginTemplateDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final PluginService pluginService;

    public PluginTemplateDataConfigsExportImportHandler(PluginService pluginService) {
        this.pluginService = pluginService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.PluginTemplate;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<PluginVO> pluginDataList = this.pluginService.listAllData();
        if (CollectionUtils.isNotEmpty(pluginDataList)) {
            return Optional.of(JsonUtils.toJson(pluginDataList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List pluginList = GsonUtils.getInstance().fromList(data, PluginDTO.class);
        ConfigImportResult configImportResult = this.pluginService.importData(pluginList, context);
        context.getResult().put("pluginImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("pluginImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

