/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotSwitcher;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="getRecentRouterSnapshot", summary="Get recent (32) router snapshot message")
public class GetRecentRouterSnapshot
implements BaseCommand {
    private final RouterSnapshotSwitcher routerSnapshotSwitcher;

    public GetRecentRouterSnapshot(FrameworkModel frameworkModel) {
        this.routerSnapshotSwitcher = frameworkModel.getBeanFactory().getBean(RouterSnapshotSwitcher.class);
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        return Arrays.stream(this.routerSnapshotSwitcher.cloneSnapshot()).filter(Objects::nonNull).sorted().collect(Collectors.joining("\n\n"));
    }
}

