/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.api.pu.ChannelHandlerPretender;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.remoting.api.pu.DefaultCodec;
import org.apache.dubbo.remoting.transport.codec.CodecAdapter;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyCodecAdapter;
import org.apache.dubbo.remoting.transport.netty4.NettyServerHandler;

public class NettyConfigOperator
implements ChannelOperator {
    private final Channel channel;
    private ChannelHandler handler;

    public NettyConfigOperator(NettyChannel channel, ChannelHandler handler) {
        this.channel = channel;
        this.handler = handler;
    }

    @Override
    public void configChannelHandler(List<ChannelHandler> handlerList) {
        Codec2 codec2;
        URL url = this.channel.getUrl();
        String codecName = url.getParameter("codec");
        if (StringUtils.isEmpty(codecName)) {
            codecName = url.getProtocol();
        }
        if (!((codec2 = url.getOrDefaultFrameworkModel().getExtensionLoader(Codec2.class).hasExtension(codecName) ? url.getOrDefaultFrameworkModel().getExtensionLoader(Codec2.class).getExtension(codecName) : (url.getOrDefaultFrameworkModel().getExtensionLoader(Codec.class).hasExtension(codecName) ? new CodecAdapter(url.getOrDefaultFrameworkModel().getExtensionLoader(Codec.class).getExtension(codecName)) : url.getOrDefaultFrameworkModel().getExtensionLoader(Codec2.class).getExtension("default"))) instanceof DefaultCodec)) {
            ((NettyChannel)this.channel).setCodec(codec2);
            NettyCodecAdapter codec = new NettyCodecAdapter(codec2, this.channel.getUrl(), this.handler);
            ((NettyChannel)this.channel).getNioChannel().pipeline().addLast(new io.netty.channel.ChannelHandler[]{codec.getDecoder()}).addLast(new io.netty.channel.ChannelHandler[]{codec.getEncoder()});
        }
        for (ChannelHandler handler : handlerList) {
            Object realHandler;
            if (!(handler instanceof ChannelHandlerPretender) || !((realHandler = ((ChannelHandlerPretender)handler).getRealHandler()) instanceof io.netty.channel.ChannelHandler)) continue;
            ((NettyChannel)this.channel).getNioChannel().pipeline().addLast(new io.netty.channel.ChannelHandler[]{(io.netty.channel.ChannelHandler)realHandler});
        }
        if (!this.isClientSide(this.channel)) {
            NettyServerHandler sh = new NettyServerHandler(this.channel.getUrl(), this.handler);
            ((NettyChannel)this.channel).getNioChannel().pipeline().addLast(new io.netty.channel.ChannelHandler[]{sh});
        }
    }

    private boolean isClientSide(Channel channel) {
        return channel.getUrl().getSide("").equalsIgnoreCase("consumer");
    }
}

