/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.command;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingMonitorType;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicyConfiguration;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTaskRecord;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTriggerType;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerEventType;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskExtension;
import org.apache.skywalking.oap.server.core.query.type.PprofTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.network.trace.component.command.AsyncProfilerTaskCommand;
import org.apache.skywalking.oap.server.network.trace.component.command.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.network.trace.component.command.ContinuousProfilingPolicyCommand;
import org.apache.skywalking.oap.server.network.trace.component.command.ContinuousProfilingReportCommand;
import org.apache.skywalking.oap.server.network.trace.component.command.EBPFProfilingTaskCommand;
import org.apache.skywalking.oap.server.network.trace.component.command.EBPFProfilingTaskExtensionConfig;
import org.apache.skywalking.oap.server.network.trace.component.command.PprofTaskCommand;
import org.apache.skywalking.oap.server.network.trace.component.command.ProfileTaskCommand;

public class CommandService
implements Service {
    private static final Gson GSON = new Gson();
    private final ModuleManager moduleManager;

    public CommandService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public ProfileTaskCommand newProfileTaskCommand(ProfileTask task) {
        String serialNumber = UUID.randomUUID().toString();
        return new ProfileTaskCommand(serialNumber, task.getId(), task.getEndpointName(), task.getDuration(), task.getMinDurationThreshold(), task.getDumpPeriod(), task.getMaxSamplingCount(), task.getStartTime(), task.getCreateTime());
    }

    public AsyncProfilerTaskCommand newAsyncProfileTaskCommand(AsyncProfilerTask task) {
        String serialNumber = UUID.randomUUID().toString();
        List eventNames = task.getEvents().stream().map(AsyncProfilerEventType::getName).collect(Collectors.toList());
        return new AsyncProfilerTaskCommand(serialNumber, task.getId(), task.getDuration(), eventNames, task.getExecArgs(), task.getCreateTime());
    }

    public PprofTaskCommand newPprofTaskCommand(PprofTask task) {
        String serialNumber = UUID.randomUUID().toString();
        String events = "";
        if (task.getEvents() != null) {
            events = task.getEvents().getName();
        }
        return new PprofTaskCommand(serialNumber, task.getId(), events, (long)task.getDuration(), task.getCreateTime(), task.getDumpPeriod());
    }

    public EBPFProfilingTaskCommand newEBPFProfilingTaskCommand(EBPFProfilingTaskRecord task, List<String> processId) {
        String serialNumber = UUID.randomUUID().toString();
        EBPFProfilingTaskCommand.FixedTrigger fixedTrigger = null;
        if (Objects.equals(task.getTriggerType(), EBPFProfilingTriggerType.FIXED_TIME.value())) {
            fixedTrigger = new EBPFProfilingTaskCommand.FixedTrigger(task.getFixedTriggerDuration());
        }
        return new EBPFProfilingTaskCommand(serialNumber, task.getLogicalId(), processId, task.getStartTime(), task.getLastUpdateTime(), EBPFProfilingTriggerType.valueOf(task.getTriggerType()).name(), fixedTrigger, EBPFProfilingTargetType.valueOf(task.getTargetType()).name(), this.convertExtension(task));
    }

    public ContinuousProfilingPolicyCommand newContinuousProfilingServicePolicyCommand(List<ContinuousProfilingPolicy> policy) {
        return new ContinuousProfilingPolicyCommand(UUID.randomUUID().toString(), policy.stream().map(this::convertContinuesProfilingPolicy).collect(Collectors.toList()));
    }

    public ContinuousProfilingReportCommand newContinuousProfilingReportCommand(String taskId) {
        return new ContinuousProfilingReportCommand(UUID.randomUUID().toString(), taskId);
    }

    private org.apache.skywalking.oap.server.network.trace.component.command.ContinuousProfilingPolicy convertContinuesProfilingPolicy(ContinuousProfilingPolicy policy) {
        org.apache.skywalking.oap.server.network.trace.component.command.ContinuousProfilingPolicy result = new org.apache.skywalking.oap.server.network.trace.component.command.ContinuousProfilingPolicy();
        result.setServiceName(IDManager.ServiceID.analysisId(policy.getServiceId()).getName());
        result.setUuid(policy.getUuid());
        if (StringUtil.isNotEmpty((String)policy.getConfigurationJson())) {
            ContinuousProfilingPolicyConfiguration configuration = ContinuousProfilingPolicyConfiguration.parseFromJSON(policy.getConfigurationJson());
            result.setProfiling(configuration.getTargetCheckers().entrySet().stream().collect(Collectors.toMap(c -> ((ContinuousProfilingTargetType)((Object)((Object)c.getKey()))).name(), c -> ((Map)c.getValue()).entrySet().stream().collect(Collectors.toMap(i -> ((ContinuousProfilingMonitorType)((Object)((Object)((Object)i.getKey())))).name(), i -> {
                ContinuousProfilingPolicy.Item item = new ContinuousProfilingPolicy.Item();
                item.setThreshold(((ContinuousProfilingPolicyConfiguration.CheckItem)i.getValue()).getThreshold());
                item.setPeriod(((ContinuousProfilingPolicyConfiguration.CheckItem)i.getValue()).getPeriod());
                item.setCount(((ContinuousProfilingPolicyConfiguration.CheckItem)i.getValue()).getCount());
                item.setUriList(((ContinuousProfilingPolicyConfiguration.CheckItem)i.getValue()).getUriList());
                item.setUriRegex(((ContinuousProfilingPolicyConfiguration.CheckItem)i.getValue()).getUriRegex());
                return item;
            })))));
        }
        return result;
    }

    private EBPFProfilingTaskExtensionConfig convertExtension(EBPFProfilingTaskRecord task) {
        if (StringUtil.isEmpty((String)task.getExtensionConfigJson())) {
            return null;
        }
        EBPFProfilingTaskExtension extensionConfig = (EBPFProfilingTaskExtension)GSON.fromJson(task.getExtensionConfigJson(), EBPFProfilingTaskExtension.class);
        if (CollectionUtils.isEmpty(extensionConfig.getNetworkSamplings())) {
            return null;
        }
        EBPFProfilingTaskExtensionConfig config = new EBPFProfilingTaskExtensionConfig();
        config.setNetworkSamplings(extensionConfig.getNetworkSamplings().stream().map(s -> EBPFProfilingTaskExtensionConfig.NetworkSamplingRule.builder().uriRegex(s.getUriRegex()).minDuration(s.getMinDuration()).when4xx(s.isWhen5xx()).when5xx(s.isWhen5xx()).settings(EBPFProfilingTaskExtensionConfig.CollectSettings.builder().requireCompleteRequest(s.getSettings().isRequireCompleteRequest()).maxRequestSize(s.getSettings().getMaxRequestSize()).requireCompleteResponse(s.getSettings().isRequireCompleteResponse()).maxResponseSize(s.getSettings().getMaxResponseSize()).build()).build()).collect(Collectors.toList()));
        return config;
    }
}

