/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import java.io.Serializable;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.collection.BitSet;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$;
import org.apache.spark.util.collection.OpenHashSet$Hasher$mcF$sp;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Private
public class OpenHashSet$mcF$sp
extends OpenHashSet<Object> {
    public final OpenHashSet.Hasher<Object> hasher$mcF$sp;
    public float[] _data$mcF$sp;
    private final int initialCapacity;
    private final double loadFactor;
    private final ClassTag<Object> evidence$1;

    @Override
    public OpenHashSet.Hasher<Object> hasher$mcF$sp() {
        return this.hasher$mcF$sp;
    }

    @Override
    public OpenHashSet.Hasher<Object> hasher() {
        return this.hasher$mcF$sp();
    }

    @Override
    public float[] _data$mcF$sp() {
        return this._data$mcF$sp;
    }

    public float[] _data() {
        return this._data$mcF$sp();
    }

    @Override
    public void _data$mcF$sp_$eq(float[] x$1) {
        this._data$mcF$sp = x$1;
    }

    public void _data_$eq(float[] x$1) {
        this._data$mcF$sp_$eq(x$1);
    }

    @Override
    public boolean contains(float k) {
        return this.contains$mcF$sp(k);
    }

    @Override
    public boolean contains$mcF$sp(float k) {
        return this.getPos$mcF$sp(k) != OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public void add(float k) {
        this.add$mcF$sp(k);
    }

    @Override
    public void add$mcF$sp(float k) {
        this.addWithoutResize$mcF$sp(k);
        this.rehashIfNeeded$mcF$sp(k, OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$grow(), OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$move());
    }

    @Override
    public OpenHashSet<Object> union(OpenHashSet<Object> other) {
        return this.union$mcF$sp(other);
    }

    @Override
    public OpenHashSet<Object> union$mcF$sp(OpenHashSet<Object> other) {
        Iterator<Object> iterator = other.iterator();
        while (iterator.hasNext()) {
            this.add$mcF$sp(BoxesRunTime.unboxToFloat((Object)iterator.next()));
        }
        return this;
    }

    @Override
    public boolean keyExistsAtPos(float k, int pos) {
        return this.keyExistsAtPos$mcF$sp(k, pos);
    }

    @Override
    public boolean keyExistsAtPos$mcF$sp(float k, int pos) {
        return ((Object)BoxesRunTime.boxToFloat((float)this._data()[pos])).equals(BoxesRunTime.boxToFloat((float)k));
    }

    @Override
    public int addWithoutResize(float k) {
        return this.addWithoutResize$mcF$sp(k);
    }

    @Override
    public int addWithoutResize$mcF$sp(float k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcF$sp(k)) & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
        int delta = 1;
        while (true) {
            if (!this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos)) {
                this._data()[pos] = k;
                this.org$apache$spark$util$collection$OpenHashSet$$_bitset().set(pos);
                this.org$apache$spark$util$collection$OpenHashSet$$_size_$eq(this.org$apache$spark$util$collection$OpenHashSet$$_size() + 1);
                return pos | OpenHashSet$.MODULE$.NONEXISTENCE_MASK();
            }
            if (this.keyExistsAtPos$mcF$sp(k, pos)) {
                return pos;
            }
            pos = pos + delta & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
            ++delta;
        }
    }

    @Override
    public void rehashIfNeeded(float k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehashIfNeeded$mcF$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehashIfNeeded$mcF$sp(float k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        if (this.org$apache$spark$util$collection$OpenHashSet$$_size() > this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold()) {
            this.rehash$mcF$sp(k, allocateFunc, moveFunc);
            return;
        }
    }

    @Override
    public int getPos(float k) {
        return this.getPos$mcF$sp(k);
    }

    @Override
    public int getPos$mcF$sp(float k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcF$sp(k)) & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
        int delta = 1;
        while (this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos)) {
            if (this.keyExistsAtPos$mcF$sp(k, pos)) {
                return pos;
            }
            pos = pos + delta & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
            ++delta;
        }
        return OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public float getValue(int pos) {
        return this.getValue$mcF$sp(pos);
    }

    @Override
    public float getValue$mcF$sp(int pos) {
        return this._data()[pos];
    }

    @Override
    public float getValueSafe(int pos) {
        return this.getValueSafe$mcF$sp(pos);
    }

    @Override
    public float getValueSafe$mcF$sp(int pos) {
        Predef$.MODULE$.assert(this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos));
        return this._data()[pos];
    }

    @Override
    public void rehash(float k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehash$mcF$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehash$mcF$sp(float k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        int newCapacity = this.org$apache$spark$util$collection$OpenHashSet$$_capacity() * 2;
        Predef$.MODULE$.require(newCapacity > 0 && newCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Can't contain more than ").append((int)($this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)OpenHashSet$.MODULE$.MAX_CAPACITY())).append(" elements").toString());
        allocateFunc.apply$mcVI$sp(newCapacity);
        BitSet newBitset = new BitSet(newCapacity);
        float[] newData = (float[])this.org$apache$spark$util$collection$OpenHashSet$$evidence$1.newArray(newCapacity);
        int newMask = newCapacity - 1;
        for (int oldPos = 0; oldPos < this.capacity(); ++oldPos) {
            if (!this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(oldPos)) continue;
            float key = this._data()[oldPos];
            int newPos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcF$sp(key)) & newMask;
            int i = 1;
            boolean keepGoing = true;
            while (keepGoing) {
                if (!newBitset.get(newPos)) {
                    newData[newPos] = key;
                    newBitset.set(newPos);
                    moveFunc.apply$mcVII$sp(oldPos, newPos);
                    keepGoing = false;
                    continue;
                }
                int delta = i++;
                newPos = newPos + delta & newMask;
            }
        }
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset_$eq(newBitset);
        this._data_$eq(newData);
        this.org$apache$spark$util$collection$OpenHashSet$$_capacity_$eq(newCapacity);
        this.org$apache$spark$util$collection$OpenHashSet$$_mask_$eq(newMask);
        this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold_$eq((int)(this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)newCapacity));
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public OpenHashSet$mcF$sp(int initialCapacity, double loadFactor, ClassTag<Object> evidence$1) {
        OpenHashSet.Hasher hasher;
        ClassTag mt;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.evidence$1 = evidence$1;
        super(initialCapacity, loadFactor, evidence$1);
        Predef$.MODULE$.require(initialCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$1);
        Predef$.MODULE$.require(initialCapacity >= 0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$2);
        Predef$.MODULE$.require(loadFactor < 1.0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$3);
        Predef$.MODULE$.require(loadFactor > 0.0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$4);
        ClassTag classTag = mt = package$.MODULE$.classTag(this.org$apache$spark$util$collection$OpenHashSet$$evidence$1);
        ClassTag classTag2 = ClassTag$.MODULE$.Long();
        if (!(classTag != null ? !classTag.equals(classTag2) : classTag2 != null)) {
            hasher = new OpenHashSet.LongHasher();
        } else {
            ClassTag classTag3 = mt;
            ClassTag classTag4 = ClassTag$.MODULE$.Int();
            if (!(classTag3 != null ? !classTag3.equals(classTag4) : classTag4 != null)) {
                hasher = new OpenHashSet.IntHasher();
            } else {
                ClassTag classTag5 = mt;
                ClassTag classTag6 = ClassTag$.MODULE$.Double();
                if (!(classTag5 != null ? !classTag5.equals(classTag6) : classTag6 != null)) {
                    hasher = new OpenHashSet.DoubleHasher();
                } else {
                    ClassTag classTag7 = mt;
                    ClassTag classTag8 = ClassTag$.MODULE$.Float();
                    hasher = !(classTag7 != null ? !classTag7.equals(classTag8) : classTag8 != null) ? new OpenHashSet.FloatHasher() : new OpenHashSet$Hasher$mcF$sp();
                }
            }
        }
        this.hasher$mcF$sp = hasher;
        this.org$apache$spark$util$collection$OpenHashSet$$_capacity = this.org$apache$spark$util$collection$OpenHashSet$$nextPowerOf2(initialCapacity);
        this.org$apache$spark$util$collection$OpenHashSet$$_mask = this.org$apache$spark$util$collection$OpenHashSet$$_capacity() - 1;
        this.org$apache$spark$util$collection$OpenHashSet$$_size = 0;
        this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold = (int)(loadFactor * (double)this.org$apache$spark$util$collection$OpenHashSet$$_capacity());
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset = new BitSet(this.org$apache$spark$util$collection$OpenHashSet$$_capacity());
        this._data_$eq(evidence$1.newArray(this.org$apache$spark$util$collection$OpenHashSet$$_capacity()));
    }

    public OpenHashSet$mcF$sp(int initialCapacity, ClassTag<Object> evidence$2) {
        this(initialCapacity, 0.7, evidence$2);
    }

    public OpenHashSet$mcF$sp(ClassTag<Object> evidence$3) {
        this(64, evidence$3);
    }
}

