/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.nearest_neighbor;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.sparkproject.dmg.pmml.CompareFunction;
import org.sparkproject.dmg.pmml.ComparisonField;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.FieldName;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.FieldNameAdapter;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="KNNInput", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_1)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"field", "fieldWeight", "compareFunction", "extensions"})
public class KNNInput
extends ComparisonField<KNNInput>
implements HasExtensions<KNNInput> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private FieldName field;
    @XmlAttribute(name="fieldWeight")
    @JsonProperty(value="fieldWeight")
    private Double fieldWeight;
    @XmlAttribute(name="compareFunction")
    @JsonProperty(value="compareFunction")
    private CompareFunction compareFunction;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final Double DEFAULT_FIELD_WEIGHT = 1.0;
    private static final long serialVersionUID = 67305485L;

    public KNNInput() {
    }

    public KNNInput(@Property(value="field") FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getField() {
        return this.field;
    }

    @Override
    public KNNInput setField(@Property(value="field") FieldName field) {
        this.field = field;
        return this;
    }

    @Override
    public Double getFieldWeight() {
        if (this.fieldWeight == null) {
            return DEFAULT_FIELD_WEIGHT;
        }
        return this.fieldWeight;
    }

    @Override
    public KNNInput setFieldWeight(@Property(value="fieldWeight") Double fieldWeight) {
        this.fieldWeight = fieldWeight;
        return this;
    }

    @Override
    public CompareFunction getCompareFunction() {
        return this.compareFunction;
    }

    @Override
    public KNNInput setCompareFunction(@Property(value="compareFunction") CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public KNNInput addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

