/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyLogger {
    private static final Logger logger = LoggerFactory.getLogger(NettyLogger.class);
    private final LoggingHandler loggingHandler = logger.isTraceEnabled() ? new LoggingHandler(NettyLogger.class, LogLevel.TRACE) : (logger.isDebugEnabled() ? new NoContentLoggingHandler(NettyLogger.class, LogLevel.DEBUG) : null);

    public LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private static class NoContentLoggingHandler
    extends LoggingHandler {
        NoContentLoggingHandler(Class<?> clazz, LogLevel level) {
            super(clazz, level);
        }

        protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
            if (arg instanceof ByteBuf) {
                return this.format(ctx, eventName) + " " + ((ByteBuf)arg).readableBytes() + "B";
            }
            if (arg instanceof ByteBufHolder) {
                return this.format(ctx, eventName) + " " + ((ByteBufHolder)arg).content().readableBytes() + "B";
            }
            return super.format(ctx, eventName, arg);
        }
    }
}

