/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdParallelism;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;

public class HiveRelMdParallelism
extends RelMdParallelism {
    private final Double maxSplitSize;

    public HiveRelMdParallelism(Double maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    public RelMetadataProvider getMetadataProvider() {
        return ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)this, (Method[])new Method[]{BuiltInMethod.IS_PHASE_TRANSITION.method, BuiltInMethod.SPLIT_COUNT.method});
    }

    public Boolean isPhaseTransition(HiveJoin join, RelMetadataQuery mq) {
        return join.isPhaseTransition();
    }

    public Boolean isPhaseTransition(HiveSortLimit sort, RelMetadataQuery mq) {
        return true;
    }

    public Integer splitCount(HiveJoin join, RelMetadataQuery mq) {
        return join.getSplitCount();
    }

    public Integer splitCount(HiveTableScan scan, RelMetadataQuery mq) {
        Integer splitCount;
        RelOptHiveTable table = (RelOptHiveTable)scan.getTable();
        List<String> bucketCols = table.getHiveTableMD().getBucketCols();
        if (bucketCols != null && !bucketCols.isEmpty()) {
            splitCount = table.getHiveTableMD().getNumBuckets();
        } else {
            splitCount = this.splitCountRepartition(scan, mq);
            if (splitCount == null) {
                throw new RuntimeException("Could not get split count for table: " + scan.getTable().getQualifiedName());
            }
        }
        return splitCount;
    }

    public Integer splitCount(RelNode rel, RelMetadataQuery mq) {
        Boolean newPhase = mq.isPhaseTransition(rel);
        if (newPhase == null) {
            return null;
        }
        if (newPhase.booleanValue()) {
            return this.splitCountRepartition(rel, mq);
        }
        Integer splitCount = 0;
        for (RelNode input : rel.getInputs()) {
            splitCount = splitCount + mq.splitCount(input);
        }
        return splitCount;
    }

    public Integer splitCountRepartition(RelNode rel, RelMetadataQuery mq) {
        Double averageRowSize = mq.getAverageRowSize(rel);
        Double rowCount = mq.getRowCount(rel);
        if (averageRowSize == null || rowCount == null) {
            return null;
        }
        Double totalSize = averageRowSize * rowCount;
        Double splitCount = totalSize / this.maxSplitSize;
        return splitCount.intValue();
    }
}

