/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SparkALS$ {
    public static final SparkALS$ MODULE$ = new SparkALS$();
    private static int M = 0;
    private static int U = 0;
    private static int F = 0;
    private static int ITERATIONS = 0;
    private static final double LAMBDA = 0.01;

    public int M() {
        return M;
    }

    public void M_$eq(int x$1) {
        M = x$1;
    }

    public int U() {
        return U;
    }

    public void U_$eq(int x$1) {
        U = x$1;
    }

    public int F() {
        return F;
    }

    public void F_$eq(int x$1) {
        F = x$1;
    }

    public int ITERATIONS() {
        return ITERATIONS;
    }

    public void ITERATIONS_$eq(int x$1) {
        ITERATIONS = x$1;
    }

    public double LAMBDA() {
        return LAMBDA;
    }

    public RealMatrix generateR() {
        RealMatrix mh = this.randomMatrix(this.M(), this.F());
        RealMatrix uh = this.randomMatrix(this.U(), this.F());
        return mh.multiply(uh.transpose());
    }

    public double rmse(RealMatrix targetR, RealVector[] ms, RealVector[] us) {
        Array2DRowRealMatrix r = new Array2DRowRealMatrix(this.M(), this.U());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), MODULE$.U()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> r.setEntry(i, j, ms[i].dotProduct(us[j]))));
        RealMatrix diffs = r.subtract(targetR);
        DoubleRef sumSqs = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), MODULE$.U()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            double diff = diffs.getEntry(i, j);
            sumSqs$1.elem += diff * diff;
        }));
        return package$.MODULE$.sqrt(sumSqs.elem / ((double)this.M() * (double)this.U()));
    }

    public RealVector update(int i, RealVector m, RealVector[] us, RealMatrix R) {
        int U = us.length;
        int F = us[0].getDimension();
        ObjectRef XtX = ObjectRef.create((Object)new Array2DRowRealMatrix(F, F));
        ObjectRef Xty = ObjectRef.create((Object)new ArrayRealVector(F));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), U).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            RealVector u = us[j];
            XtX$1.elem = ((RealMatrix)XtX$1.elem).add(u.outerProduct(u));
            Xty$1.elem = ((RealVector)Xty$1.elem).add(u.mapMultiply(R.getEntry(i, j)));
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), F).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)d -> ((RealMatrix)XtX$1.elem).addToEntry(d, d, MODULE$.LAMBDA() * (double)U));
        return new CholeskyDecomposition((RealMatrix)XtX.elem).getSolver().solve((RealVector)Xty.elem);
    }

    public void showWarning() {
        System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of ALS and is given as an example!\n        |Please use org.apache.spark.ml.recommendation.ALS\n        |for more conventional use.\n      ")));
    }

    public void main(String[] args) {
        Object object;
        IntRef slices = IntRef.create((int)0);
        IndexedSeq options = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)i -> SparkALS$.$anonfun$main$1(args, BoxesRunTime.unboxToInt((Object)i)));
        Option[] optionArray = (Option[])options.toArray(ClassTag$.MODULE$.apply(Option.class));
        if (optionArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)optionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 5) == 0) {
            Option m = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            Option u = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            Option f = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
            Option iters = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3);
            Option slices_ = (Option)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 4);
            this.M_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)m.getOrElse((Function0 & Serializable)() -> "100"))));
            this.U_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)u.getOrElse((Function0 & Serializable)() -> "500"))));
            this.F_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)f.getOrElse((Function0 & Serializable)() -> "10"))));
            this.ITERATIONS_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)iters.getOrElse((Function0 & Serializable)() -> "5"))));
            slices.elem = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)slices_.getOrElse((Function0 & Serializable)() -> "2")));
        } else {
            System.err.println("Usage: SparkALS [M] [U] [F] [iters] [partitions]");
            System.exit(1);
        }
        this.showWarning();
        Predef$.MODULE$.println((Object)("Running with M=" + this.M() + ", U=" + this.U() + ", F=" + this.F() + ", iters=" + this.ITERATIONS()));
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SparkALS").getOrCreate();
        SparkContext sc = spark.sparkContext();
        RealMatrix R = this.generateR();
        ObjectRef ms = ObjectRef.create((Object)((RealVector[])Array$.MODULE$.fill(this.M(), (Function0 & Serializable)() -> MODULE$.randomVector(MODULE$.F()), ClassTag$.MODULE$.apply(RealVector.class))));
        ObjectRef us = ObjectRef.create((Object)((RealVector[])Array$.MODULE$.fill(this.U(), (Function0 & Serializable)() -> MODULE$.randomVector(MODULE$.F()), ClassTag$.MODULE$.apply(RealVector.class))));
        Broadcast Rc = sc.broadcast((Object)R, ClassTag$.MODULE$.apply(RealMatrix.class));
        ObjectRef msb = ObjectRef.create((Object)sc.broadcast((Object)((RealVector[])ms.elem), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(RealVector.class))));
        ObjectRef usb = ObjectRef.create((Object)sc.broadcast((Object)((RealVector[])us.elem), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(RealVector.class))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)iter -> {
            Predef$.MODULE$.println((Object)("Iteration " + iter + ":"));
            ms$2.elem = (RealVector[])sc.parallelize((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), MODULE$.M()), slices$1.elem, (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)i -> SparkALS$.MODULE$.update(BoxesRunTime.unboxToInt((Object)i), ((RealVector[])((Broadcast)msb.elem).value())[BoxesRunTime.unboxToInt((Object)i)], (RealVector[])((Broadcast)usb.elem).value(), (RealMatrix)Rc.value()), ClassTag$.MODULE$.apply(RealVector.class)).collect();
            msb$1.elem = sc.broadcast((Object)((RealVector[])ms$2.elem), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(RealVector.class)));
            us$3.elem = (RealVector[])sc.parallelize((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), MODULE$.U()), slices$1.elem, (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)i -> SparkALS$.MODULE$.update(BoxesRunTime.unboxToInt((Object)i), ((RealVector[])((Broadcast)usb.elem).value())[BoxesRunTime.unboxToInt((Object)i)], (RealVector[])((Broadcast)msb.elem).value(), ((RealMatrix)Rc.value()).transpose()), ClassTag$.MODULE$.apply(RealVector.class)).collect();
            usb$1.elem = sc.broadcast((Object)((RealVector[])us$3.elem), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(RealVector.class)));
            Predef$.MODULE$.println((Object)("RMSE = " + MODULE$.rmse(R, (RealVector[])ms$2.elem, (RealVector[])us$3.elem)));
        });
        spark.stop();
    }

    private RealVector randomVector(int n) {
        return new ArrayRealVector((double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> package$.MODULE$.random(), (ClassTag)ClassTag$.MODULE$.Double()));
    }

    private RealMatrix randomMatrix(int rows, int cols) {
        return new Array2DRowRealMatrix((double[][])Array$.MODULE$.fill(rows, cols, (Function0)(JFunction0.mcD.sp & Serializable)() -> package$.MODULE$.random(), (ClassTag)ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ Option $anonfun$main$1(String[] args$1, int i) {
        if (i < args$1.length) {
            return new Some((Object)args$1[i]);
        }
        return None$.MODULE$;
    }

    private SparkALS$() {
    }
}

