/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkEnv$;
import org.apache.spark.api.python.PythonWorkerLogCapture$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.PythonWorkerLogBlockIdGenerator;
import org.apache.spark.storage.PythonWorkerLogLine;
import org.apache.spark.storage.RollingLogWriter;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d!\u0002\r\u001a\u0001e\u0019\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011u\u0002!\u0011!Q\u0001\nIBQA\u0010\u0001\u0005\u0002}Bq\u0001\u0012\u0001C\u0002\u0013%Q\t\u0003\u0004`\u0001\u0001\u0006IA\u0012\u0005\u0006A\u0002!\t!\u0019\u0005\u0006U\u0002!\ta\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006g\u0002!I\u0001\u001e\u0005\u0006m\u0002!Ia\u001e\u0004\u0005u\u0002!1\u0010\u0003\u0005}\u0017\t\u0005\t\u0015!\u0003c\u0011\u0015q4\u0002\"\u0001~\u0011!\t\u0019a\u0003Q\u0001\n\u0005\u0015\u0001\u0002CA\u0006\u0017\u0001\u0006I!!\u0004\t\u0011\u0005e1\u0002)Q\u0005\u00037Aq!a\n\f\t\u0003\nI\u0003C\u0004\u0002(-!\t%!\r\t\r\u0005}2\u0002\"\u0011s\u000f)\t\t%GA\u0001\u0012\u0003I\u00121\t\u0004\n1e\t\t\u0011#\u0001\u001a\u0003\u000bBaAP\u000b\u0005\u0002\u0005\u001d\u0003\"CA%+E\u0005I\u0011AA&\u0005Y\u0001\u0016\u0010\u001e5p]^{'o[3s\u0019><7)\u00199ukJ,'B\u0001\u000e\u001c\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u0011A$H\u0001\u0004CBL'B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0014\u0007\u0001!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[u\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003_1\u0012q\u0001T8hO&tw-A\u0005tKN\u001c\u0018n\u001c8JI\u000e\u0001\u0001CA\u001a;\u001d\t!\u0004\b\u0005\u00026M5\taG\u0003\u00028c\u00051AH]8pizJ!!\u000f\u0014\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s\u0019\n\u0011\u0002\\8h\u001b\u0006\u00148.\u001a:\u0002\rqJg.\u001b;?)\r\u0001%i\u0011\t\u0003\u0003\u0002i\u0011!\u0007\u0005\u0006a\r\u0001\rA\r\u0005\b{\r\u0001\n\u00111\u00013\u0003A9xN]6fe2{wm\u0016:ji\u0016\u00148/F\u0001G!\u00119eJ\r)\u000e\u0003!S!!\u0013&\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002L\u0019\u0006!Q\u000f^5m\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014%\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003&#NK\u0016B\u0001*'\u0005\u0019!V\u000f\u001d7feA\u0011AkV\u0007\u0002+*\u0011a+H\u0001\bgR|'/Y4f\u0013\tAVK\u0001\tS_2d\u0017N\\4M_\u001e<&/\u001b;feB\u0011!,X\u0007\u00027*\u0011A\fS\u0001\u0007CR|W.[2\n\u0005y[&AC!u_6L7\rT8oO\u0006\tro\u001c:lKJdunZ,sSR,'o\u001d\u0011\u0002\u001f]\u0014\u0018\r]%oaV$8\u000b\u001e:fC6$\"A\u00195\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015d\u0015AA5p\u0013\t9GMA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"B5\u0007\u0001\u0004\u0011\u0017aC5oaV$8\u000b\u001e:fC6\fQD]3n_Z,\u0017I\u001c3DY>\u001cXmV8sW\u0016\u0014Hj\\4Xe&$XM\u001d\u000b\u0003Y>\u0004\"!J7\n\u000594#\u0001B+oSRDQ\u0001]\u0004A\u0002I\n\u0001b^8sW\u0016\u0014\u0018\nZ\u0001\u0010G2|7/Z!mY^\u0013\u0018\u000e^3sgR\tA.\u0001\u000bhKR|%o\u0011:fCR,Gj\\4Xe&$XM\u001d\u000b\u0003!VDQ\u0001]\u0005A\u0002I\na\u0002\u001d:pG\u0016\u001c8\u000fT8h\u0019&tW\r\u0006\u00023q\")\u0011P\u0003a\u0001e\u0005!A.\u001b8f\u0005q\u0019\u0015\r\u001d;ve\u0016<vN]6fe2{wm]%oaV$8\u000b\u001e:fC6\u001c\"a\u00032\u0002\u0005%tGc\u0001@\u0002\u0002A\u0011qpC\u0007\u0002\u0001!)A0\u0004a\u0001E\u00061!/Z1eKJ\u00042aYA\u0004\u0013\r\tI\u0001\u001a\u0002\u000f\u0005V4g-\u001a:fIJ+\u0017\rZ3s\u0003\u0011!X-\u001c9\u0011\u000b\u0015\ny!a\u0005\n\u0007\u0005EaEA\u0003BeJ\f\u0017\u0010E\u0002&\u0003+I1!a\u0006'\u0005\u0011\u0011\u0015\u0010^3\u0002\r\t,hMZ3s!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\u0019\u0006\u0019a.[8\n\t\u0005\u0015\u0012q\u0004\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018\u0001\u0002:fC\u0012$\"!a\u000b\u0011\u0007\u0015\ni#C\u0002\u00020\u0019\u00121!\u00138u)!\tY#a\r\u00028\u0005m\u0002bBA\u001b%\u0001\u0007\u0011QB\u0001\u0002E\"9\u0011\u0011\b\nA\u0002\u0005-\u0012aA8gM\"9\u0011Q\b\nA\u0002\u0005-\u0012a\u00017f]\u0006)1\r\\8tK\u00061\u0002+\u001f;i_:<vN]6fe2{wmQ1qiV\u0014X\r\u0005\u0002B+M\u0011Q\u0003\n\u000b\u0003\u0003\u0007\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA'U\r\u0011\u0014qJ\u0016\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&A\u0005v]\u000eDWmY6fI*\u0019\u00111\f\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002`\u0005U#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class PythonWorkerLogCapture
implements Logging {
    private final String sessionId;
    public final String org$apache$spark$api$python$PythonWorkerLogCapture$$logMarker;
    private final ConcurrentHashMap<String, Tuple2<RollingLogWriter, AtomicLong>> workerLogWriters;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String $lessinit$greater$default$2() {
        return PythonWorkerLogCapture$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<String, Tuple2<RollingLogWriter, AtomicLong>> workerLogWriters() {
        return this.workerLogWriters;
    }

    public InputStream wrapInputStream(InputStream inputStream) {
        return new CaptureWorkerLogsInputStream(inputStream);
    }

    public void removeAndCloseWorkerLogWriter(String workerId) {
        Option$.MODULE$.apply(this.workerLogWriters().remove(workerId)).foreach((Function1 & Serializable)x0$1 -> {
            PythonWorkerLogCapture.$anonfun$removeAndCloseWorkerLogWriter$1(this, workerId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void closeAllWriters() {
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.workerLogWriters()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            PythonWorkerLogCapture.$anonfun$closeAllWriters$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.workerLogWriters().clear();
    }

    private Tuple2<RollingLogWriter, AtomicLong> getOrCreateLogWriter(String workerId) {
        return this.workerLogWriters().computeIfAbsent(workerId, x$1 -> {
            BlockManager qual$1 = SparkEnv$.MODULE$.get().blockManager();
            PythonWorkerLogBlockIdGenerator x$12 = new PythonWorkerLogBlockIdGenerator($this.sessionId, workerId);
            long x$2 = qual$1.getRollingLogWriter$default$2();
            RollingLogWriter logWriter = qual$1.getRollingLogWriter(x$12, x$2);
            return new Tuple2((Object)logWriter, (Object)new AtomicLong());
        });
    }

    public String org$apache$spark$api$python$PythonWorkerLogCapture$$processLogLine(String line) {
        int markerIndex = line.indexOf(this.org$apache$spark$api$python$PythonWorkerLogCapture$$logMarker + ":");
        if (markerIndex >= 0) {
            String prefix = line.substring(0, markerIndex);
            String markerAndJson = line.substring(markerIndex);
            String[] parts = markerAndJson.split(":", 3);
            if (parts.length >= 3) {
                String workerId = parts[1];
                String json = parts[2];
                try {
                    if (json.isEmpty()) {
                        this.removeAndCloseWorkerLogWriter(workerId);
                    } else {
                        Tuple2<RollingLogWriter, AtomicLong> tuple2 = this.getOrCreateLogWriter(workerId);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        RollingLogWriter writer = (RollingLogWriter)tuple2._1();
                        AtomicLong seqId = (AtomicLong)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)writer, (Object)seqId);
                        RollingLogWriter writer2 = (RollingLogWriter)tuple22._1();
                        AtomicLong seqId2 = (AtomicLong)tuple22._2();
                        writer2.writeLog(new PythonWorkerLogLine(System.currentTimeMillis(), seqId2.getAndIncrement(), json), writer2.writeLog$default$2());
                    }
                }
                catch (Exception e) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write log for worker ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PYTHON_WORKER_ID, workerId)}))), (Throwable)e);
                }
            }
            return prefix;
        }
        return line + System.lineSeparator();
    }

    public static final /* synthetic */ void $anonfun$removeAndCloseWorkerLogWriter$1(PythonWorkerLogCapture $this, String workerId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            RollingLogWriter writer = (RollingLogWriter)tuple2._1();
            try {
                writer.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close log writer for worker ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.PYTHON_WORKER_ID, workerId$1)}))), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$closeAllWriters$1(PythonWorkerLogCapture $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String workerId = (String)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 != null) {
                BoxedUnit boxedUnit;
                RollingLogWriter writer = (RollingLogWriter)tuple22._1();
                try {
                    writer.close();
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Exception e) {
                    $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close log writer for worker ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.PYTHON_WORKER_ID, workerId)}))), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public PythonWorkerLogCapture(String sessionId, String logMarker) {
        this.sessionId = sessionId;
        this.org$apache$spark$api$python$PythonWorkerLogCapture$$logMarker = logMarker;
        Logging.$init$((Logging)this);
        this.workerLogWriters = new ConcurrentHashMap();
    }

    private class CaptureWorkerLogsInputStream
    extends InputStream {
        private final BufferedReader reader;
        private final byte[] temp;
        private ByteBuffer buffer;

        @Override
        public int read() {
            int n = this.read(this.temp);
            if (n <= 0) {
                return -1;
            }
            return this.temp[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.buffer.hasRemaining()) {
                ByteBuffer buf = ByteBuffer.wrap(b, off, len);
                int remaining = Math.min(this.buffer.remaining(), buf.remaining());
                buf.put(buf.position(), this.buffer, this.buffer.position(), remaining);
                this.buffer.position(this.buffer.position() + remaining);
                return remaining;
            }
            String line = this.reader.readLine();
            if (line == null) {
                this.org$apache$spark$api$python$PythonWorkerLogCapture$CaptureWorkerLogsInputStream$$$outer().closeAllWriters();
                return -1;
            }
            Object processedContent = line.contains(this.org$apache$spark$api$python$PythonWorkerLogCapture$CaptureWorkerLogsInputStream$$$outer().org$apache$spark$api$python$PythonWorkerLogCapture$$logMarker + ":") ? this.org$apache$spark$api$python$PythonWorkerLogCapture$CaptureWorkerLogsInputStream$$$outer().org$apache$spark$api$python$PythonWorkerLogCapture$$processLogLine(line) : line + System.lineSeparator();
            this.buffer = ByteBuffer.wrap(((String)processedContent).getBytes(StandardCharsets.ISO_8859_1));
            return this.read(b, off, len);
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            finally {
                this.org$apache$spark$api$python$PythonWorkerLogCapture$CaptureWorkerLogsInputStream$$$outer().closeAllWriters();
            }
        }

        public /* synthetic */ PythonWorkerLogCapture org$apache$spark$api$python$PythonWorkerLogCapture$CaptureWorkerLogsInputStream$$$outer() {
            return PythonWorkerLogCapture.this;
        }

        public CaptureWorkerLogsInputStream(InputStream in) {
            if (PythonWorkerLogCapture.this == null) {
                throw null;
            }
            this.reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.ISO_8859_1));
            this.temp = new byte[1];
            this.buffer = ByteBuffer.allocate(0);
        }
    }
}

